/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.general;

import com.thaiopensource.validate.ValidationDriver;
import fr.lip6.move.pnml.framework.general.AbstractPnmlImportExport;
import fr.lip6.move.pnml.framework.general.ImportCustomPNMLFileType;
import fr.lip6.move.pnml.framework.general.OfficialPNMLFileType;
import fr.lip6.move.pnml.framework.general.PNMLFileType;
import fr.lip6.move.pnml.framework.hlapi.HLAPIClass;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.exception.BadFileFormatException;
import fr.lip6.move.pnml.framework.utils.exception.InvocationFailedException;
import fr.lip6.move.pnml.framework.utils.exception.OCLValidationFailed;
import fr.lip6.move.pnml.framework.utils.exception.OtherException;
import fr.lip6.move.pnml.framework.utils.exception.UnhandledNetType;
import fr.lip6.move.pnml.framework.utils.exception.ValidationFailedException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class PnmlExport
extends AbstractPnmlImportExport {
    private static final String VALIDATION_AGAINST_GRAMMAR = "Validation against grammar...";
    private static final String WRITING_TO_PNML_FILE_OK = "Writing to PNML file ok";
    private static final String TO_PNML = "toPNML";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private File out;

    public PnmlExport() {
        super("export", null);
    }

    public PnmlExport(String filepath) {
        super("export", filepath);
    }

    public final void exportObject(HLAPIClass object, String filepath) throws UnhandledNetType, OCLValidationFailed, IOException, ValidationFailedException, BadFileFormatException, OtherException {
        this.out = new File(filepath);
        String classname = object.getClass().getCanonicalName();
        PNMLFileType otype = OfficialPNMLFileType.getByClassName(classname);
        if (otype == null && this.newTypeFilePath != null) {
            ImportCustomPNMLFileType impo = new ImportCustomPNMLFileType(this.newTypeFilePath);
            otype = impo.getByClassName(classname);
        }
        if (otype == null) {
            this.log.error("type " + object.getClass().getName() + " is unknown, we are expecting a HLAPIRootClass (like PetriNetDocHLAPI) object of a known package.");
            throw new UnhandledNetType("type " + object.getClass().getName() + " is unknown");
        }
        this.doWork(object, otype.getRngUrl());
    }

    public final void exportObject(HLAPIClass object, String filepath, boolean usePrettyPrint) throws UnhandledNetType, OCLValidationFailed, IOException, ValidationFailedException, BadFileFormatException, OtherException {
        ModelRepository.getInstance().setPrettyPrintStatus(usePrettyPrint);
        this.exportObject(object, filepath);
    }

    public void exportObject(EObject object, String filepath) throws UnhandledNetType, OCLValidationFailed, IOException, ValidationFailedException, BadFileFormatException, OtherException, InvocationFailedException {
        this.out = new File(filepath);
        String classname = object.eClass().getInstanceClassName();
        PNMLFileType otype = OfficialPNMLFileType.getByNativeClassName(classname);
        if (otype == null && this.newTypeFilePath != null) {
            ImportCustomPNMLFileType impo = new ImportCustomPNMLFileType(this.newTypeFilePath);
            otype = impo.getByClassName(classname);
        }
        if (otype == null) {
            this.log.error("type " + object.getClass().getCanonicalName() + " is unknown, we are expecting a PN root class (like PetriNetDoc) object of a known package.");
            throw new UnhandledNetType("type " + object.getClass().getCanonicalName() + " is unknown");
        }
        this.doWork(object, classname, otype.getRngUrl());
    }

    public void exportObject(EObject object, String filepath, boolean usePrettyPrint) throws UnhandledNetType, OCLValidationFailed, IOException, ValidationFailedException, BadFileFormatException, OtherException, InvocationFailedException {
        ModelRepository.getInstance().setPrettyPrintStatus(usePrettyPrint);
        this.exportObject(object, filepath);
    }

    private void doWork(HLAPIClass pndoc, String schemafile) throws OCLValidationFailed, IOException, ValidationFailedException {
        this.oclChecking(pndoc);
        this.log.trace("OCL ok, writting temporary file");
        FileOutputStream fos = new FileOutputStream(this.out);
        FileChannel fc = fos.getChannel();
        pndoc.toPNML(fc);
        this.log.trace(WRITING_TO_PNML_FILE_OK);
        fc.close();
        fos.close();
        this.log.trace(VALIDATION_AGAINST_GRAMMAR);
        this.rngGrammarValidation(schemafile, ValidationDriver.uriOrFileInputSource((String)this.out.getAbsolutePath()));
    }

    private void doWork(EObject eObject, String classname, String schemafile) throws InvocationFailedException, IOException, ValidationFailedException {
        block10: {
            Class<?> c;
            this.log.trace("OCL check disabled in this case.");
            try {
                c = Class.forName(classname);
            }
            catch (ClassNotFoundException e1) {
                throw new InvocationFailedException(e1.getMessage(), e1.getCause());
            }
            EObject t = eObject;
            Method[] allMethods = c.getDeclaredMethods();
            Method toPNML = null;
            Method[] methodArray = allMethods;
            int n = allMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                String mname = m.getName();
                if (mname.equalsIgnoreCase(TO_PNML) && m.getGenericReturnType() == Void.TYPE) {
                    toPNML = m;
                    break;
                }
                ++n2;
            }
            if (toPNML != null) {
                FileOutputStream fos = new FileOutputStream(this.out);
                FileChannel fc = fos.getChannel();
                try {
                    try {
                        toPNML.invoke((Object)t, fc);
                        break block10;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new InvocationFailedException(e.getMessage(), e.getCause());
                    }
                }
                finally {
                    fc.close();
                    fos.close();
                }
            }
            throw new InvocationFailedException("Cannot locate toPNML(FileChannel fc) in the PNML object (passed as " + classname + ").");
        }
        this.log.trace(WRITING_TO_PNML_FILE_OK);
        this.log.trace(VALIDATION_AGAINST_GRAMMAR);
        this.rngGrammarValidation(schemafile, ValidationDriver.uriOrFileInputSource((String)this.out.getAbsolutePath()));
    }

    private static void writeToFileNIOWay(File file, String output) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        FileChannel fc = fos.getChannel();
        ByteBuffer bytebuf = ByteBuffer.allocateDirect(8192);
        List<byte[]> contents = PnmlExport.chopString(output, 4096);
        for (byte[] cont : contents) {
            bytebuf.put(cont);
            bytebuf.flip();
            fc.write(bytebuf);
            bytebuf.clear();
        }
        fc.close();
        fos.close();
    }

    private static List<byte[]> chopString(String src, int len) {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        int iterations = (int)Math.ceil((double)src.length() / (double)len);
        int i = 0;
        while (i < iterations) {
            res.add(src.substring(i * len, Math.min(src.length(), (i + 1) * len)).getBytes(Charset.forName(ISO_8859_1)));
            ++i;
        }
        return res;
    }

    public static List<byte[]> chopBytes(byte[] src, int len) {
        ArrayList<byte[]> res = new ArrayList<byte[]>();
        int iterations = (int)Math.ceil((double)src.length / (double)len);
        int k = 0;
        int i = 0;
        while (i < iterations) {
            byte[] element = new byte[Math.min(src.length, (i + 1) * len) - i * len];
            int j = i * len;
            while (j < Math.min(src.length, (i + 1) * len)) {
                element[k] = src[j];
                ++k;
                ++j;
            }
            res.add(element);
            k = 0;
            ++i;
        }
        return res;
    }
}

