/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.general;

import com.thaiopensource.validate.ValidationDriver;
import fr.lip6.move.pnml.framework.general.AbstractPnmlImportExport;
import fr.lip6.move.pnml.framework.general.ImportCustomPNMLFileType;
import fr.lip6.move.pnml.framework.general.OfficialPNMLFileType;
import fr.lip6.move.pnml.framework.general.PNMLFileType;
import fr.lip6.move.pnml.framework.hlapi.HLAPIClass;
import fr.lip6.move.pnml.framework.hlapi.HLAPIRootClass;
import fr.lip6.move.pnml.framework.utils.IdRefLinker;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.exception.AssociatedPluginNotFound;
import fr.lip6.move.pnml.framework.utils.exception.BadFileFormatException;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.OCLValidationFailed;
import fr.lip6.move.pnml.framework.utils.exception.OtherException;
import fr.lip6.move.pnml.framework.utils.exception.UnhandledNetType;
import fr.lip6.move.pnml.framework.utils.exception.ValidationFailedException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.xml.sax.InputSource;

public class PnmlImport
extends AbstractPnmlImportExport {
    private static final String DOT = ".";
    private boolean fallbackmode;

    public PnmlImport(String fileString) throws FileNotFoundException {
        super("import", fileString);
    }

    public PnmlImport() {
        super("import", null);
    }

    public final boolean setFallUse(boolean use) {
        boolean old = this.isFallUse();
        this.fallbackmode = use;
        return old;
    }

    public final boolean isFallUse() {
        return this.fallbackmode;
    }

    public final HLAPIClass importFile(String path, String forcedNameSpace) throws IOException, BadFileFormatException, UnhandledNetType, ValidationFailedException, InnerBuildException, OCLValidationFailed, OtherException, AssociatedPluginNotFound, InvalidIDException, VoidRepositoryException {
        HLAPIRootClass retour;
        String namespace;
        OMElement document = this.getDocument(path);
        String string = namespace = forcedNameSpace == null ? this.getDocumentType(document).getAttributeValue() : forcedNameSpace;
        if (forcedNameSpace != null) {
            this.disableGrammarValidation();
        }
        PNMLFileType pnmltype = null;
        if (this.newTypeFilePath != null) {
            pnmltype = new ImportCustomPNMLFileType(this.newTypeFilePath).getByNamespace(namespace);
        }
        if (pnmltype == null) {
            pnmltype = OfficialPNMLFileType.getByNamespace(namespace);
        }
        if (pnmltype == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("the net type " + namespace + " is unknown");
            }
            throw new UnhandledNetType("the net type " + namespace + " is unknown");
        }
        try {
            retour = this.doWork(pnmltype.getClassName(), document, ValidationDriver.uriOrFileInputSource((String)path), pnmltype.getRngUrl(), false);
        }
        catch (AssociatedPluginNotFound apnf) {
            if (this.fallbackmode && pnmltype.getFallBackClassName() != null) {
                this.log.warn("The plugin as not been found, trying fallback with " + pnmltype.getFallBackClassName());
                retour = this.doWork(pnmltype.getFallBackClassName(), document, null, null, true);
            }
            StringBuilder mess = new StringBuilder(apnf.getMessage());
            mess.append(" and fallback plugin can't be use (not set or fallback disabled)");
            throw new AssociatedPluginNotFound(mess.toString(), apnf);
        }
        return retour;
    }

    public final HLAPIClass importFile(String path) throws IOException, BadFileFormatException, UnhandledNetType, ValidationFailedException, InnerBuildException, OCLValidationFailed, OtherException, AssociatedPluginNotFound, InvalidIDException, VoidRepositoryException {
        return this.importFile(path, null);
    }

    private HLAPIRootClass doWork(String className, OMElement document, InputSource pnmldocStream, String schemafile, Boolean usingFallBack) throws ValidationFailedException, InnerBuildException, OCLValidationFailed, OtherException, AssociatedPluginNotFound, InvalidIDException, VoidRepositoryException {
        HLAPIRootClass newPetriNetDoc;
        try {
            Class<?> test = Class.forName(className);
            Constructor<?> construct = test.getConstructor(new Class[0]);
            newPetriNetDoc = (HLAPIRootClass)construct.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new AssociatedPluginNotFound("The plugin associated to this net type (" + className + ") can't be found", e);
        }
        catch (IllegalArgumentException e) {
            throw new OtherException(e);
        }
        catch (InstantiationException e) {
            throw new OtherException(e);
        }
        catch (IllegalAccessException e) {
            throw new OtherException(e);
        }
        catch (InvocationTargetException e) {
            throw new OtherException(e);
        }
        catch (SecurityException e) {
            throw new OtherException(e);
        }
        catch (NoSuchMethodException e) {
            throw new OtherException(e);
        }
        if (usingFallBack.booleanValue()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Using fallBack plugin, rng conformance not checked");
            }
        } else {
            this.rngGrammarValidation(schemafile, pnmldocStream);
        }
        Random r = new Random(new Date().getTime());
        String wksId = String.valueOf(newPetriNetDoc.getClass().getCanonicalName()) + DOT + r.nextLong();
        ModelRepository.getInstance().createDocumentWorkspace(wksId, newPetriNetDoc);
        IdRefLinker idr = new IdRefLinker();
        try {
            newPetriNetDoc.fromPNML(document, idr);
            document.close(false);
            idr.linkAll();
        }
        catch (InnerBuildException e) {
            this.log.error("An error occur in object internal building", (Throwable)e);
            throw new InnerBuildException("A problem occur during objects creation", e);
        }
        catch (VoidRepositoryException e) {
            this.log.error("An error occur in idref processing", (Throwable)e);
            throw new InnerBuildException("A problem occur during idref solving : " + e.getMessage(), e);
        }
        this.oclChecking(newPetriNetDoc);
        return newPetriNetDoc;
    }

    private OMElement getDocument(String path) throws FileNotFoundException, BadFileFormatException, OtherException {
        File imported = new File(path);
        if (!imported.isFile() || !imported.exists()) {
            throw new FileNotFoundException(String.valueOf(path) + " is not an existing file");
        }
        OMElement document = null;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));){
                OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((InputStream)in);
                document = builder.getDocumentElement();
                document.build();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new OtherException(e);
        }
        return document;
    }

    private OMAttribute getDocumentType(OMElement document) throws BadFileFormatException {
        if (!document.getLocalName().equals("pnml") || !document.getFirstElement().getLocalName().equals("net")) {
            this.log.error("this file is not a well formated PNML file, <pnml> or <net> are missing");
            throw new BadFileFormatException("this file is not a well formated PNML file");
        }
        OMAttribute doctype = document.getFirstElement().getAttribute(new QName("type"));
        if (doctype == null) {
            this.log.error("the type of this PNML file is not given");
            throw new BadFileFormatException("the type of this PNML file is not given");
        }
        return doctype;
    }
}

