/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.utils;

import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import fr.lip6.move.pnml.framework.utils.logging.LogMaster;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;

public class IdRefLinker {
    private final Map<Object, String[]> idRefElements;
    private final Logger log = LogMaster.getLogger("IdrefLinker");

    public IdRefLinker() {
        this.idRefElements = new HashMap<Object, String[]>();
    }

    public final void addIdRef(Object object, String[] ids) {
        this.idRefElements.put(object, ids);
    }

    public final void linkAll() throws VoidRepositoryException, InvalidIDException {
        this.log.debug(String.valueOf(this.idRefElements.keySet().size()));
        this.log.debug(ModelRepository.getInstance().getCurrentIdRepository().getAllId().toString());
        Iterator<Object> iterator = this.idRefElements.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object type = object = iterator.next();
            ArrayList<Object> lobj = new ArrayList<Object>();
            String[] idref = this.idRefElements.get(type);
            int i = 0;
            while (i < idref.length) {
                lobj.add(ModelRepository.getInstance().getCurrentIdRepository().getObject(idref[i]));
                ++i;
            }
            try {
                Method method = type.getClass().getMethod("idRefHang", lobj.getClass());
                method.invoke(type, lobj);
            }
            catch (NoSuchMethodException e) {
                this.log.error("no idRefHang on :" + type.getClass().toString(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                this.log.error("Error: ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.error("Error: ", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.log.error("Error: ", (Throwable)e);
            }
        }
    }

    public final void reset() {
        this.idRefElements.clear();
    }

    public final int idRefElementsSize() {
        return this.idRefElements.size();
    }
}

