/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.utils;

import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.OtherException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class IdRepository {
    private static final long LIMIT_LOOP = 1000000000L;
    private ConcurrentMap<String, Object> myHash = new ConcurrentHashMap<String, Object>();
    private static long prefixTentatives = 0L;

    public final void eraseIt() {
        this.myHash.clear();
    }

    public final synchronized String checkId(String myId, Object obj) throws InvalidIDException {
        String objName = obj.getClass().getCanonicalName();
        if (myId == null) {
            throw new InvalidIDException("The ID can't be null (" + objName + ")");
        }
        if ("".equals(myId)) {
            throw new InvalidIDException("The ID can't be void (" + objName + ")");
        }
        if (Character.isDigit(myId.charAt(0))) {
            throw new InvalidIDException("The ID can't begin with a digit (" + objName + ")");
        }
        if (this.myHash.containsKey(myId)) {
            throw new InvalidIDException("this id '" + myId + " (" + objName + ") already exists in the model : \"" + ModelRepository.getInstance().getCurrentDocWSId() + "\"");
        }
        this.myHash.put(myId, obj);
        return myId;
    }

    public final synchronized String generateFreeId(String prefix, Object obj) throws InvalidIDException {
        if (prefix == null) {
            throw new InvalidIDException("please give a prefix");
        }
        if ("".equals(prefix)) {
            throw new InvalidIDException("please give a prefix");
        }
        if (Character.isDigit(prefix.charAt(0))) {
            throw new InvalidIDException("the prefix can't begin with a digit");
        }
        return this.generateId(prefix, obj);
    }

    public final synchronized String generateFreeId(Object obj) throws InvalidIDException {
        String prefix = this.generatePrefix();
        return this.generateId(prefix, obj);
    }

    private final synchronized String generateId(String prefix, Object obj) throws InvalidIDException {
        Random generator = new Random(new Date().getTime());
        long rand = generator.nextLong();
        String myId = String.valueOf(prefix) + rand;
        int i = 0;
        while ((long)i < 1000000000L) {
            if (!this.myHash.containsKey(myId)) {
                this.myHash.put(myId, obj);
                break;
            }
            rand = Math.abs(generator.nextLong());
            myId = String.valueOf(prefix) + rand;
            if ((long)i == 1000000000L) {
                throw new InvalidIDException("can't give any free id");
            }
            ++i;
        }
        return myId;
    }

    public final synchronized String generatePrefix() {
        String prefix = Long.toHexString(Double.doubleToLongBits(Math.random()));
        String res = null;
        int i = 0;
        while (i < prefix.length()) {
            if (Character.isLetter(prefix.charAt(i))) break;
            ++i;
        }
        if (i < prefix.length()) {
            res = prefix.substring(i);
        } else {
            if (++prefixTentatives < 1000000000L) {
                res = this.generatePrefix();
            }
            prefixTentatives = 0L;
        }
        return res;
    }

    public final synchronized Object getObject(String theId) throws InvalidIDException {
        if (!this.myHash.containsKey(theId)) {
            throw new InvalidIDException("No object with id " + theId + " found");
        }
        return this.myHash.get(theId);
    }

    public final synchronized Object remove(String theId) throws InvalidIDException {
        if (!this.myHash.containsKey(theId)) {
            throw new InvalidIDException("the id " + theId + " doesn't exists");
        }
        return this.myHash.remove(theId);
    }

    public final synchronized String changeId(String oldId, String newId) throws InvalidIDException {
        if (this.myHash.containsKey(newId)) {
            throw new InvalidIDException("the new id " + newId + " already exists");
        }
        Object obj = this.remove(oldId);
        this.myHash.put(newId, obj);
        return newId;
    }

    public final synchronized String changeId(Object obj, String newId) throws OtherException, InvalidIDException {
        if (!this.myHash.containsValue(obj)) {
            throw new OtherException("Object " + obj + " not found");
        }
        String objid = null;
        for (String iterable : this.myHash.keySet()) {
            if (!this.myHash.get(iterable).equals(obj)) continue;
            objid = iterable;
            break;
        }
        return this.changeId(objid, newId);
    }

    public final Set<String> getAllId() {
        return this.myHash.keySet();
    }

    public final Map<String, Object> getMap() {
        return new ConcurrentHashMap<String, Object>(this.myHash);
    }

    public final synchronized Boolean isCompatible(IdRepository otherIdRep) {
        HashSet<String> compare = new HashSet<String>();
        compare.addAll(this.getAllId());
        compare.retainAll(otherIdRep.getAllId());
        return compare.isEmpty();
    }

    public final synchronized boolean fuseWith(IdRepository otherIdRep) {
        boolean retour = this.isCompatible(otherIdRep);
        if (retour) {
            this.myHash.putAll(otherIdRep.getMap());
        }
        return retour;
    }
}

