/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.utils;

import fr.lip6.move.pnml.framework.hlapi.HLAPIRootClass;
import fr.lip6.move.pnml.framework.utils.IdRepository;
import fr.lip6.move.pnml.framework.utils.ModelRepositoryUnit;
import fr.lip6.move.pnml.framework.utils.PrettyPrintData;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.ecore.EObject;

public final class ModelRepository {
    private static final String NO_MODEL_REPOSITORY_UNIT_ASSOCIATED_TO_CURRENT_WORKSPACE = "There is no model repository unit associated to the current workspace in the repository.";
    private static final String NO_REGISTERED_MODELS_IN_REPOSITORY = "There is no registered models in the repository";
    private static final String DOT = ".";
    private ConcurrentMap<String, ModelRepositoryUnit> documents = new ConcurrentHashMap<String, ModelRepositoryUnit>();
    private String currentDocWSId = null;
    private boolean isParallel = false;
    private boolean isPrettyPrint = true;

    private ModelRepository() {
    }

    public void setCurrentModel(String documentWSId) throws InvalidIDException {
        this.setCurrentDocWorkspace(documentWSId);
    }

    public void setCurrentDocWorkspace(String documentWSId) throws InvalidIDException {
        this.changeCurrentDocWorkspace(documentWSId);
    }

    public synchronized void changeCurrentDocWorkspace(String documentWSId) throws InvalidIDException {
        if (!this.documents.containsKey(documentWSId)) {
            throw new InvalidIDException("the Id " + documentWSId + " is not registered");
        }
        if (!this.isParallel) {
            this.currentDocWSId = documentWSId;
        }
    }

    public String getCurrentModelId() {
        return this.getCurrentDocWSId();
    }

    public String getCurrentDocWSId() {
        String res = this.currentDocWSId != null ? this.currentDocWSId : (this.documents.containsKey(String.valueOf(Thread.currentThread().getId())) ? String.valueOf(Thread.currentThread().getId()) : null);
        return res;
    }

    public static synchronized ModelRepository getInstance() {
        return ModelRepositoryHolder.instance;
    }

    public String createModelWorkspace(String modelId) throws InvalidIDException {
        return this.createDocumentWorkspace(modelId);
    }

    public synchronized String createDocumentWorkspace(String docWorkspaceId) throws InvalidIDException {
        if (this.documents.containsKey(docWorkspaceId)) {
            throw new InvalidIDException("the Id " + docWorkspaceId + " is already used");
        }
        IdRepository idrep = new IdRepository();
        ModelRepositoryUnit mep = new ModelRepositoryUnit(idrep, null);
        this.documents.put(docWorkspaceId, mep);
        this.changeCurrentDocWorkspace(docWorkspaceId);
        return docWorkspaceId;
    }

    public String createModelWorkspace(String modelId, HLAPIRootClass petriNetDoc) throws InvalidIDException {
        return this.createDocumentWorkspace(modelId, petriNetDoc);
    }

    public synchronized String createDocumentWorkspace(String docWorkspaceId, HLAPIRootClass petriNetDoc) throws InvalidIDException {
        if (this.documents.containsKey(docWorkspaceId)) {
            throw new InvalidIDException("the Id " + docWorkspaceId + " is already used");
        }
        IdRepository idrep = new IdRepository();
        ModelRepositoryUnit mep = new ModelRepositoryUnit(idrep, petriNetDoc);
        this.documents.put(docWorkspaceId, mep);
        this.changeCurrentDocWorkspace(docWorkspaceId);
        return docWorkspaceId;
    }

    public synchronized void createDocumentWorkspace(String docWorkspaceId, EObject petriNetDoc) throws InvalidIDException {
        if (this.documents.containsKey(docWorkspaceId)) {
            throw new InvalidIDException("the Id " + docWorkspaceId + " is already used.");
        }
        IdRepository idrep = new IdRepository();
        ModelRepositoryUnit mep = new ModelRepositoryUnit(petriNetDoc, idrep);
        this.documents.put(docWorkspaceId, mep);
        this.changeCurrentDocWorkspace(docWorkspaceId);
    }

    public int destroyCurrentModelWorkspace() throws VoidRepositoryException {
        return this.destroyCurrentWorkspace();
    }

    public synchronized int destroyCurrentWorkspace() throws VoidRepositoryException {
        if (this.documents == null || this.documents.isEmpty()) {
            throw new VoidRepositoryException("there is no registered models in the repository");
        }
        if (!this.isParallel) {
            if (this.currentDocWSId != null) {
                this.documents.remove(this.currentDocWSId);
            }
        } else {
            String toBeRemoved = String.valueOf(Thread.currentThread().getId());
            if (this.documents.containsKey(toBeRemoved)) {
                this.documents.remove(toBeRemoved);
            }
        }
        this.currentDocWSId = null;
        return this.documents.size();
    }

    public synchronized IdRepository getCurrentIdRepository() throws VoidRepositoryException {
        if (this.documents == null || this.documents.isEmpty()) {
            throw new VoidRepositoryException("there is no registered models in the repository");
        }
        IdRepository rep = null;
        if (!this.isParallel) {
            rep = ((ModelRepositoryUnit)this.documents.get(this.getCurrentDocWSId())).getIdrep();
        } else {
            String currentThreadWS = this.getCurrentDocWSId();
            if (currentThreadWS != null) {
                rep = ((ModelRepositoryUnit)this.documents.get(currentThreadWS)).getIdrep();
            }
        }
        return rep;
    }

    public synchronized HLAPIRootClass getCurrentHLAPIRootClass() throws VoidRepositoryException {
        if (this.documents == null || this.documents.isEmpty()) {
            throw new VoidRepositoryException("there is no registered models in the repository");
        }
        HLAPIRootClass hrc = null;
        if (!this.isParallel && this.currentDocWSId != null) {
            ModelRepositoryUnit mru = (ModelRepositoryUnit)this.documents.get(this.currentDocWSId);
            hrc = mru.getPetriNetDoc();
        }
        return hrc;
    }

    public synchronized EObject getCurrentEObjectRootClass() throws VoidRepositoryException {
        if (this.documents == null || this.documents.isEmpty()) {
            throw new VoidRepositoryException("there is no registered models in the repository");
        }
        EObject rc = null;
        if (!this.isParallel && this.currentDocWSId != null) {
            ModelRepositoryUnit mru = (ModelRepositoryUnit)this.documents.get(this.currentDocWSId);
            rc = mru.getPetriNetDocEObject();
        }
        return rc;
    }

    public synchronized void setCurrentHLAPIRootClass(HLAPIRootClass hrc) throws VoidRepositoryException {
        if (this.documents == null || this.documents.isEmpty()) {
            throw new VoidRepositoryException(NO_REGISTERED_MODELS_IN_REPOSITORY);
        }
        if (!this.isParallel) {
            String current = this.getCurrentDocWSId();
            if (current != null) {
                ModelRepositoryUnit mru = (ModelRepositoryUnit)this.documents.get(current);
                if (mru != null) {
                    mru.setPetriNetDoc(hrc);
                } else {
                    new VoidRepositoryException(NO_MODEL_REPOSITORY_UNIT_ASSOCIATED_TO_CURRENT_WORKSPACE);
                }
            } else {
                Random r = new Random(new Date().getTime());
                String wksId = String.valueOf(hrc.getClass().getCanonicalName()) + DOT + r.nextLong();
                try {
                    this.createDocumentWorkspace(wksId, hrc);
                }
                catch (InvalidIDException invalidIDException) {
                    wksId = String.valueOf(hrc.getClass().getCanonicalName()) + DOT + r.nextLong();
                    try {
                        this.createDocumentWorkspace(wksId, hrc);
                    }
                    catch (InvalidIDException e1) {
                        throw new VoidRepositoryException("Could not automatically create new workspace: " + e1.getMessage());
                    }
                }
            }
        }
    }

    public synchronized void setCurrentEObjectRootClass(EObject rc) throws VoidRepositoryException {
        if (this.documents == null || this.documents.isEmpty()) {
            throw new VoidRepositoryException(NO_REGISTERED_MODELS_IN_REPOSITORY);
        }
        if (!this.isParallel) {
            String current = this.getCurrentDocWSId();
            if (current != null) {
                ModelRepositoryUnit mru = (ModelRepositoryUnit)this.documents.get(current);
                if (mru != null) {
                    mru.setPetriNetDocEObject(rc);
                } else {
                    new VoidRepositoryException(NO_MODEL_REPOSITORY_UNIT_ASSOCIATED_TO_CURRENT_WORKSPACE);
                }
            } else {
                Random r = new Random(new Date().getTime());
                String wksId = String.valueOf(rc.getClass().getCanonicalName()) + DOT + r.nextLong();
                try {
                    this.createDocumentWorkspace(wksId, rc);
                }
                catch (InvalidIDException invalidIDException) {
                    wksId = String.valueOf(rc.getClass().getCanonicalName()) + DOT + r.nextLong();
                    try {
                        this.createDocumentWorkspace(wksId, rc);
                    }
                    catch (InvalidIDException e1) {
                        throw new VoidRepositoryException("Could not automatically create new workspace: " + e1.getMessage());
                    }
                }
            }
        }
    }

    public Set<String> getRegisteredModelsId() {
        return this.documents.keySet();
    }

    public synchronized void setPrettyPrintStatus(boolean status) {
        String current = this.getCurrentDocWSId();
        if (current != null && !this.isParallel) {
            ModelRepositoryUnit mru = (ModelRepositoryUnit)this.documents.get(current);
            if (mru != null) {
                mru.setPrettyPrint(status);
            } else {
                this.isPrettyPrint = status;
            }
        } else if (this.isParallel) {
            for (Map.Entry ent : this.documents.entrySet()) {
                ModelRepositoryUnit mru = (ModelRepositoryUnit)ent.getValue();
                if (mru == null) continue;
                mru.setPrettyPrint(status);
            }
        } else {
            this.isPrettyPrint = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrettyPrintActive() {
        boolean result = this.isPrettyPrint;
        String current = this.getCurrentDocWSId();
        if (this.currentDocWSId != null && !this.isParallel) {
            String string = this.currentDocWSId;
            synchronized (string) {
                ModelRepositoryUnit mru = (ModelRepositoryUnit)this.documents.get(current);
                if (mru != null) {
                    result = mru.isPrettyPrint();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrettyPrintData getPrettyPrintData() {
        PrettyPrintData ppd = null;
        if (this.currentDocWSId != null) {
            String string = this.currentDocWSId;
            synchronized (string) {
                ppd = ((ModelRepositoryUnit)this.documents.get(this.currentDocWSId)).getPrettyPrinter();
            }
        } else {
            ppd = new PrettyPrintData();
        }
        return ppd;
    }

    public synchronized void setParallelWorkspaces(boolean mode) {
        this.isParallel = mode;
        if (this.isParallel) {
            this.currentDocWSId = null;
        }
    }

    public boolean areWorkspacesParallel() {
        return this.isParallel;
    }

    public int size() {
        return this.documents.size();
    }

    public synchronized void reset() {
        this.documents.clear();
        this.currentDocWSId = null;
        this.isParallel = false;
        this.isPrettyPrint = true;
    }

    /* synthetic */ ModelRepository(ModelRepository modelRepository) {
        this();
    }

    private static final class ModelRepositoryHolder {
        private static final ModelRepository instance = new ModelRepository(null);

        private ModelRepositoryHolder() {
        }
    }
}

