/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.utils;

import fr.lip6.move.pnml.framework.general.PNType;
import fr.lip6.move.pnml.framework.general.PnmlExport;
import fr.lip6.move.pnml.framework.general.PnmlImport;
import fr.lip6.move.pnml.framework.hlapi.HLAPIRootClass;
import fr.lip6.move.pnml.framework.utils.ModelRepository;
import fr.lip6.move.pnml.framework.utils.exception.AssociatedPluginNotFound;
import fr.lip6.move.pnml.framework.utils.exception.BadFileFormatException;
import fr.lip6.move.pnml.framework.utils.exception.ImportException;
import fr.lip6.move.pnml.framework.utils.exception.InnerBuildException;
import fr.lip6.move.pnml.framework.utils.exception.InternalException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidFileException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidFileTypeException;
import fr.lip6.move.pnml.framework.utils.exception.InvalidIDException;
import fr.lip6.move.pnml.framework.utils.exception.InvocationFailedException;
import fr.lip6.move.pnml.framework.utils.exception.OCLValidationFailed;
import fr.lip6.move.pnml.framework.utils.exception.OtherException;
import fr.lip6.move.pnml.framework.utils.exception.UnhandledNetType;
import fr.lip6.move.pnml.framework.utils.exception.ValidationFailedException;
import fr.lip6.move.pnml.framework.utils.exception.VoidRepositoryException;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import javax.activation.MimetypesFileTypeMap;
import org.eclipse.emf.ecore.EObject;

public final class PNMLUtils {
    private static final String TEXT_XML_PNML = "text/xml xml pnml XML PNML";
    private static final String PTHLPNG_PETRINETDOC_HLAPI = "fr.lip6.move.pnml.pthlpng.hlcorestructure.hlapi.PetriNetDocHLAPI";
    private static final String HLPN_PETRINETDOC_HLAPI = "fr.lip6.move.pnml.hlpn.hlcorestructure.hlapi.PetriNetDocHLAPI";
    private static final String SYMMETRICNET_PETRINETDOC_HLAPI = "fr.lip6.move.pnml.symmetricnet.hlcorestructure.hlapi.PetriNetDocHLAPI";
    private static final String PTNET_PETRINETDOC_HLAPI = "fr.lip6.move.pnml.ptnet.hlapi.PetriNetDocHLAPI";
    private static final String PNMLCOREMODEL_PETRINETDOC_HLAPI = "fr.lip6.move.pnml.pnmlcoremodel.hlapi.PetriNetDocHLAPI";
    private static final String DOT = ".";

    private PNMLUtils() {
    }

    public static final HLAPIRootClass importPnmlDocument(File file, boolean fallback) throws ImportException, InvalidIDException {
        try {
            PnmlImport pim = new PnmlImport();
            pim.setFallUse(fallback);
            HLAPIRootClass imported = (HLAPIRootClass)pim.importFile(file.getCanonicalPath());
            return imported;
        }
        catch (IOException ioe) {
            throw new InvalidIDException(ioe.getMessage(), ioe.getCause());
        }
        catch (BadFileFormatException bffe) {
            throw new InvalidIDException(bffe.getMessage(), bffe.getCause());
        }
        catch (UnhandledNetType unte) {
            throw new ImportException(unte.getMessage(), unte.getCause());
        }
        catch (ValidationFailedException vfe) {
            throw new ImportException(vfe.getMessage(), vfe.getCause());
        }
        catch (InnerBuildException ibe) {
            throw new ImportException(ibe.getMessage(), ibe.getCause());
        }
        catch (OCLValidationFailed oclve) {
            throw new ImportException(oclve.getMessage(), oclve.getCause());
        }
        catch (OtherException oe) {
            throw new ImportException(oe.getMessage(), oe.getCause());
        }
        catch (AssociatedPluginNotFound apnfe) {
            throw new ImportException(apnfe.getMessage(), apnfe.getCause());
        }
        catch (InvalidIDException iie) {
            throw new ImportException(iie.getMessage(), iie.getCause());
        }
        catch (VoidRepositoryException vre) {
            throw new ImportException(vre.getMessage(), vre.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ImportException(e.getMessage(), e.getCause());
        }
    }

    public static final PNType determinePNType(HLAPIRootClass imported) {
        PNType myPnType = PNMLCOREMODEL_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName()) ? PNType.COREMODEL : (PTNET_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName()) ? PNType.PTNET : (SYMMETRICNET_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName()) ? PNType.SYMNET : (HLPN_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName()) ? PNType.HLPN : (PTHLPNG_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName()) ? PNType.PTHLPN : null))));
        return myPnType;
    }

    public static final boolean isCoreModelDocument(HLAPIRootClass imported) {
        return PNMLCOREMODEL_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName());
    }

    public static final boolean isPTNetDocument(HLAPIRootClass imported) {
        return PTNET_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName());
    }

    public static final boolean isPTHLPNDocument(HLAPIRootClass imported) {
        return PTHLPNG_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName());
    }

    public static final boolean isHLPNDocument(HLAPIRootClass imported) {
        return HLPN_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName());
    }

    public static final boolean isSymNetDocument(HLAPIRootClass imported) {
        return SYMMETRICNET_PETRINETDOC_HLAPI.equalsIgnoreCase(imported.getClass().getCanonicalName());
    }

    public static final String exportPetriNetDocToPNML(HLAPIRootClass object, String filepath) throws UnhandledNetType, OCLValidationFailed, IOException, ValidationFailedException, BadFileFormatException, OtherException, InvalidIDException {
        ModelRepository mr = ModelRepository.getInstance();
        Random r = new Random(new Date().getTime());
        String wksId = String.valueOf(object.getClass().getCanonicalName()) + DOT + r.nextLong();
        mr.createDocumentWorkspace(wksId, object);
        mr.setPrettyPrintStatus(true);
        PnmlExport pex = new PnmlExport();
        pex.exportObject(object, filepath);
        pex = null;
        return wksId;
    }

    public static final String exportPetriNetDocToPNML(EObject object, String filepath) throws UnhandledNetType, OCLValidationFailed, IOException, ValidationFailedException, BadFileFormatException, OtherException, InvalidIDException, InvocationFailedException {
        ModelRepository mr = ModelRepository.getInstance();
        Random r = new Random(new Date().getTime());
        String wksId = String.valueOf(object.getClass().getCanonicalName()) + DOT + r.nextLong();
        mr.createDocumentWorkspace(wksId, object);
        mr.setPrettyPrintStatus(true);
        PnmlExport pex = new PnmlExport();
        pex.exportObject(object, filepath);
        pex = null;
        return wksId;
    }

    public static final String createDocumentWorkspace(String workspaceId) throws InvalidIDException {
        return ModelRepository.getInstance().createDocumentWorkspace(workspaceId);
    }

    public static final String createDocumentWorkspace(String workspaceId, HLAPIRootClass petriNetDoc) throws InvalidIDException {
        return ModelRepository.getInstance().createDocumentWorkspace(workspaceId, petriNetDoc);
    }

    public static final void createDocumentWorkspace(String workspaceId, EObject petriNetDoc) throws InvalidIDException {
        ModelRepository.getInstance().createDocumentWorkspace(workspaceId, petriNetDoc);
    }

    public static final void checkIsPnmlFile(File pFile) throws InvalidFileTypeException, InvalidFileException, InternalException {
        try {
            if (!pFile.exists()) {
                String message = "File " + pFile.getName() + " does not exist.";
                throw new InternalException(message, new Throwable(message));
            }
            if (!pFile.isFile()) {
                String message = String.valueOf(pFile.getName()) + " is not a regular file.";
                throw new InvalidFileException(message, new Throwable(message));
            }
            if (!pFile.canRead()) {
                String message = "Cannot read file " + pFile.getName();
                throw new InternalException(message, new Throwable(message));
            }
            MimetypesFileTypeMap ftm = new MimetypesFileTypeMap();
            ftm.addMimeTypes(TEXT_XML_PNML);
            String contentType = ftm.getContentType(pFile);
            if (!contentType.contains("text/xml")) {
                String message = String.valueOf(pFile.getName()) + " is not an XML file: " + contentType;
                throw new InvalidFileTypeException(message, new Throwable(message));
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            throw new InternalException("Null pointer exception", new Throwable("Something went wrong. Please, re-submit."));
        }
        catch (SecurityException se) {
            throw new InternalException(se.getMessage(), new Throwable("Access right problem while accessing the file system. Please, re-submit."));
        }
    }
}

