/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.utils.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogMaster {
    private static String logger = "org.apache.commons.logging.impl.SimpleLog";
    private static String level = "info";
    private static LogMaster instance;

    static {
        System.setProperty("org.apache.commons.logging.Log", logger);
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", level);
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "false");
        System.setProperty("org.apache.commons.logging.simplelog.showlogname", "true");
        System.setProperty("org.apache.commons.logging.simplelog.showShortLogname", "true");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.apache.commons.logging.simplelog.dateTimeFormat", "yyyy/MM/dd HH:mm:ss");
    }

    private LogMaster() {
    }

    public static String setLevel(String myLevel) {
        String old = level;
        level = myLevel;
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", level);
        instance = null;
        return old;
    }

    public static String setlogger(String mylogger) {
        String old = logger;
        logger = mylogger;
        instance = null;
        return old;
    }

    public static synchronized Log giveLogger(String name) {
        if (instance == null) {
            instance = new LogMaster();
        }
        return LogFactory.getFactory().getInstance(name);
    }

    public static synchronized Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }
}

