/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.pnml.framework.utils.validation;

import com.thaiopensource.validate.ValidationDriver;
import fr.lip6.move.pnml.framework.utils.exception.ValidationProcessException;
import fr.lip6.move.pnml.framework.utils.logging.LogMaster;
import java.io.IOException;
import org.slf4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PnmlRngValidation {
    private final Logger log = LogMaster.getLogger("PNML validation");

    public final boolean validatePnmlDoc(String schemafile, String pnmldoc) throws ValidationProcessException {
        InputSource pnmldocStream = null;
        pnmldocStream = ValidationDriver.fileInputSource((String)pnmldoc);
        return this.validatePnmlDoc(schemafile, pnmldocStream);
    }

    public final boolean validatePnmlDoc(String schemafile, InputSource pnmldocStream) throws ValidationProcessException {
        boolean loadedShema;
        boolean isValid = false;
        ValidationDriver valdrive = new ValidationDriver();
        InputSource schematIs = null;
        schematIs = ValidationDriver.uriOrFileInputSource((String)schemafile);
        try {
            loadedShema = valdrive.loadSchema(schematIs);
        }
        catch (SAXException e1) {
            this.log.error("The rng grammar file is not valid : " + e1.getLocalizedMessage());
            throw new ValidationProcessException(e1);
        }
        catch (IOException e1) {
            this.log.error("The rng grammar file can't be accessed : " + e1.getLocalizedMessage());
            throw new ValidationProcessException(e1);
        }
        try {
            isValid = valdrive.validate(pnmldocStream);
        }
        catch (SAXException e) {
            this.log.error("The file to validate is not valid :" + e.getLocalizedMessage());
        }
        catch (IOException e) {
            this.log.error("The file to validate cannot be correctly loaded :" + e.getLocalizedMessage());
        }
        return isValid && loadedShema;
    }
}

