/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.bintable;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import nom.tam.fits.FitsException;
import nom.tam.image.compression.bintable.BinaryTableTile;
import nom.tam.image.compression.bintable.BinaryTableTileDescription;
import nom.tam.image.compression.hdu.CompressedTableData;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.ByteBufferOutputStream;
import nom.tam.util.ColumnTable;
import nom.tam.util.SafeClose;

public class BinaryTableTileCompressor
extends BinaryTableTile {
    private static final int FACTOR_15 = 15;
    private static final int FACTOR_10 = 10;
    private static final int FACTOR_11 = 11;
    private static final int MINIMUM_EXTRA_SPACE = 1024;
    private final CompressedTableData binData;

    public BinaryTableTileCompressor(CompressedTableData binData, ColumnTable<?> columnTable, BinaryTableTileDescription description) {
        super(columnTable, description);
        this.binData = binData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.getUncompressedSizeInBytes()]);
        BufferedDataOutputStream os = new BufferedDataOutputStream(new ByteBufferOutputStream(buffer));
        try {
            this.data.write(os, this.rowStart, this.rowEnd, this.column);
        }
        catch (IOException e) {
            throw new IllegalStateException("could not write compressed data", e);
        }
        finally {
            SafeClose.close(os);
        }
        buffer.rewind();
        int spaceForCompression = this.getUncompressedSizeInBytes();
        spaceForCompression = Math.max(spaceForCompression * 11 / 10, spaceForCompression + 1024);
        ByteBuffer compressedBuffer = ByteBuffer.wrap(new byte[spaceForCompression]);
        if (!this.getCompressorControl().compress((Buffer)this.type.asTypedBuffer(buffer), compressedBuffer, null)) {
            spaceForCompression = spaceForCompression * 15 / 10;
            compressedBuffer = ByteBuffer.wrap(new byte[spaceForCompression]);
            if (!this.getCompressorControl().compress((Buffer)this.type.asTypedBuffer(buffer), compressedBuffer, null)) {
                throw new IllegalStateException("could not compress the tile with the requested algorithem!");
            }
        }
        byte[] compressedBytes = new byte[compressedBuffer.position()];
        compressedBuffer.rewind();
        compressedBuffer.get(compressedBytes);
        try {
            CompressedTableData compressedTableData = this.binData;
            synchronized (compressedTableData) {
                this.binData.setElement(this.getTileIndex() - 1, this.column, compressedBytes);
            }
        }
        catch (FitsException e) {
            throw new IllegalStateException("could not include compressed data into the table", e);
        }
    }
}

