/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.BufferDecoder;
import nom.tam.util.BufferEncoder;
import nom.tam.util.BufferPointer;
import nom.tam.util.RandomAccess;

public class BufferedFile
implements ArrayDataOutput,
RandomAccess {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final Logger LOG = Logger.getLogger(BufferedFile.class.getName());
    private final BufferPointer bufferPointer = new BufferPointer();
    private final BufferDecoder dataDecoder = new BufferDecoder(this.bufferPointer){

        @Override
        protected void checkBuffer(int needBytes) throws IOException {
            BufferedFile.this.checkBuffer(needBytes);
        }

        @Override
        protected int eofCheck(EOFException e, int start, int index, int length) throws EOFException {
            if (start == index) {
                throw e;
            }
            return (index - start) * length;
        }
    };
    private final BufferEncoder dataEncoder = new BufferEncoder(this.bufferPointer){

        @Override
        protected void needBuffer(int needBytes) throws IOException {
            BufferedFile.this.needBuffer(needBytes);
        }

        @Override
        protected void write(byte[] buf, int offset, int length) throws IOException {
            BufferedFile.this.write(buf, offset, length);
        }
    };
    private final RandomAccessFile randomAccessFile;
    private long fileOffset;
    private boolean doingInput;
    private int bufferMarker;

    public BufferedFile(File file) throws IOException {
        this(file, "r", 32768);
    }

    public BufferedFile(File file, String mode) throws IOException {
        this(file, mode, 32768);
    }

    public BufferedFile(File file, String mode, int bufferSize) throws IOException {
        this.randomAccessFile = new RandomAccessFile(file, mode);
        this.bufferPointer.init(bufferSize);
        this.fileOffset = 0L;
    }

    public BufferedFile(String filename) throws IOException {
        this(filename, "r", 32768);
    }

    public BufferedFile(String filename, String mode) throws IOException {
        this(filename, mode, 32768);
    }

    public BufferedFile(String filename, String mode, int bufferSize) throws IOException {
        this(new File(filename), mode, bufferSize);
    }

    private void checkBuffer(int needBytes) throws IOException {
        if (!this.doingInput && this.bufferPointer.bufferOffset > 0) {
            this.flush();
        }
        this.doingInput = true;
        if (this.bufferPointer.bufferOffset + needBytes < this.bufferPointer.bufferLength) {
            return;
        }
        int len = this.bufferPointer.bufferLength - this.bufferPointer.bufferOffset;
        this.fileOffset += (long)this.bufferPointer.bufferOffset;
        if (len > 0) {
            System.arraycopy(this.bufferPointer.buffer, this.bufferPointer.bufferOffset, this.bufferPointer.buffer, 0, len);
        }
        needBytes -= len;
        this.bufferPointer.bufferLength = len;
        this.bufferPointer.bufferOffset = 0;
        while (needBytes > 0) {
            len = this.randomAccessFile.read(this.bufferPointer.buffer, this.bufferPointer.bufferLength, this.bufferPointer.buffer.length - this.bufferPointer.bufferLength);
            if (len < 0) {
                throw new EOFException();
            }
            needBytes -= len;
            this.bufferPointer.bufferLength += len;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.randomAccessFile.close();
    }

    protected void finalize() {
        try {
            if (this.getFD().valid()) {
                this.flush();
                this.close();
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "could not finalize buffered file", e);
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.doingInput && this.bufferPointer.bufferOffset > 0) {
            this.randomAccessFile.write(this.bufferPointer.buffer, 0, this.bufferPointer.bufferOffset);
            this.fileOffset += (long)this.bufferPointer.bufferOffset;
            this.bufferPointer.invalidate();
        }
    }

    public FileChannel getChannel() {
        return this.randomAccessFile.getChannel();
    }

    public FileDescriptor getFD() throws IOException {
        return this.randomAccessFile.getFD();
    }

    @Override
    public long getFilePointer() {
        return this.fileOffset + (long)this.bufferPointer.bufferOffset;
    }

    public long length() throws IOException {
        this.flush();
        return this.randomAccessFile.length();
    }

    @Override
    public void mark(int readlimit) throws IOException {
        this.bufferMarker = this.bufferPointer.bufferOffset;
        if (this.bufferMarker + readlimit > this.bufferPointer.bufferLength) {
            try {
                this.checkBuffer(readlimit);
            }
            catch (EOFException e) {
                LOG.log(Level.FINE, "mark over file limit, so read as far as possible.", e);
            }
            this.bufferMarker = this.bufferPointer.bufferOffset;
        }
    }

    private void needBuffer(int need) throws IOException {
        if (this.doingInput) {
            this.fileOffset += (long)this.bufferPointer.bufferOffset;
            this.randomAccessFile.seek(this.fileOffset);
            this.doingInput = false;
            this.bufferPointer.invalidate();
        }
        if (this.bufferPointer.bufferOffset + need >= this.bufferPointer.buffer.length) {
            this.randomAccessFile.write(this.bufferPointer.buffer, 0, this.bufferPointer.bufferOffset);
            this.fileOffset += (long)this.bufferPointer.bufferOffset;
            this.bufferPointer.bufferOffset = 0;
        }
    }

    public int read() throws IOException {
        this.checkBuffer(1);
        return this.bufferPointer.buffer[this.bufferPointer.bufferOffset++];
    }

    @Override
    public int read(boolean[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(boolean[] b, int start, int length) throws IOException {
        return this.dataDecoder.read(b, start, length);
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        return this.dataDecoder.read(buf, offset, len);
    }

    @Override
    public int read(char[] c) throws IOException {
        return this.read(c, 0, c.length);
    }

    @Override
    public int read(char[] c, int start, int length) throws IOException {
        return this.dataDecoder.read(c, start, length);
    }

    @Override
    public int read(double[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    @Override
    public int read(double[] d, int start, int length) throws IOException {
        return this.dataDecoder.read(d, start, length);
    }

    @Override
    public int read(float[] f) throws IOException {
        return this.read(f, 0, f.length);
    }

    @Override
    public int read(float[] f, int start, int length) throws IOException {
        return this.dataDecoder.read(f, start, length);
    }

    @Override
    public int read(int[] i) throws IOException {
        return this.read(i, 0, i.length);
    }

    @Override
    public int read(int[] i, int start, int length) throws IOException {
        return this.dataDecoder.read(i, start, length);
    }

    @Override
    public int read(long[] l) throws IOException {
        return this.read(l, 0, l.length);
    }

    @Override
    public int read(long[] l, int start, int length) throws IOException {
        return this.dataDecoder.read(l, start, length);
    }

    @Override
    public int read(short[] s) throws IOException {
        return this.read(s, 0, s.length);
    }

    @Override
    public int read(short[] s, int start, int length) throws IOException {
        return this.dataDecoder.read(s, start, length);
    }

    @Override
    @Deprecated
    public int readArray(Object o) throws IOException {
        return (int)this.readLArray(o);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.dataDecoder.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.checkBuffer(1);
        return this.bufferPointer.buffer[this.bufferPointer.bufferOffset++];
    }

    @Override
    public char readChar() throws IOException {
        return this.dataDecoder.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.dataDecoder.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.dataDecoder.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.dataDecoder.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataDecoder.readFully(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.dataDecoder.readInt();
    }

    @Override
    public long readLArray(Object o) throws IOException {
        return this.dataDecoder.readLArray(o);
    }

    @Override
    public String readLine() throws IOException {
        this.checkBuffer(-1);
        this.randomAccessFile.seek(this.fileOffset + (long)this.bufferPointer.bufferOffset);
        String line = this.randomAccessFile.readLine();
        this.fileOffset = this.randomAccessFile.getFilePointer();
        this.bufferPointer.invalidate();
        return line;
    }

    @Override
    public long readLong() throws IOException {
        return this.dataDecoder.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.dataDecoder.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkBuffer(1);
        return this.bufferPointer.buffer[this.bufferPointer.bufferOffset++] & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        this.checkBuffer(-1);
        this.randomAccessFile.seek(this.fileOffset + (long)this.bufferPointer.bufferOffset);
        String utf = this.randomAccessFile.readUTF();
        this.fileOffset = this.randomAccessFile.getFilePointer();
        this.bufferPointer.invalidate();
        return utf;
    }

    @Override
    public void reset() throws IOException {
        this.bufferPointer.bufferOffset = this.bufferMarker;
    }

    @Override
    public void seek(long offsetFromStart) throws IOException {
        if (!this.doingInput) {
            this.flush();
        }
        if (this.fileOffset <= offsetFromStart && offsetFromStart < this.fileOffset + (long)this.bufferPointer.bufferLength) {
            this.bufferPointer.bufferOffset = (int)(offsetFromStart - this.fileOffset);
        } else {
            if (offsetFromStart < 0L) {
                offsetFromStart = 0L;
            }
            this.fileOffset = offsetFromStart;
            this.randomAccessFile.seek(this.fileOffset);
            this.bufferPointer.invalidate();
        }
    }

    public void setLength(long newLength) throws IOException {
        this.flush();
        this.randomAccessFile.setLength(newLength);
        if (newLength < this.fileOffset) {
            this.fileOffset = newLength;
        }
    }

    @Override
    public long skip(long offset) throws IOException {
        if (offset > 0L && this.fileOffset + (long)this.bufferPointer.bufferOffset + offset > this.randomAccessFile.length()) {
            offset = this.randomAccessFile.length() - this.fileOffset - (long)this.bufferPointer.bufferOffset;
            this.seek(this.randomAccessFile.length());
        } else if (this.fileOffset + (long)this.bufferPointer.bufferOffset + offset < 0L) {
            offset = -(this.fileOffset + (long)this.bufferPointer.bufferOffset);
            this.seek(0L);
        } else {
            this.seek(this.fileOffset + (long)this.bufferPointer.bufferOffset + offset);
        }
        return offset;
    }

    @Override
    public void skipAllBytes(int toSkip) throws IOException {
        this.skipAllBytes((long)toSkip);
    }

    @Override
    public void skipAllBytes(long toSkip) throws IOException {
        if (this.skip(toSkip) < toSkip) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.skipAllBytes(n);
        return n;
    }

    @Override
    public void write(boolean[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(boolean[] b, int start, int length) throws IOException {
        this.dataEncoder.write(b, start, length);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        if (length < this.bufferPointer.buffer.length) {
            this.needBuffer(length);
            System.arraycopy(buf, offset, this.bufferPointer.buffer, this.bufferPointer.bufferOffset, length);
            this.bufferPointer.bufferOffset += length;
        } else {
            this.flush();
            this.randomAccessFile.write(buf, offset, length);
            this.fileOffset += (long)length;
            this.doingInput = false;
            this.bufferPointer.invalidate();
        }
    }

    @Override
    public void write(char[] c) throws IOException {
        this.write(c, 0, c.length);
    }

    @Override
    public void write(char[] c, int start, int length) throws IOException {
        this.dataEncoder.write(c, start, length);
    }

    @Override
    public void write(double[] d) throws IOException {
        this.write(d, 0, d.length);
    }

    @Override
    public void write(double[] d, int start, int length) throws IOException {
        this.dataEncoder.write(d, start, length);
    }

    @Override
    public void write(float[] f) throws IOException {
        this.write(f, 0, f.length);
    }

    @Override
    public void write(float[] f, int start, int length) throws IOException {
        this.dataEncoder.write(f, start, length);
    }

    @Override
    public void write(int buf) throws IOException {
        this.dataEncoder.writeByte(buf);
    }

    @Override
    public void write(int[] i) throws IOException {
        this.write(i, 0, i.length);
    }

    @Override
    public void write(int[] i, int start, int length) throws IOException {
        this.dataEncoder.write(i, start, length);
    }

    @Override
    public void write(long[] l) throws IOException {
        this.write(l, 0, l.length);
    }

    @Override
    public void write(long[] l, int start, int length) throws IOException {
        this.dataEncoder.write(l, start, length);
    }

    @Override
    public void write(short[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    @Override
    public void write(short[] s, int start, int length) throws IOException {
        this.dataEncoder.write(s, start, length);
    }

    @Override
    public void write(String[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    @Override
    public void write(String[] s, int start, int length) throws IOException {
        this.dataEncoder.write(s, start, length);
    }

    @Override
    public void writeArray(Object o) throws IOException {
        this.dataEncoder.writeArray(o);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.dataEncoder.writeBoolean(b);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.dataEncoder.writeByte(b);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(AsciiFuncs.getBytes(s), 0, s.length());
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.dataEncoder.writeChar(c);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.dataEncoder.writeChars(s);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.dataEncoder.writeDouble(d);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.dataEncoder.writeFloat(f);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.dataEncoder.writeInt(i);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.dataEncoder.writeLong(l);
    }

    @Override
    public void writeShort(int s) throws IOException {
        this.dataEncoder.writeShort(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.flush();
        this.randomAccessFile.writeUTF(s);
        this.fileOffset = this.randomAccessFile.getFilePointer();
    }
}

