/*
 * Decompiled with CFR 0.152.
 */
package Jama.examples;

import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;

public class MagicSquareExample {
    public static String fixedWidthDoubletoString(double d, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(n2);
        ((NumberFormat)decimalFormat).setMinimumFractionDigits(n2);
        ((NumberFormat)decimalFormat).setGroupingUsed(false);
        String string = decimalFormat.format(d);
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    public static String fixedWidthIntegertoString(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    public static Matrix magic(int n) {
        double[][] dArray = new double[n][n];
        if (n % 2 == 1) {
            int n2 = (n + 1) / 2;
            int n3 = n + 1;
            int n4 = 0;
            while (n4 < n) {
                int n5 = 0;
                while (n5 < n) {
                    dArray[n5][n4] = n * ((n5 + n4 + n2) % n) + (n5 + 2 * n4 + n3) % n + 1;
                    ++n5;
                }
                ++n4;
            }
        } else if (n % 4 == 0) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = 0;
                while (n7 < n) {
                    dArray[n7][n6] = (n7 + 1) / 2 % 2 == (n6 + 1) / 2 % 2 ? (double)(n * n - n * n7 - n6) : (double)(n * n7 + n6 + 1);
                    ++n7;
                }
                ++n6;
            }
        } else {
            double d;
            int n8;
            int n9 = n / 2;
            int n10 = (n - 2) / 4;
            Matrix matrix = MagicSquareExample.magic(n9);
            int n11 = 0;
            while (n11 < n9) {
                n8 = 0;
                while (n8 < n9) {
                    dArray[n8][n11] = d = matrix.get(n8, n11);
                    dArray[n8][n11 + n9] = d + (double)(2 * n9 * n9);
                    dArray[n8 + n9][n11] = d + (double)(3 * n9 * n9);
                    dArray[n8 + n9][n11 + n9] = d + (double)(n9 * n9);
                    ++n8;
                }
                ++n11;
            }
            n8 = 0;
            while (n8 < n9) {
                int n12 = 0;
                while (n12 < n10) {
                    double d2 = dArray[n8][n12];
                    dArray[n8][n12] = dArray[n8 + n9][n12];
                    dArray[n8 + n9][n12] = d2;
                    ++n12;
                }
                int n13 = n - n10 + 1;
                while (n13 < n) {
                    double d3 = dArray[n8][n13];
                    dArray[n8][n13] = dArray[n8 + n9][n13];
                    dArray[n8 + n9][n13] = d3;
                    ++n13;
                }
                ++n8;
            }
            d = dArray[n10][0];
            dArray[n10][0] = dArray[n10 + n9][0];
            dArray[n10 + n9][0] = d;
            d = dArray[n10][n10];
            dArray[n10][n10] = dArray[n10 + n9][n10];
            dArray[n10 + n9][n10] = d;
        }
        return new Matrix(dArray);
    }

    public static void main(String[] stringArray) {
        Cloneable cloneable;
        MagicSquareExample.print("\n    Test of Matrix Class, using magic squares.\n");
        MagicSquareExample.print("    See MagicSquareExample.main() for an explanation.\n");
        MagicSquareExample.print("\n      n     trace       max_eig   rank        cond      lu_res      qr_res\n\n");
        Date date = new Date();
        double d = Math.pow(2.0, -52.0);
        int n = 3;
        while (n <= 32) {
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(n, 7));
            cloneable = MagicSquareExample.magic(n);
            int n2 = (int)((Matrix)cloneable).trace();
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(n2, 10));
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(((Matrix)cloneable).plus(((Matrix)cloneable).transpose()).times(0.5));
            double[] dArray = eigenvalueDecomposition.getRealEigenvalues();
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(dArray[n - 1], 14, 3));
            int n3 = ((Matrix)cloneable).rank();
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(n3, 7));
            double d2 = ((Matrix)cloneable).cond();
            MagicSquareExample.print(d2 < 1.0 / d ? MagicSquareExample.fixedWidthDoubletoString(d2, 12, 3) : "         Inf");
            LUDecomposition lUDecomposition = new LUDecomposition((Matrix)cloneable);
            Matrix matrix = lUDecomposition.getL();
            Matrix matrix2 = lUDecomposition.getU();
            int[] nArray = lUDecomposition.getPivot();
            Matrix matrix3 = matrix.times(matrix2).minus(((Matrix)cloneable).getMatrix(nArray, 0, n - 1));
            double d3 = matrix3.norm1() / ((double)n * d);
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(d3, 12, 3));
            QRDecomposition qRDecomposition = new QRDecomposition((Matrix)cloneable);
            Matrix matrix4 = qRDecomposition.getQ();
            matrix3 = qRDecomposition.getR();
            matrix3 = matrix4.times(matrix3).minus((Matrix)cloneable);
            d3 = matrix3.norm1() / ((double)n * d);
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(d3, 12, 3));
            MagicSquareExample.print("\n");
            ++n;
        }
        cloneable = new Date();
        double d4 = (double)(((Date)cloneable).getTime() - date.getTime()) / 1000.0;
        MagicSquareExample.print("\nElapsed Time = " + MagicSquareExample.fixedWidthDoubletoString(d4, 12, 3) + " seconds\n");
        MagicSquareExample.print("Adios\n");
    }

    private static void print(String string) {
        System.out.print(string);
    }
}

