/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.converters.ErrorWriter;
import cucumber.deps.com.thoughtworks.xstream.io.AbstractReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ListOfComplexTypeReader
extends AbstractReader {
    private final Class itemType;
    private final List<String> attributeNames;
    private final Iterator<List<String>> itemIterator;
    private int depth = 0;
    private Iterator<String> attributeNameIterator;
    private String attributeName;
    private Iterator<String> attributeValueIterator;
    private String attributeValue;

    public ListOfComplexTypeReader(Class itemType, List<String> attributeNames, List<List<String>> items) {
        this.itemType = itemType;
        this.attributeNames = attributeNames;
        this.itemIterator = items.iterator();
    }

    public boolean hasMoreChildren() {
        switch (this.depth) {
            case 0: {
                return this.itemIterator.hasNext();
            }
            case 1: {
                return this.attributeNameIterator.hasNext();
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Depth is " + this.depth);
    }

    public void moveDown() {
        ++this.depth;
        switch (this.depth) {
            case 1: {
                this.attributeNameIterator = this.attributeNames.iterator();
                this.attributeValueIterator = this.itemIterator.next().iterator();
                break;
            }
            case 2: {
                this.attributeName = this.attributeNameIterator.next();
                this.attributeValue = this.attributeValueIterator.next();
                break;
            }
            default: {
                throw new IllegalStateException("Depth is " + this.depth);
            }
        }
    }

    public void moveUp() {
        --this.depth;
    }

    public String getNodeName() {
        switch (this.depth) {
            case 0: {
                return "list";
            }
            case 1: {
                return this.itemType.getName();
            }
            case 2: {
                return this.attributeName;
            }
        }
        throw new IllegalStateException("Depth is " + this.depth);
    }

    public String getValue() {
        return this.attributeValue;
    }

    public String getAttribute(String name) {
        return null;
    }

    public String getAttribute(int index) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeCount() {
        throw new UnsupportedOperationException();
    }

    public String getAttributeName(int index) {
        throw new UnsupportedOperationException();
    }

    public Iterator getAttributeNames() {
        return Collections.emptyList().iterator();
    }

    public void appendErrors(ErrorWriter errorWriter) {
    }

    public void close() {
        throw new UnsupportedOperationException();
    }
}

