/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.DriverListener;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;

class DriverListenerAdapter
implements MessageHandler {
    public static final long MISSING_REGISTRATION_ID = -1L;
    private final CopyBroadcastReceiver broadcastReceiver;
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final CorrelatedMessageFlyweight correlatedMessage = new CorrelatedMessageFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();
    private final DriverListener listener;
    private final Long2LongHashMap subscriberPositionMap = new Long2LongHashMap(-1L);
    private long activeCorrelationId;
    private long lastReceivedCorrelationId;
    private String expectedChannel;

    DriverListenerAdapter(CopyBroadcastReceiver broadcastReceiver, DriverListener listener) {
        this.broadcastReceiver = broadcastReceiver;
        this.listener = listener;
    }

    public int pollMessage(long activeCorrelationId, String expectedChannel) {
        this.activeCorrelationId = activeCorrelationId;
        this.lastReceivedCorrelationId = -1L;
        this.expectedChannel = expectedChannel;
        return this.broadcastReceiver.receive(this);
    }

    public long lastReceivedCorrelationId() {
        return this.lastReceivedCorrelationId;
    }

    @Override
    public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        switch (msgTypeId) {
            case 3843: {
                this.publicationReady.wrap(buffer, index);
                long correlationId = this.publicationReady.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.listener.onNewPublication(this.expectedChannel, this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.publicationReady.logFileName(), correlationId);
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3842: {
                this.imageReady.wrap(buffer, index);
                this.subscriberPositionMap.clear();
                int max = this.imageReady.subscriberPositionCount();
                for (int i = 0; i < max; ++i) {
                    long registrationId = this.imageReady.positionIndicatorRegistrationId(i);
                    int positionId = this.imageReady.subscriberPositionId(i);
                    this.subscriberPositionMap.put(registrationId, positionId);
                }
                this.listener.onAvailableImage(this.imageReady.streamId(), this.imageReady.sessionId(), this.subscriberPositionMap, this.imageReady.logFileName(), this.imageReady.sourceIdentity(), this.imageReady.correlationId());
                break;
            }
            case 3844: {
                this.correlatedMessage.wrap(buffer, index);
                long correlationId = this.correlatedMessage.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3845: {
                this.imageMessage.wrap(buffer, index);
                this.listener.onUnavailableImage(this.imageMessage.streamId(), this.imageMessage.correlationId());
                break;
            }
            case 3841: {
                this.errorResponse.wrap(buffer, index);
                long correlationId = this.errorResponse.offendingCommandCorrelationId();
                if (correlationId != this.activeCorrelationId) break;
                this.listener.onError(this.errorResponse.errorCode(), this.errorResponse.errorMessage(), correlationId);
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
        }
    }
}

