/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public class DriverProxy {
    public static final int MSG_BUFFER_CAPACITY = 1024;
    private final UnsafeBuffer buffer = new UnsafeBuffer(ByteBuffer.allocateDirect(1024));
    private final PublicationMessageFlyweight publicationMessage = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMessage = new SubscriptionMessageFlyweight();
    private final RemoveMessageFlyweight removeMessage = new RemoveMessageFlyweight();
    private final CorrelatedMessageFlyweight correlatedMessage = new CorrelatedMessageFlyweight();
    private final RingBuffer toDriverCommandBuffer;

    public DriverProxy(RingBuffer toDriverCommandBuffer) {
        this.toDriverCommandBuffer = toDriverCommandBuffer;
        this.publicationMessage.wrap(this.buffer, 0);
        this.subscriptionMessage.wrap(this.buffer, 0);
        this.correlatedMessage.wrap(this.buffer, 0);
        this.removeMessage.wrap(this.buffer, 0);
        long clientId = toDriverCommandBuffer.nextCorrelationId();
        this.correlatedMessage.clientId(clientId);
    }

    public long timeOfLastDriverKeepalive() {
        return this.toDriverCommandBuffer.consumerHeartbeatTime();
    }

    public long addPublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.publicationMessage.correlationId(correlationId);
        this.publicationMessage.streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(1, this.buffer, 0, this.publicationMessage.length())) {
            throw new IllegalStateException("could not write publication message");
        }
        return correlationId;
    }

    public long removePublication(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(2, this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new IllegalStateException("could not write publication remove message");
        }
        return correlationId;
    }

    public long addSubscription(String channel, int streamId) {
        long registrationId = -1L;
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.subscriptionMessage.correlationId(correlationId);
        this.subscriptionMessage.registrationCorrelationId(-1L).streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(4, this.buffer, 0, this.subscriptionMessage.length())) {
            throw new IllegalStateException("could not write subscription message");
        }
        return correlationId;
    }

    public long removeSubscription(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(5, this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new IllegalStateException("could not write subscription remove message");
        }
        return correlationId;
    }

    public void sendClientKeepalive() {
        this.correlatedMessage.correlationId(0L);
        if (!this.toDriverCommandBuffer.write(6, this.buffer, 0, 16)) {
            throw new IllegalStateException("could not write keepalive message");
        }
    }
}

