/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.LogBuffers;
import io.aeron.Subscription;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.Header;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.RawBlockHandler;
import io.aeron.logbuffer.TermBlockScanner;
import io.aeron.logbuffer.TermReader;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.agrona.BitUtil;
import org.agrona.ErrorHandler;
import org.agrona.ManagedResource;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.Position;

public class Image {
    private final long correlationId;
    private final int sessionId;
    private final int termLengthMask;
    private final int positionBitsToShift;
    private volatile boolean isClosed;
    private final Position subscriberPosition;
    private final UnsafeBuffer[] termBuffers;
    private final Header header;
    private final ErrorHandler errorHandler;
    private final LogBuffers logBuffers;
    private final String sourceIdentity;
    private final Subscription subscription;

    public Image(Subscription subscription, int sessionId, Position subscriberPosition, LogBuffers logBuffers, ErrorHandler errorHandler, String sourceIdentity, long correlationId) {
        this.subscription = subscription;
        this.sessionId = sessionId;
        this.subscriberPosition = subscriberPosition;
        this.logBuffers = logBuffers;
        this.errorHandler = errorHandler;
        this.sourceIdentity = sourceIdentity;
        this.correlationId = correlationId;
        this.termBuffers = logBuffers.termBuffers();
        int termLength = logBuffers.termLength();
        this.termLengthMask = termLength - 1;
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        this.header = new Header(LogBufferDescriptor.initialTermId(logBuffers.metaDataBuffer()), this.positionBitsToShift);
    }

    public int termBufferLength() {
        return this.logBuffers.termLength();
    }

    public int sessionId() {
        return this.sessionId;
    }

    public String sourceIdentity() {
        return this.sourceIdentity;
    }

    public int initialTermId() {
        return this.header.initialTermId();
    }

    public long correlationId() {
        return this.correlationId;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long position() {
        if (this.isClosed) {
            return 0L;
        }
        return this.subscriberPosition.get();
    }

    public FileChannel fileChannel() {
        return this.logBuffers.fileChannel();
    }

    public int poll(FragmentHandler fragmentHandler, int fragmentLimit) {
        if (this.isClosed) {
            return 0;
        }
        long position = this.subscriberPosition.get();
        int termOffset = (int)position & this.termLengthMask;
        UnsafeBuffer termBuffer = this.activeTermBuffer(position);
        long outcome = TermReader.read(termBuffer, termOffset, fragmentHandler, fragmentLimit, this.header, this.errorHandler);
        this.updatePosition(position, termOffset, TermReader.offset(outcome));
        return TermReader.fragmentsRead(outcome);
    }

    /*
     * Unable to fully structure code
     */
    public int controlledPoll(ControlledFragmentHandler fragmentHandler, int fragmentLimit) {
        if (this.isClosed) {
            return 0;
        }
        position = this.subscriberPosition.get();
        resultingOffset = termOffset = (int)position & this.termLengthMask;
        fragmentsRead = 0;
        termBuffer = this.activeTermBuffer(position);
        try {
            capacity = termBuffer.capacity();
            while ((length = FrameDescriptor.frameLengthVolatile(termBuffer, resultingOffset)) > 0) {
                frameOffset = resultingOffset;
                alignedLength = BitUtil.align(length, 32);
                resultingOffset += alignedLength;
                if (FrameDescriptor.isPaddingFrame(termBuffer, frameOffset)) ** GOTO lbl26
                this.header.buffer(termBuffer);
                this.header.offset(frameOffset);
                action = fragmentHandler.onFragment(termBuffer, frameOffset + 32, length - 32, this.header);
                ++fragmentsRead;
                if (action == ControlledFragmentHandler.Action.BREAK) break;
                if (action == ControlledFragmentHandler.Action.ABORT) {
                    --fragmentsRead;
                    resultingOffset = frameOffset;
                } else {
                    if (action == ControlledFragmentHandler.Action.COMMIT) {
                        termOffset = resultingOffset;
                        this.subscriberPosition.setOrdered(position += (long)alignedLength);
                    }
lbl26:
                    // 4 sources

                    if (fragmentsRead < fragmentLimit && resultingOffset < capacity) continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            this.errorHandler.onError(t);
        }
        this.updatePosition(position, termOffset, resultingOffset);
        return fragmentsRead;
    }

    public int blockPoll(BlockHandler blockHandler, int blockLengthLimit) {
        if (this.isClosed) {
            return 0;
        }
        long position = this.subscriberPosition.get();
        int termOffset = (int)position & this.termLengthMask;
        UnsafeBuffer termBuffer = this.activeTermBuffer(position);
        int limit = Math.min(termOffset + blockLengthLimit, termBuffer.capacity());
        int resultingOffset = TermBlockScanner.scan(termBuffer, termOffset, limit);
        int bytesConsumed = resultingOffset - termOffset;
        if (resultingOffset > termOffset) {
            try {
                int termId = termBuffer.getInt(termOffset + 20, ByteOrder.LITTLE_ENDIAN);
                blockHandler.onBlock(termBuffer, termOffset, bytesConsumed, this.sessionId, termId);
            }
            catch (Throwable t) {
                this.errorHandler.onError(t);
            }
            this.subscriberPosition.setOrdered(position + (long)bytesConsumed);
        }
        return bytesConsumed;
    }

    public int rawPoll(RawBlockHandler rawBlockHandler, int blockLengthLimit) {
        if (this.isClosed) {
            return 0;
        }
        long position = this.subscriberPosition.get();
        int termOffset = (int)position & this.termLengthMask;
        int activeIndex = LogBufferDescriptor.indexByPosition(position, this.positionBitsToShift);
        UnsafeBuffer termBuffer = this.termBuffers[activeIndex];
        int capacity = termBuffer.capacity();
        int limit = Math.min(termOffset + blockLengthLimit, capacity);
        int resultingOffset = TermBlockScanner.scan(termBuffer, termOffset, limit);
        int length = resultingOffset - termOffset;
        if (resultingOffset > termOffset) {
            try {
                long fileOffset = (long)capacity * (long)activeIndex + (long)termOffset;
                int termId = termBuffer.getInt(termOffset + 20, ByteOrder.LITTLE_ENDIAN);
                rawBlockHandler.onBlock(this.logBuffers.fileChannel(), fileOffset, termBuffer, termOffset, length, this.sessionId, termId);
            }
            catch (Throwable t) {
                this.errorHandler.onError(t);
            }
            this.subscriberPosition.setOrdered(position + (long)length);
        }
        return length;
    }

    private void updatePosition(long positionBefore, int offsetBefore, int offsetAfter) {
        long position = positionBefore + (long)(offsetAfter - offsetBefore);
        if (position > positionBefore) {
            this.subscriberPosition.setOrdered(position);
        }
    }

    private UnsafeBuffer activeTermBuffer(long position) {
        return this.termBuffers[LogBufferDescriptor.indexByPosition(position, this.positionBitsToShift)];
    }

    ManagedResource managedResource() {
        this.isClosed = true;
        return new ImageManagedResource();
    }

    private class ImageManagedResource
    implements ManagedResource {
        private long timeOfLastStateChange = 0L;

        private ImageManagedResource() {
        }

        @Override
        public void timeOfLastStateChange(long time) {
            this.timeOfLastStateChange = time;
        }

        @Override
        public long timeOfLastStateChange() {
            return this.timeOfLastStateChange;
        }

        @Override
        public void delete() {
            Image.this.logBuffers.close();
        }
    }
}

