/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.Image;
import io.aeron.SubscriptionFields;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.RawBlockHandler;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.collections.ArrayUtil;

public class Subscription
extends SubscriptionFields
implements AutoCloseable {
    protected long p16;
    protected long p17;
    protected long p18;
    protected long p19;
    protected long p20;
    protected long p21;
    protected long p22;
    protected long p23;
    protected long p24;
    protected long p25;
    protected long p26;
    protected long p27;
    protected long p28;
    protected long p29;
    protected long p30;

    Subscription(ClientConductor conductor, String channel, int streamId, long registrationId) {
        super(registrationId, streamId, conductor, channel);
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public int poll(FragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].poll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public int controlledPoll(ControlledFragmentHandler fragmentHandler, int fragmentLimit) {
        int i;
        int startingIndex;
        Image[] images = this.images;
        int length = images.length;
        int fragmentsRead = 0;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        for (i = 0; i < startingIndex && fragmentsRead < fragmentLimit; fragmentsRead += images[i].controlledPoll(fragmentHandler, fragmentLimit - fragmentsRead), ++i) {
        }
        return fragmentsRead;
    }

    public long blockPoll(BlockHandler blockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.blockPoll(blockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public long rawPoll(RawBlockHandler rawBlockHandler, int blockLengthLimit) {
        long bytesConsumed = 0L;
        for (Image image : this.images) {
            bytesConsumed += (long)image.rawPoll(rawBlockHandler, blockLengthLimit);
        }
        return bytesConsumed;
    }

    public int imageCount() {
        return this.images.length;
    }

    public Image imageBySessionId(int sessionId) {
        Image result = null;
        for (Image image : this.images) {
            if (sessionId != image.sessionId()) continue;
            result = image;
            break;
        }
        return result;
    }

    public List<Image> images() {
        return Arrays.asList(this.images);
    }

    public void forEachImage(Consumer<Image> imageConsumer) {
        for (Image image : this.images) {
            imageConsumer.accept(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.clientConductor.mainLock().lock();
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.clientConductor.releaseSubscription(this);
                for (Image image : this.images) {
                    this.clientConductor.unavailableImageHandler().onUnavailableImage(image);
                    this.clientConductor.lingerResource(image.managedResource());
                }
                this.images = EMPTY_ARRAY;
            }
        }
        finally {
            this.clientConductor.mainLock().unlock();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long registrationId() {
        return this.registrationId;
    }

    void addImage(Image image) {
        if (this.isClosed) {
            this.clientConductor.lingerResource(image.managedResource());
        } else {
            this.images = ArrayUtil.add(this.images, image);
        }
    }

    Image removeImage(long correlationId) {
        Image[] oldArray = this.images;
        Image removedImage = null;
        for (Image image : oldArray) {
            if (image.correlationId() != correlationId) continue;
            removedImage = image;
            break;
        }
        if (null != removedImage) {
            this.images = ArrayUtil.remove(oldArray, removedImage);
            this.clientConductor.lingerResource(removedImage.managedResource());
        }
        return removedImage;
    }

    boolean hasImage(long correlationId) {
        boolean hasImage = false;
        for (Image image : this.images) {
            if (correlationId != image.correlationId()) continue;
            hasImage = true;
            break;
        }
        return hasImage;
    }

    boolean hasNoImages() {
        return this.images.length == 0;
    }
}

