/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.NakMessageSender;
import io.aeron.logbuffer.TermGapScanner;
import org.agrona.concurrent.UnsafeBuffer;

public class LossDetector
implements TermGapScanner.GapHandler {
    private static final long TIMER_INACTIVE = -1L;
    private final FeedbackDelayGenerator delayGenerator;
    private final NakMessageSender nakMessageSender;
    private final Gap scannedGap = new Gap();
    private final Gap activeGap = new Gap();
    private long expire = -1L;
    private int rebuildOffset = 0;

    public LossDetector(FeedbackDelayGenerator delayGenerator, NakMessageSender nakMessageSender) {
        this.delayGenerator = delayGenerator;
        this.nakMessageSender = nakMessageSender;
    }

    public int rebuildOffset() {
        return this.rebuildOffset;
    }

    public int scan(UnsafeBuffer termBuffer, long rebuildPosition, long hwmPosition, long now, int termLengthMask, int positionBitsToShift, int initialTermId) {
        int workCount = 0;
        int rebuildTermOffset = (int)rebuildPosition & termLengthMask;
        int hwmTermOffset = (int)hwmPosition & termLengthMask;
        if (rebuildPosition < hwmPosition) {
            int activeTermLimit;
            int rebuildTermsCount = (int)(rebuildPosition >>> positionBitsToShift);
            int hwmTermsCount = (int)(hwmPosition >>> positionBitsToShift);
            int activeTermId = initialTermId + rebuildTermsCount;
            this.rebuildOffset = activeTermLimit = rebuildTermsCount == hwmTermsCount ? hwmTermOffset : termBuffer.capacity();
            this.rebuildOffset = TermGapScanner.scanForGap(termBuffer, activeTermId, rebuildTermOffset, activeTermLimit, this);
            if (this.rebuildOffset < activeTermLimit) {
                Gap gap = this.scannedGap;
                if (-1L == this.expire || !gap.matches(this.activeGap.termId, this.activeGap.termOffset)) {
                    this.activateGap(now, gap.termId, gap.termOffset, gap.length);
                    workCount = 1;
                }
                this.rebuildOffset = gap.termOffset;
            }
        } else {
            this.expire = -1L;
            this.rebuildOffset = rebuildTermOffset;
        }
        return workCount += this.checkTimerExpire(now);
    }

    public void onNak(long now, int termId, int termOffset) {
        if (-1L != this.expire && this.activeGap.matches(termId, termOffset)) {
            this.expire = now + this.determineNakDelay();
        }
    }

    @Override
    public void onGap(int termId, UnsafeBuffer buffer, int offset, int length) {
        this.scannedGap.reset(termId, offset, length);
    }

    private void activateGap(long now, int termId, int termOffset, int length) {
        this.activeGap.reset(termId, termOffset, length);
        if (this.determineNakDelay() == -1L) {
            return;
        }
        this.expire = now + this.determineNakDelay();
        if (this.delayGenerator.shouldFeedbackImmediately()) {
            this.sendNakMessage();
        }
    }

    private int checkTimerExpire(long now) {
        int result = 0;
        if (-1L != this.expire && now > this.expire) {
            this.sendNakMessage();
            this.expire = now + this.determineNakDelay();
            result = 1;
        }
        return result;
    }

    private void sendNakMessage() {
        this.nakMessageSender.onLossDetected(this.activeGap.termId, this.activeGap.termOffset, this.activeGap.length);
    }

    private long determineNakDelay() {
        return this.delayGenerator.generateDelay();
    }

    static final class Gap {
        int termId;
        int termOffset;
        int length;

        Gap() {
        }

        public void reset(int termId, int termOffset, int length) {
            this.termId = termId;
            this.termOffset = termOffset;
            this.length = length;
        }

        public boolean matches(int termId, int termOffset) {
            return termId == this.termId && termOffset == this.termOffset;
        }
    }
}

