/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import org.agrona.concurrent.status.AtomicCounter;

public class PublicationLink
implements DriverManagedResource {
    private final long registrationId;
    private final long unblockTimeoutNs;
    private final DriverManagedResource publication;
    private final AeronClient client;
    private final AtomicCounter unblockedPublications;
    private long lastConsumerPosition;
    private long timeOfLastConsumerPositionChange;
    private boolean reachedEndOfLife = false;

    public PublicationLink(long registrationId, DriverManagedResource publication, AeronClient client, long now, long unblockTimeoutNs, SystemCounters systemCounters) {
        this.registrationId = registrationId;
        this.publication = publication;
        this.client = client;
        this.publication.incRef();
        this.lastConsumerPosition = publication.consumerPosition();
        this.timeOfLastConsumerPositionChange = now;
        this.unblockTimeoutNs = unblockTimeoutNs;
        this.unblockedPublications = systemCounters.get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
    }

    public void close() {
        this.publication.decRef();
    }

    public long registrationId() {
        return this.registrationId;
    }

    @Override
    public void onTimeEvent(long time, DriverConductor conductor) {
        long consumerPosition;
        if (this.client.hasTimedOut(time)) {
            this.reachedEndOfLife = true;
        }
        if ((consumerPosition = this.publication.consumerPosition()) == this.lastConsumerPosition) {
            if (this.publication.producerPosition() > consumerPosition && time > this.timeOfLastConsumerPositionChange + this.unblockTimeoutNs && this.publication.unblockAtConsumerPosition()) {
                this.unblockedPublications.orderedIncrement();
            }
        } else {
            this.timeOfLastConsumerPositionChange = time;
            this.lastConsumerPosition = consumerPosition;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    @Override
    public void timeOfLastStateChange(long time) {
    }

    @Override
    public long timeOfLastStateChange() {
        return this.client.timeOfLastKeepalive();
    }

    @Override
    public void delete() {
        this.close();
    }
}

