/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.SenderRhsPadding;
import io.aeron.driver.cmd.SenderCmd;
import io.aeron.driver.media.ControlTransportPoller;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.util.function.Consumer;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public class Sender
extends SenderRhsPadding
implements Agent,
Consumer<SenderCmd> {
    private static final NetworkPublication[] EMPTY_PUBLICATIONS = new NetworkPublication[0];
    private final long statusMessageReadTimeout;
    private final int dutyCycleRatio;
    private final ControlTransportPoller controlTransportPoller;
    private final OneToOneConcurrentArrayQueue<SenderCmd> commandQueue;
    private final DriverConductorProxy conductorProxy;
    private final AtomicCounter totalBytesSent;
    private final NanoClock nanoClock;
    private NetworkPublication[] networkPublications = EMPTY_PUBLICATIONS;

    public Sender(MediaDriver.Context ctx) {
        this.controlTransportPoller = ctx.controlTransportPoller();
        this.commandQueue = ctx.senderCommandQueue();
        this.conductorProxy = ctx.fromSenderDriverConductorProxy();
        this.totalBytesSent = ctx.systemCounters().get(SystemCounterDescriptor.BYTES_SENT);
        this.nanoClock = ctx.nanoClock();
        this.statusMessageReadTimeout = ctx.statusMessageTimeout() / 2L;
        this.dutyCycleRatio = Configuration.sendToStatusMessagePollRatio();
    }

    @Override
    public int doWork() {
        int workCount = this.commandQueue.drain(this);
        long now = this.nanoClock.nanoTime();
        int bytesSent = this.doSend(now);
        int bytesReceived = 0;
        if (0 == bytesSent || ++this.dutyCycleCounter == this.dutyCycleRatio || now >= this.controlPollTimeout) {
            bytesReceived = this.controlTransportPoller.pollTransports();
            this.dutyCycleCounter = 0;
            this.controlPollTimeout = now + this.statusMessageReadTimeout;
        }
        return workCount + bytesSent + bytesReceived;
    }

    @Override
    public String roleName() {
        return "sender";
    }

    public void onRegisterSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        channelEndpoint.openChannel();
        channelEndpoint.registerForRead(this.controlTransportPoller);
        channelEndpoint.indicateActive();
    }

    public void onCloseSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        channelEndpoint.close();
    }

    public void onNewNetworkPublication(NetworkPublication publication) {
        this.networkPublications = ArrayUtil.add(this.networkPublications, publication);
        publication.sendChannelEndpoint().registerForSend(publication);
    }

    public void onRemoveNetworkPublication(NetworkPublication publication) {
        this.networkPublications = ArrayUtil.remove(this.networkPublications, publication);
        publication.sendChannelEndpoint().unregisterForSend(publication);
        this.conductorProxy.closeNetworkPublication(publication);
    }

    @Override
    public void accept(SenderCmd cmd) {
        cmd.execute(this);
    }

    private int doSend(long now) {
        int i;
        int startingIndex;
        int bytesSent = 0;
        NetworkPublication[] publications = this.networkPublications;
        int length = publications.length;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length; ++i) {
            bytesSent += publications[i].send(now);
        }
        for (i = 0; i < startingIndex; ++i) {
            bytesSent += publications[i].send(now);
        }
        this.totalBytesSent.addOrdered(bytesSent);
        return bytesSent;
    }
}

