/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import java.io.File;
import org.agrona.IoUtil;

class FileMappingConvention {
    public static final String PUBLICATIONS = "publications";
    public static final String IMAGES = "images";
    private final File publicationsDir;
    private final File imagesDir;

    FileMappingConvention(String dataDirName) {
        File dataDir = new File(dataDirName);
        IoUtil.ensureDirectoryExists(dataDir, "data directory");
        this.publicationsDir = new File(dataDir, PUBLICATIONS);
        this.imagesDir = new File(dataDir, IMAGES);
    }

    public File publicationsDir() {
        return this.publicationsDir;
    }

    public File imagesDir() {
        return this.imagesDir;
    }

    public static File streamLocation(File rootDir, String channel, int sessionId, int streamId, long correlationId) {
        String filename = String.format("%s-%s-%s-%s.logbuffer", channel, FileMappingConvention.toHexString(sessionId), FileMappingConvention.toHexString(streamId), FileMappingConvention.toHexString(correlationId));
        return new File(rootDir, filename);
    }

    private static String toHexString(int value) {
        return String.format("%X", value);
    }

    private static String toHexString(long value) {
        return String.format("%X", value);
    }
}

