/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.NetworkUtil;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.nio.ByteBuffer;
import org.agrona.BitUtil;

public class ReceiveChannelEndpointThreadLocals {
    private final ByteBuffer smBuffer;
    private final StatusMessageFlyweight statusMessageFlyweight;
    private final ByteBuffer nakBuffer;
    private final NakFlyweight nakFlyweight;

    public ReceiveChannelEndpointThreadLocals() {
        ByteBuffer byteBuffer = NetworkUtil.allocateDirectAlignedAndPadded(64, 64);
        byteBuffer.limit(28);
        this.smBuffer = byteBuffer.slice();
        this.statusMessageFlyweight = new StatusMessageFlyweight(this.smBuffer);
        int nakMessageOffset = BitUtil.align(28, 32);
        byteBuffer.limit(nakMessageOffset + 28).position(nakMessageOffset);
        this.nakBuffer = byteBuffer.slice();
        this.nakFlyweight = new NakFlyweight(this.nakBuffer);
        this.statusMessageFlyweight.version((short)0).headerType(3).frameLength(28);
        this.nakFlyweight.version((short)0).headerType(2).frameLength(28);
    }

    public ByteBuffer smBuffer() {
        return this.smBuffer;
    }

    public StatusMessageFlyweight statusMessageFlyweight() {
        return this.statusMessageFlyweight;
    }

    public ByteBuffer nakBuffer() {
        return this.nakBuffer;
    }

    public NakFlyweight nakFlyweight() {
        return this.nakFlyweight;
    }
}

