/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.EventLog;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.ChannelEndpointStatus;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.agrona.LangUtil;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.status.AtomicCounter;

@EventLog
public class SendChannelEndpoint
extends UdpChannelTransport {
    private final Int2ObjectHashMap<NetworkPublication> driversPublicationByStreamId = new Int2ObjectHashMap();
    private final BiInt2ObjectMap<NetworkPublication> sendersPublicationByStreamAndSessionId = new BiInt2ObjectMap();
    private final AtomicCounter statusMessagesReceived;
    private final AtomicCounter nakMessagesReceived;
    private final AtomicCounter statusIndicator;

    public SendChannelEndpoint(UdpChannel udpChannel, AtomicCounter statusIndicator, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteControl(), udpChannel.localControl(), udpChannel.remoteData(), context.errorLog(), context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS));
        this.nakMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.NAK_MESSAGES_RECEIVED);
        this.statusMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.STATUS_MESSAGES_RECEIVED);
        this.statusIndicator = statusIndicator;
    }

    public void openChannel() {
        this.openDatagramChannel(this.statusIndicator);
    }

    public String originalUriString() {
        return this.udpChannel().originalUriString();
    }

    public boolean isStatusIndicatorClosed() {
        return this.statusIndicator.isClosed();
    }

    public void indicateActive() {
        long currentStatus = this.statusIndicator.get();
        if (currentStatus != 0L) {
            throw new IllegalStateException("Channel cannot be registered unless INITALIZING: status=" + ChannelEndpointStatus.status(currentStatus));
        }
        this.statusIndicator.setOrdered(1L);
    }

    public void closeStatusIndicator() {
        if (!this.statusIndicator.isClosed()) {
            this.statusIndicator.setOrdered(2L);
            this.statusIndicator.close();
        }
    }

    public NetworkPublication getPublication(int streamId) {
        return this.driversPublicationByStreamId.get(streamId);
    }

    public void addPublication(NetworkPublication publication) {
        this.driversPublicationByStreamId.put(publication.streamId(), publication);
    }

    public NetworkPublication removePublication(NetworkPublication publication) {
        return this.driversPublicationByStreamId.remove(publication.streamId());
    }

    public int sessionCount() {
        return this.driversPublicationByStreamId.size();
    }

    public void registerForSend(NetworkPublication publication) {
        this.sendersPublicationByStreamAndSessionId.put(publication.sessionId(), publication.streamId(), publication);
    }

    public void unregisterForSend(NetworkPublication publication) {
        this.sendersPublicationByStreamAndSessionId.remove(publication.sessionId(), publication.streamId());
    }

    public int send(ByteBuffer buffer) {
        int byteSent = 0;
        try {
            this.presend(buffer, this.connectAddress);
            byteSent = this.sendDatagramChannel.write(buffer);
        }
        catch (PortUnreachableException | ClosedChannelException iOException) {
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return byteSent;
    }

    protected void presend(ByteBuffer buffer, InetSocketAddress address) {
    }

    public void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress srcAddress) {
        NetworkPublication publication = this.sendersPublicationByStreamAndSessionId.get(msg.sessionId(), msg.streamId());
        if (null != publication) {
            if (128 == (msg.flags() & 0x80)) {
                publication.triggerSendSetupFrame();
            } else {
                publication.onStatusMessage(msg.consumptionTermId(), msg.consumptionTermOffset(), msg.receiverWindowLength(), srcAddress);
            }
            this.statusMessagesReceived.orderedIncrement();
        }
    }

    public void onNakMessage(NakFlyweight msg, InetSocketAddress srcAddress) {
        NetworkPublication publication = this.sendersPublicationByStreamAndSessionId.get(msg.sessionId(), msg.streamId());
        if (null != publication) {
            publication.onNak(msg.termId(), msg.termOffset(), msg.length());
            this.nakMessagesReceived.orderedIncrement();
        }
    }
}

