/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ErrorCode;
import io.aeron.driver.Configuration;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.uri.AeronUri;
import io.aeron.driver.uri.InterfaceSearchAddress;
import io.aeron.driver.uri.UriUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import org.agrona.BitUtil;
import org.agrona.Strings;

public final class UdpChannel {
    public static final String UDP_MEDIA_ID = "udp";
    public static final String REMOTE_KEY = "remote";
    public static final String LOCAL_KEY = "local";
    public static final String INTERFACE_KEY = "interface";
    public static final String GROUP_KEY = "group";
    public static final String ENDPOINT_KEY = "endpoint";
    public static final String MULTICAST_TTL_KEY = "ttl";
    private final int multicastTtl;
    private final InetSocketAddress remoteData;
    private final InetSocketAddress localData;
    private final InetSocketAddress remoteControl;
    private final InetSocketAddress localControl;
    private final String uriStr;
    private final String canonicalForm;
    private final NetworkInterface localInterface;
    private final ProtocolFamily protocolFamily;
    private final AeronUri aeronUri;

    public static UdpChannel parse(String uriStr) {
        try {
            AeronUri aeronUri = UdpChannel.parseIntoAeronUri(uriStr);
            UdpChannel.validateConfiguration(aeronUri);
            Context context = new Context().uriStr(uriStr).aeronUri(aeronUri);
            InetSocketAddress endpointAddress = UdpChannel.getEndpointAddress(aeronUri);
            if (null == endpointAddress) {
                throw new IllegalArgumentException("Aeron URIs for UDP must specify an endpoint address");
            }
            if (endpointAddress.isUnresolved()) {
                throw new UnknownHostException("could not resolve endpoint address: " + endpointAddress);
            }
            if (endpointAddress.getAddress().isMulticastAddress()) {
                byte[] addressAsBytes = endpointAddress.getAddress().getAddress();
                UdpChannel.validateDataAddress(addressAsBytes);
                int n = addressAsBytes.length - 1;
                addressAsBytes[n] = (byte)(addressAsBytes[n] + 1);
                InetSocketAddress controlAddress = new InetSocketAddress(InetAddress.getByAddress(addressAsBytes), endpointAddress.getPort());
                InterfaceSearchAddress searchAddress = UdpChannel.getInterfaceSearchAddress(aeronUri);
                NetworkInterface localInterface = UdpChannel.findInterface(searchAddress);
                InetSocketAddress localAddress = UdpChannel.resolveToAddressOfInterface(localInterface, searchAddress);
                ProtocolFamily protocolFamily = NetworkUtil.getProtocolFamily(endpointAddress.getAddress());
                int multicastTtl = UdpChannel.getMulticastTtl(aeronUri);
                context.localControlAddress(localAddress).remoteControlAddress(controlAddress).localDataAddress(localAddress).remoteDataAddress(endpointAddress).localInterface(localInterface).multicastTtl(multicastTtl).protocolFamily(protocolFamily).canonicalForm(UdpChannel.canonicalise(localAddress, endpointAddress));
            } else {
                InetSocketAddress localAddress;
                InterfaceSearchAddress searchAddress = UdpChannel.getInterfaceSearchAddress(aeronUri);
                if (searchAddress.getInetAddress().isAnyLocalAddress()) {
                    localAddress = searchAddress.getAddress();
                } else {
                    NetworkInterface localInterface = UdpChannel.findInterface(searchAddress);
                    localAddress = UdpChannel.resolveToAddressOfInterface(localInterface, searchAddress);
                }
                ProtocolFamily protocolFamily = !aeronUri.containsKey(LOCAL_KEY) ? NetworkUtil.getProtocolFamily(endpointAddress.getAddress()) : NetworkUtil.getProtocolFamily(localAddress.getAddress());
                context.remoteControlAddress(endpointAddress).remoteDataAddress(endpointAddress).localControlAddress(localAddress).localDataAddress(localAddress).protocolFamily(protocolFamily).canonicalForm(UdpChannel.canonicalise(localAddress, endpointAddress));
            }
            return new UdpChannel(context);
        }
        catch (Exception ex) {
            throw new InvalidChannelException(ErrorCode.INVALID_CHANNEL, ex);
        }
    }

    private static InterfaceSearchAddress getInterfaceSearchAddress(AeronUri uri) throws UnknownHostException {
        InterfaceSearchAddress interfaceSearchAddress = uri.containsKey(INTERFACE_KEY) ? uri.getInterfaceSearchAddress(INTERFACE_KEY, InterfaceSearchAddress.wildcard()) : (uri.containsKey(LOCAL_KEY) ? uri.getInterfaceSearchAddress(LOCAL_KEY, InterfaceSearchAddress.wildcard()) : InterfaceSearchAddress.wildcard());
        return interfaceSearchAddress;
    }

    private static InetSocketAddress getEndpointAddress(AeronUri uri) throws UnknownHostException {
        InetSocketAddress endpointAddress = uri.containsKey(ENDPOINT_KEY) ? uri.getSocketAddress(ENDPOINT_KEY) : (uri.containsKey(GROUP_KEY) ? uri.getSocketAddress(GROUP_KEY) : (uri.containsKey(REMOTE_KEY) ? uri.getSocketAddress(REMOTE_KEY) : null));
        return endpointAddress;
    }

    private static int getMulticastTtl(AeronUri uri) {
        int ttl = uri.containsKey(MULTICAST_TTL_KEY) ? Integer.parseInt(uri.get(MULTICAST_TTL_KEY)) : Configuration.SOCKET_MULTICAST_TTL;
        return ttl;
    }

    private static void validateDataAddress(byte[] addressAsBytes) {
        if (BitUtil.isEven(addressAsBytes[addressAsBytes.length - 1])) {
            throw new IllegalArgumentException("Multicast data address must be odd");
        }
    }

    private static void validateConfiguration(AeronUri uri) {
        UdpChannel.validateMedia(uri);
    }

    private static void validateMedia(AeronUri uri) {
        if (!UDP_MEDIA_ID.equals(uri.media())) {
            throw new IllegalArgumentException("Udp channel only supports udp media: " + uri);
        }
    }

    private static AeronUri parseIntoAeronUri(String uriStr) throws URISyntaxException, UnknownHostException {
        if (uriStr.startsWith("udp:")) {
            System.err.println("Warning: deprecated API usage - please use 'aeron:udp' rather than 'udp:'");
            return UdpChannel.parseUdpUriToAeronUri(uriStr);
        }
        if (uriStr.startsWith("aeron:")) {
            return AeronUri.parse(uriStr);
        }
        throw new IllegalArgumentException("malformed channel URI: " + uriStr);
    }

    private static AeronUri parseUdpUriToAeronUri(String uriStr) throws URISyntaxException, UnknownHostException {
        URI uri = new URI(uriStr);
        String userInfo = uri.getUserInfo();
        int uriPort = uri.getPort();
        HashMap params = UriUtil.parseQueryString(uri, new HashMap());
        if (uriPort < 0) {
            throw new IllegalArgumentException("Port must be specified");
        }
        InetAddress hostAddress = InetAddress.getByName(uri.getHost());
        if (hostAddress.isMulticastAddress()) {
            String group = uri.getHost() + ':' + uriPort;
            String inf = UdpChannel.interfaceStringOf(userInfo, (String)params.get("subnetPrefix"));
            return AeronUri.builder().media(UDP_MEDIA_ID).param(GROUP_KEY, group).param(INTERFACE_KEY, inf).newInstance();
        }
        String remote = uri.getHost() + ':' + uriPort;
        return AeronUri.builder().media(UDP_MEDIA_ID).param(REMOTE_KEY, remote).param(LOCAL_KEY, userInfo).newInstance();
    }

    private static String interfaceStringOf(String userInfo, String subnetPrefix) {
        if (Strings.isEmpty(userInfo)) {
            return null;
        }
        if (Strings.isEmpty(subnetPrefix)) {
            return userInfo;
        }
        return userInfo + '/' + subnetPrefix;
    }

    private static InetSocketAddress resolveToAddressOfInterface(NetworkInterface localInterface, InterfaceSearchAddress searchAddress) {
        InetAddress interfaceAddress = NetworkUtil.findAddressOnInterface(localInterface, searchAddress.getInetAddress(), searchAddress.getSubnetPrefix());
        if (null == interfaceAddress) {
            throw new IllegalStateException();
        }
        return new InetSocketAddress(interfaceAddress, searchAddress.getPort());
    }

    private static NetworkInterface findInterface(InterfaceSearchAddress searchAddress) throws SocketException, UnknownHostException {
        Collection<NetworkInterface> filteredIfcs = NetworkUtil.filterBySubnet(searchAddress.getInetAddress(), searchAddress.getSubnetPrefix());
        for (NetworkInterface ifc : filteredIfcs) {
            if (!ifc.supportsMulticast() && !ifc.isLoopback()) continue;
            return ifc;
        }
        throw new IllegalArgumentException(UdpChannel.errorNoMatchingInterfaces(filteredIfcs, searchAddress));
    }

    public InetSocketAddress remoteData() {
        return this.remoteData;
    }

    public InetSocketAddress localData() {
        return this.localData;
    }

    public InetSocketAddress remoteControl() {
        return this.remoteControl;
    }

    public InetSocketAddress localControl() {
        return this.localControl;
    }

    public AeronUri aeronUri() {
        return this.aeronUri;
    }

    public int multicastTtl() {
        return this.multicastTtl;
    }

    private UdpChannel(Context context) {
        this.remoteData = context.remoteData;
        this.localData = context.localData;
        this.remoteControl = context.remoteControl;
        this.localControl = context.localControl;
        this.uriStr = context.uriStr;
        this.canonicalForm = context.canonicalForm;
        this.localInterface = context.localInterface;
        this.protocolFamily = context.protocolFamily;
        this.multicastTtl = context.multicastTtl;
        this.aeronUri = context.aeronUri;
    }

    public String canonicalForm() {
        return this.canonicalForm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UdpChannel that = (UdpChannel)o;
        return !(this.canonicalForm == null ? that.canonicalForm != null : !this.canonicalForm.equals(that.canonicalForm));
    }

    public int hashCode() {
        return this.canonicalForm != null ? this.canonicalForm.hashCode() : 0;
    }

    public String toString() {
        return this.canonicalForm;
    }

    public static String canonicalise(InetSocketAddress localData, InetSocketAddress remoteData) {
        return "UDP-" + BitUtil.toHex(localData.getAddress().getAddress()) + '-' + localData.getPort() + '-' + BitUtil.toHex(remoteData.getAddress().getAddress()) + '-' + remoteData.getPort();
    }

    public boolean isMulticast() {
        return this.remoteData.getAddress().isMulticastAddress();
    }

    public NetworkInterface localInterface() throws SocketException {
        return this.localInterface;
    }

    public String originalUriString() {
        return this.uriStr;
    }

    public ProtocolFamily protocolFamily() {
        return this.protocolFamily;
    }

    private static String errorNoMatchingInterfaces(Collection<NetworkInterface> filteredIfcs, InterfaceSearchAddress address) throws SocketException {
        StringBuilder builder = new StringBuilder();
        builder.append("Unable to find multicast interface matching criteria: ").append(address.getAddress()).append('/').append(address.getSubnetPrefix());
        if (filteredIfcs.size() > 0) {
            builder.append(System.lineSeparator()).append("  Candidates:");
            for (NetworkInterface ifc : filteredIfcs) {
                builder.append(System.lineSeparator()).append("  - Name: ").append(ifc.getDisplayName()).append(", addresses: ").append(ifc.getInterfaceAddresses()).append(", multicast: ").append(ifc.supportsMulticast());
            }
        }
        return builder.toString();
    }

    public String description() {
        StringBuilder builder = new StringBuilder("UdpChannel - ");
        if (null != this.localInterface) {
            builder.append("interface: ").append(this.localInterface.getDisplayName()).append(", ");
        }
        builder.append("localData: ").append(this.localData).append(", remoteData: ").append(this.remoteData).append(", ttl: ").append(this.multicastTtl);
        return builder.toString();
    }

    static class Context {
        private int multicastTtl;
        private InetSocketAddress remoteData;
        private InetSocketAddress localData;
        private InetSocketAddress remoteControl;
        private InetSocketAddress localControl;
        private String uriStr;
        private String canonicalForm;
        private NetworkInterface localInterface;
        private ProtocolFamily protocolFamily;
        private AeronUri aeronUri;

        Context() {
        }

        public Context uriStr(String uri) {
            this.uriStr = uri;
            return this;
        }

        public Context remoteDataAddress(InetSocketAddress remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Context localDataAddress(InetSocketAddress localData) {
            this.localData = localData;
            return this;
        }

        public Context remoteControlAddress(InetSocketAddress remoteControl) {
            this.remoteControl = remoteControl;
            return this;
        }

        public Context localControlAddress(InetSocketAddress localControl) {
            this.localControl = localControl;
            return this;
        }

        public Context canonicalForm(String canonicalForm) {
            this.canonicalForm = canonicalForm;
            return this;
        }

        public Context localInterface(NetworkInterface ifc) {
            this.localInterface = ifc;
            return this;
        }

        public Context protocolFamily(ProtocolFamily protocolFamily) {
            this.protocolFamily = protocolFamily;
            return this;
        }

        public Context multicastTtl(int multicastTtl) {
            this.multicastTtl = multicastTtl;
            return this;
        }

        public Context aeronUri(AeronUri aeronUri) {
            this.aeronUri = aeronUri;
            return this;
        }
    }
}

