/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.uri;

import io.aeron.driver.uri.InterfaceSearchAddress;
import io.aeron.driver.uri.SocketAddressUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class AeronUri {
    private static final String AERON_PREFIX = "aeron:";
    private final String scheme;
    private final String media;
    private final Map<String, String> params;

    public AeronUri(String scheme, String media, Map<String, String> params) {
        this.scheme = scheme;
        this.media = media;
        this.params = params;
        if (null != params.get("local")) {
            System.err.println("Warning: deprecated API usage - please use 'interface' rather than 'local'");
        }
        if (null != params.get("remote") || null != params.get("group")) {
            System.err.println("Warning: deprecated API usage - please use 'endpoint' rather than 'remote' or 'group'");
        }
    }

    public String media() {
        return this.media;
    }

    public String scheme() {
        return this.scheme;
    }

    public String get(String key) {
        return this.params.get(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.params.get(key);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    public InetAddress getInetAddress(String key) throws UnknownHostException {
        return InetAddress.getByName(this.get(key));
    }

    public InetSocketAddress getSocketAddress(String key) {
        return SocketAddressUtil.parse(this.get(key));
    }

    public InetSocketAddress getSocketAddress(String key, int defaultPort, InetSocketAddress defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        return SocketAddressUtil.parse((CharSequence)this.get(key), defaultPort);
    }

    public InterfaceSearchAddress getInterfaceSearchAddress(String key, InterfaceSearchAddress defaultValue) throws UnknownHostException {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        return InterfaceSearchAddress.parse(this.get(key));
    }

    public boolean containsKey(String key) {
        return this.params.containsKey(key);
    }

    public boolean containsAnyKey(String[] keys) {
        for (String key : keys) {
            if (!this.params.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static AeronUri parse(CharSequence cs) {
        if (!AeronUri.startsWith(cs, AERON_PREFIX)) {
            throw new IllegalArgumentException("AeronUri must start with 'aeron:', found: '" + cs + "'");
        }
        StringBuilder builder = new StringBuilder();
        String scheme = "aeron";
        HashMap<String, String> params = new HashMap<String, String>();
        String media = null;
        String key = null;
        State state = State.MEDIA;
        block19: for (int i = AERON_PREFIX.length(); i < cs.length(); ++i) {
            char c = cs.charAt(i);
            switch (state) {
                case MEDIA: {
                    switch (c) {
                        case '?': {
                            media = builder.toString();
                            builder.setLength(0);
                            state = State.PARAMS_KEY;
                            continue block19;
                        }
                        case ':': {
                            throw new IllegalArgumentException("Encountered ':' within media definition");
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                case PARAMS_KEY: {
                    switch (c) {
                        case '=': {
                            key = builder.toString();
                            builder.setLength(0);
                            state = State.PARAMS_VALUE;
                            continue block19;
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                case PARAMS_VALUE: {
                    switch (c) {
                        case '|': {
                            params.put(key, builder.toString());
                            builder.setLength(0);
                            state = State.PARAMS_KEY;
                            continue block19;
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                default: {
                    throw new IllegalStateException("Que? State = " + (Object)((Object)state));
                }
            }
        }
        switch (state) {
            case MEDIA: {
                media = builder.toString();
                break;
            }
            case PARAMS_VALUE: {
                params.put(key, builder.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("No more input found, but was in state: " + (Object)((Object)state));
            }
        }
        return new AeronUri("aeron", media, params);
    }

    private static boolean startsWith(CharSequence input, CharSequence prefix) {
        if (input.length() < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (input.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> params = new HashMap<String, String>();
        private String media;

        public Builder media(String media) {
            this.media = media;
            return this;
        }

        public Builder param(String key, String value) {
            if (null != key && null != value) {
                this.params.put(key, value);
            }
            return this;
        }

        public AeronUri newInstance() {
            return new AeronUri("aeron", this.media, this.params);
        }
    }

    private static enum State {
        MEDIA,
        PARAMS_KEY,
        PARAMS_VALUE;

    }
}

