/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.uri;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.agrona.Strings;

public class InterfaceSearchAddress {
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("([^:/]+)(?::(?<port>[0-9]+))?(?:/(?<subnet>[0-9]+))?");
    private static final Pattern IPV6_ADDRESS_PATTERN = Pattern.compile("\\[([0-9A-Fa-f:]+)\\](?::(?<port>[0-9]+))?(?:/(?<subnet>[0-9]+))?");
    private final InetSocketAddress address;
    private final int subnetPrefix;

    public InterfaceSearchAddress(InetSocketAddress address, int subnetPrefix) {
        this.address = address;
        this.subnetPrefix = subnetPrefix;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetAddress getInetAddress() {
        return this.address.getAddress();
    }

    public int getSubnetPrefix() {
        return this.subnetPrefix;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public static InterfaceSearchAddress parse(String s) throws UnknownHostException {
        if (Strings.isEmpty(s)) {
            throw new IllegalArgumentException("Search address string is null or empty");
        }
        Matcher matcher = InterfaceSearchAddress.getMatcher(s);
        InetAddress hostAddress = InetAddress.getByName(matcher.group(1));
        int defaultSubnetPrefix = hostAddress.getAddress().length * 8;
        int port = Strings.parseIntOrDefault(matcher.group("port"), 0);
        int subnetPrefix = Strings.parseIntOrDefault(matcher.group("subnet"), defaultSubnetPrefix);
        return new InterfaceSearchAddress(new InetSocketAddress(hostAddress, port), subnetPrefix);
    }

    private static Matcher getMatcher(CharSequence cs) {
        Matcher ipV4Matcher = IPV4_ADDRESS_PATTERN.matcher(cs);
        if (ipV4Matcher.matches()) {
            return ipV4Matcher;
        }
        Matcher ipV6Matcher = IPV6_ADDRESS_PATTERN.matcher(cs);
        if (ipV6Matcher.matches()) {
            return ipV6Matcher;
        }
        throw new IllegalArgumentException("Invalid search address: " + cs);
    }

    public static InterfaceSearchAddress wildcard() {
        return new InterfaceSearchAddress(new InetSocketAddress(0), 0);
    }
}

