/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.UnsafeBuffer;

public class TermReader {
    public static long read(UnsafeBuffer termBuffer, int offset, FragmentHandler handler, int fragmentsLimit, Header header, ErrorHandler errorHandler) {
        int fragmentsRead = 0;
        int capacity = termBuffer.capacity();
        try {
            int frameLength;
            while ((frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, offset)) > 0) {
                int termOffset = offset;
                offset += BitUtil.align(frameLength, 32);
                if (!FrameDescriptor.isPaddingFrame(termBuffer, termOffset)) {
                    header.buffer(termBuffer);
                    header.offset(termOffset);
                    handler.onFragment(termBuffer, termOffset + 32, frameLength - 32, header);
                    ++fragmentsRead;
                }
                if (fragmentsRead < fragmentsLimit && offset < capacity) continue;
                break;
            }
        }
        catch (Throwable t) {
            errorHandler.onError(t);
        }
        return TermReader.pack(offset, fragmentsRead);
    }

    public static long pack(int offset, int fragmentsRead) {
        return (long)offset << 32 | (long)fragmentsRead;
    }

    public static int fragmentsRead(long readOutcome) {
        return (int)readOutcome;
    }

    public static int offset(long readOutcome) {
        return (int)(readOutcome >>> 32);
    }
}

