/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorLogReader;

public class ErrorStat {
    public static void main(String[] args) throws Exception {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "cnc");
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        if (5 != cncVersion) {
            throw new IllegalStateException("CNC version not supported: file version=" + cncVersion);
        }
        UnsafeBuffer buffer = CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, cncMetaDataBuffer);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        int distinctErrorCount = ErrorLogReader.read(buffer, (observationCount, firstObservationTimestamp, lastObservationTimestamp, encodedException) -> System.out.format("***%n%d observations from %s to %s for:%n %s%n", observationCount, dateFormat.format(new Date(firstObservationTimestamp)), dateFormat.format(new Date(lastObservationTimestamp)), encodedException));
        System.out.format("%n%d distinct errors observed.%n", distinctErrorCount);
    }
}

