/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import io.aeron.shadow.org.HdrHistogram.Histogram;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.agrona.concurrent.SigInt;

public class SendReceiveUdpPing {
    public static void main(String[] args) throws IOException {
        int numChannels = 1;
        if (1 == args.length) {
            numChannels = Integer.parseInt(args[0]);
        }
        Histogram histogram = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        DatagramChannel[] receiveChannels = new DatagramChannel[numChannels];
        for (int i = 0; i < receiveChannels.length; ++i) {
            receiveChannels[i] = DatagramChannel.open();
            Common.init(receiveChannels[i]);
            receiveChannels[i].bind(new InetSocketAddress("localhost", 40123 + i));
        }
        InetSocketAddress sendAddress = new InetSocketAddress("localhost", 50123);
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            SendReceiveUdpPing.measureRoundTrip(histogram, sendAddress, buffer, receiveChannels, sendChannel, running);
            histogram.reset();
            System.gc();
            LockSupport.parkNanos(1000000000L);
        }
    }

    private static void measureRoundTrip(Histogram histogram, InetSocketAddress sendAddress, ByteBuffer buffer, DatagramChannel[] receiveChannels, DatagramChannel sendChannel, AtomicBoolean running) throws IOException {
        for (int sequenceNumber = 0; sequenceNumber < 10000; ++sequenceNumber) {
            long timestamp = System.nanoTime();
            buffer.clear();
            buffer.putLong(sequenceNumber);
            buffer.putLong(timestamp);
            buffer.flip();
            sendChannel.send(buffer, sendAddress);
            buffer.clear();
            boolean available = false;
            block1: while (!available) {
                if (!running.get()) {
                    return;
                }
                for (int i = receiveChannels.length - 1; i >= 0; --i) {
                    if (null == receiveChannels[i].receive(buffer)) continue;
                    available = true;
                    continue block1;
                }
            }
            long receivedSequenceNumber = buffer.getLong(0);
            if (receivedSequenceNumber != (long)sequenceNumber) {
                throw new IllegalStateException("Data Loss:" + sequenceNumber + " to " + receivedSequenceNumber);
            }
            long duration = System.nanoTime() - buffer.getLong(8);
            histogram.recordValue(duration);
        }
        histogram.outputPercentileDistribution(System.out, 1000.0);
    }
}

