/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.MappedByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.concurrent.SigInt;

public class TransferToPong {
    private static final String LOCALHOST = "localhost";

    public static void main(String[] args) throws IOException {
        long bytesSent;
        FileChannel receiveFileChannel = Common.createTmpFileChannel();
        MappedByteBuffer receiveByteBuffer = receiveFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 4096L);
        DatagramChannel receiveDatagramChannel = DatagramChannel.open();
        Common.init(receiveDatagramChannel);
        receiveDatagramChannel.bind(new InetSocketAddress(LOCALHOST, 40124));
        receiveDatagramChannel.connect(new InetSocketAddress(LOCALHOST, 40123));
        FileChannel sendFileChannel = Common.createTmpFileChannel();
        MappedByteBuffer sendByteBuffer = sendFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 4096L);
        DatagramChannel sendDatagramChannel = DatagramChannel.open();
        Common.init(sendDatagramChannel);
        sendDatagramChannel.bind(new InetSocketAddress(LOCALHOST, 40125));
        sendDatagramChannel.connect(new InetSocketAddress(LOCALHOST, 40126));
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        int packetSize = 16;
        do {
            boolean available = false;
            while (!available) {
                if (!running.get()) {
                    return;
                }
                long bytesReceived = receiveFileChannel.transferFrom(receiveDatagramChannel, 0L, 16L);
                if (16L != bytesReceived) continue;
                available = true;
            }
            long receivedSequenceNumber = receiveByteBuffer.getLong(0);
            long receivedTimestamp = receiveByteBuffer.getLong(8);
            sendByteBuffer.putLong(0, receivedSequenceNumber);
            sendByteBuffer.putLong(8, receivedTimestamp);
        } while (16L == (bytesSent = sendFileChannel.transferTo(0L, 16L, sendDatagramChannel)));
        throw new IllegalStateException("Invalid bytes sent " + bytesSent);
    }
}

