/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.data.SchemaUtil;
import io.debezium.doc.FixFor;
import java.nio.ByteBuffer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class SchemaUtilTest {
    @Test
    @FixFor(value={"DBZ-759"})
    public void correctlySerializesByteArray() {
        Assertions.assertThat((String)SchemaUtil.asString((Object)new byte[]{1, 3, 5, 7})).isEqualTo((Object)"[1, 3, 5, 7]");
    }

    @Test
    @FixFor(value={"DBZ-759"})
    public void correctlySerializesByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(3);
        buffer.put(new byte[]{11, 13, 17});
        Assertions.assertThat((String)SchemaUtil.asString((Object)buffer)).isEqualTo((Object)"[11, 13, 17]");
    }

    @Test
    @FixFor(value={"DBZ-759"})
    public void correctlySerializesStructWithByteArray() {
        Schema schema = SchemaBuilder.struct().field("some_field", SchemaBuilder.bytes().build()).build();
        Struct struct = new Struct(schema).put("some_field", (Object)new byte[]{1, 3, 5, 7});
        Assertions.assertThat((String)SchemaUtil.asString((Struct)struct)).isEqualTo((Object)"{\"some_field\" : [1, 3, 5, 7]}");
    }
}

