/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.IoUtil;
import io.debezium.util.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.junit.Before;

public interface Testing {
    @Before
    default public void resetBeforeEachTest() {
        Print.enabled = false;
        Debug.enabled = false;
        Timer.reset();
    }

    public static void print(Object message) {
        if (message != null && Print.enabled) {
            System.out.println(message);
        }
    }

    public static void print(int length, String leader, Object message) {
        if (message != null && Print.enabled) {
            int len = leader.length();
            System.out.print(leader);
            if (len < length) {
                for (int i = len; i != length; ++i) {
                    System.out.print(" ");
                }
            }
            System.out.println(message);
        }
    }

    public static void debug(Object message) {
        if (message != null && Debug.enabled) {
            System.out.println(message);
        }
    }

    public static void printError(Object message) {
        if (message != null) {
            System.err.println(message);
        }
    }

    public static void printError(Throwable throwable) {
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static void printError(String message, Throwable throwable) {
        Testing.printError(message);
        Testing.printError(throwable);
    }

    default public Stopwatch.Statistics once(InterruptableFunction runnable) throws InterruptedException {
        return Timer.time(null, 1, runnable, null);
    }

    default public <T> Stopwatch.Statistics once(Callable<T> runnable, Consumer<T> cleanup) throws InterruptedException {
        return Timer.time(null, 1, runnable, cleanup);
    }

    default public Stopwatch.Statistics time(String desc, int repeat, InterruptableFunction runnable) throws InterruptedException {
        return Timer.time(desc, repeat, runnable, null);
    }

    default public <T> Stopwatch.Statistics time(String desc, int repeat, Callable<T> runnable, Consumer<T> cleanup) throws InterruptedException {
        return Timer.time(desc, repeat, runnable, cleanup);
    }

    @FunctionalInterface
    public static interface InterruptableFunction
    extends Callable<Void> {
        @Override
        public Void call() throws InterruptedException;
    }

    public static final class Timer {
        private static Stopwatch sw = Stopwatch.accumulating();
        private static Stopwatch.StopwatchSet sws = Stopwatch.multiple();

        public static void reset() {
            sw = Stopwatch.accumulating();
            sws = Stopwatch.multiple();
        }

        public static Stopwatch.Statistics completionTime() {
            return sw.durations().statistics();
        }

        public static Stopwatch.Statistics operationTimes() {
            return sws.statistics();
        }

        protected static <T> Stopwatch.Statistics time(String desc, int repeat, Callable<T> runnable, Consumer<T> cleanup) throws InterruptedException {
            sw.start();
            try {
                sws.time(repeat, runnable, result -> {
                    if (cleanup != null) {
                        cleanup.accept(result);
                    }
                });
            }
            catch (Throwable t) {
                t.printStackTrace();
                Fail.fail((String)t.getMessage());
            }
            sw.stop();
            return sw.durations().statistics();
        }
    }

    public static interface Files {
        public static InputStream readResourceAsStream(String pathOnClasspath, Class<?> testClass) {
            InputStream stream = testClass.getClassLoader().getResourceAsStream(pathOnClasspath);
            Assertions.assertThat((Object)stream).isNotNull();
            return stream;
        }

        public static InputStream readResourceAsStream(String pathOnClasspath) {
            return Files.readResourceAsStream(pathOnClasspath, Testing.class);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static String readResourceAsString(String pathOnClasspath) {
            try (InputStream stream = Files.readResourceAsStream(pathOnClasspath);){
                String string = IoUtil.read((InputStream)stream);
                return string;
            }
            catch (IOException e) {
                Fail.fail((String)("Unable to read '" + pathOnClasspath + "'"), (Throwable)e);
                return null;
            }
        }

        public static File createTestingDirectory(String relativePath) {
            Path dirPath = Paths.get("target/data", relativePath).toAbsolutePath();
            return IoUtil.createDirectory((Path)dirPath);
        }

        public static File createTestingFile() {
            return Files.createTestingFile(UUID.randomUUID().toString());
        }

        public static File createTestingFile(String relativePath) {
            Path path = Paths.get("target/data", relativePath).toAbsolutePath();
            return IoUtil.createFile((Path)path);
        }

        public static File createTestingFile(Path relativePath) {
            Path path = relativePath.toAbsolutePath();
            if (!Files.inTargetDir(path)) {
                throw new IllegalStateException("Expecting '" + relativePath + "' to be within the testing directory");
            }
            return IoUtil.createFile((Path)path);
        }

        public static Path createTestingPath(String relativePath) {
            return Paths.get("target/data", relativePath).toAbsolutePath();
        }

        public static File createTestingDirectory(String relativePath, boolean removeExistingContent) throws IOException {
            Path dirPath = Paths.get("target/data", relativePath).toAbsolutePath();
            return IoUtil.createDirectory((Path)dirPath, (boolean)removeExistingContent);
        }

        public static void delete(String path) {
            if (path != null) {
                Files.delete(Paths.get(path, new String[0]));
            }
        }

        public static void delete(File fileOrFolder) {
            if (fileOrFolder != null) {
                Files.delete(fileOrFolder.toPath());
            }
        }

        public static void delete(Path path) {
            if (path != null) {
                if (Files.inTargetDir(path = path.toAbsolutePath())) {
                    try {
                        IoUtil.delete((Path)path);
                    }
                    catch (IOException e) {
                        Testing.printError("Unable to remove '" + path.toAbsolutePath() + "'", e);
                    }
                } else {
                    Testing.printError("Will not remove directory that is outside test target area: " + path);
                }
            }
        }

        public static boolean inTargetDir(File file) {
            return Files.inTargetDir(file.toPath());
        }

        public static boolean inTargetDir(Path path) {
            Path target = FileSystems.getDefault().getPath("target", new String[0]).toAbsolutePath();
            return path.toAbsolutePath().startsWith(target);
        }
    }

    public static interface Network {
        public static int getAvailablePort() {
            return IoUtil.getAvailablePort();
        }
    }

    public static final class Debug {
        private static boolean enabled = false;

        public static void enable() {
            enabled = true;
        }

        public static void disable() {
            enabled = true;
        }

        public static boolean isEnabled() {
            return enabled;
        }
    }

    public static final class Print {
        private static boolean enabled = false;

        public static void enable() {
            enabled = true;
        }

        public static void disable() {
            enabled = false;
        }

        public static boolean isEnabled() {
            return enabled;
        }
    }
}

