/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.ColumnImpl;
import java.util.Optional;

final class ColumnEditorImpl
implements ColumnEditor {
    private String name;
    private int jdbcType = 4;
    private int nativeType = -1;
    private String typeName;
    private String typeExpression;
    private String charsetName;
    private String tableCharsetName;
    private int length = -1;
    private Integer scale;
    private int position = 1;
    private boolean optional = true;
    private boolean autoIncremented = false;
    private boolean generated = false;
    private Object defaultValue = null;
    private boolean hasDefaultValue = false;

    protected ColumnEditorImpl() {
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String typeName() {
        return this.typeName;
    }

    @Override
    public String typeExpression() {
        return this.typeExpression;
    }

    @Override
    public int jdbcType() {
        return this.jdbcType;
    }

    @Override
    public int nativeType() {
        return this.nativeType;
    }

    @Override
    public String charsetName() {
        return this.charsetName;
    }

    @Override
    public String charsetNameOfTable() {
        return this.tableCharsetName;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Optional<Integer> scale() {
        return Optional.ofNullable(this.scale);
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isAutoIncremented() {
        return this.autoIncremented;
    }

    @Override
    public boolean isGenerated() {
        return this.generated;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    @Override
    public ColumnEditorImpl name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ColumnEditorImpl type(String typeName) {
        this.typeName = typeName;
        this.typeExpression = typeName;
        return this;
    }

    @Override
    public ColumnEditor type(String typeName, String typeExpression) {
        this.typeName = typeName;
        this.typeExpression = typeExpression != null ? typeExpression : typeName;
        return this;
    }

    @Override
    public ColumnEditorImpl jdbcType(int jdbcType) {
        this.jdbcType = jdbcType;
        return this;
    }

    @Override
    public ColumnEditorImpl nativeType(int nativeType) {
        this.nativeType = nativeType;
        return this;
    }

    @Override
    public ColumnEditor charsetName(String charsetName) {
        this.charsetName = charsetName;
        return this;
    }

    @Override
    public ColumnEditor charsetNameOfTable(String charsetName) {
        this.tableCharsetName = charsetName;
        return this;
    }

    @Override
    public ColumnEditorImpl length(int length) {
        assert (length >= -1);
        this.length = length;
        return this;
    }

    @Override
    public ColumnEditorImpl scale(Integer scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public ColumnEditorImpl optional(boolean optional) {
        this.optional = optional;
        if (optional && !this.hasDefaultValue()) {
            this.defaultValue(null);
        }
        return this;
    }

    @Override
    public ColumnEditorImpl autoIncremented(boolean autoIncremented) {
        this.autoIncremented = autoIncremented;
        return this;
    }

    @Override
    public ColumnEditorImpl generated(boolean generated) {
        this.generated = generated;
        return this;
    }

    @Override
    public ColumnEditorImpl position(int position) {
        this.position = position;
        return this;
    }

    @Override
    public ColumnEditor defaultValue(Object defaultValue) {
        this.hasDefaultValue = true;
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public ColumnEditor unsetDefaultValue() {
        this.hasDefaultValue = false;
        this.defaultValue = null;
        return this;
    }

    @Override
    public Column create() {
        return new ColumnImpl(this.name, this.position, this.jdbcType, this.nativeType, this.typeName, this.typeExpression, this.charsetName, this.tableCharsetName, this.length, this.scale, this.optional, this.autoIncremented, this.generated, this.defaultValue, this.hasDefaultValue);
    }

    public String toString() {
        return this.create().toString();
    }
}

