/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategies;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import com.codahale.metrics.httpclient.InstrumentedHttpClientConnectionManager;
import com.codahale.metrics.httpclient.InstrumentedHttpRequestExecutor;
import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.client.HttpClientConfiguration;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.io.IOException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

public class HttpClientBuilder {
    private static final HttpRequestRetryHandler NO_RETRIES = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    };
    private final MetricRegistry metricRegistry;
    private String environmentName;
    private HttpClientConfiguration configuration = new HttpClientConfiguration();
    private DnsResolver resolver = new SystemDefaultDnsResolver();
    private HttpRequestRetryHandler httpRequestRetryHandler;
    private Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
    private CredentialsProvider credentialsProvider = null;
    private HttpClientMetricNameStrategy metricNameStrategy = HttpClientMetricNameStrategies.METHOD_ONLY;
    private HttpRoutePlanner routePlanner = null;

    public HttpClientBuilder(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public HttpClientBuilder(Environment environment) {
        this(environment.metrics());
        this.name(environment.getName());
    }

    public HttpClientBuilder name(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public HttpClientBuilder using(HttpClientConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HttpClientBuilder using(DnsResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public HttpClientBuilder using(HttpRequestRetryHandler httpRequestRetryHandler) {
        this.httpRequestRetryHandler = httpRequestRetryHandler;
        return this;
    }

    public HttpClientBuilder using(Registry<ConnectionSocketFactory> registry) {
        this.registry = registry;
        return this;
    }

    public HttpClientBuilder using(HttpRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
        return this;
    }

    public HttpClientBuilder using(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public HttpClientBuilder using(HttpClientMetricNameStrategy metricNameStrategy) {
        this.metricNameStrategy = metricNameStrategy;
        return this;
    }

    public CloseableHttpClient build(String name) {
        InstrumentedHttpClientConnectionManager manager = this.createConnectionManager(this.registry, name);
        return this.createClient(org.apache.http.impl.client.HttpClientBuilder.create(), manager, name);
    }

    @VisibleForTesting
    protected CloseableHttpClient createClient(org.apache.http.impl.client.HttpClientBuilder builder, InstrumentedHttpClientConnectionManager manager, String name) {
        NoConnectionReuseStrategy reuseStrategy;
        String cookiePolicy = this.configuration.isCookiesEnabled() ? "best-match" : "ignoreCookies";
        Integer timeout = (int)this.configuration.getTimeout().toMilliseconds();
        Integer connectionTimeout = (int)this.configuration.getConnectionTimeout().toMilliseconds();
        Integer connectionRequestTimeout = (int)this.configuration.getConnectionRequestTimeout().toMilliseconds();
        final long keepAlive = this.configuration.getKeepAlive().toMilliseconds();
        Object object = reuseStrategy = keepAlive == 0L ? new NoConnectionReuseStrategy() : new DefaultConnectionReuseStrategy();
        HttpRequestRetryHandler retryHandler = this.configuration.getRetries() == 0 ? NO_RETRIES : (this.httpRequestRetryHandler == null ? new DefaultHttpRequestRetryHandler(this.configuration.getRetries(), false) : this.httpRequestRetryHandler);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec(cookiePolicy).setSocketTimeout(timeout.intValue()).setConnectTimeout(connectionTimeout.intValue()).setConnectionRequestTimeout(connectionRequestTimeout.intValue()).setStaleConnectionCheckEnabled(false).build();
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(timeout.intValue()).build();
        builder.setRequestExecutor((HttpRequestExecutor)new InstrumentedHttpRequestExecutor(this.metricRegistry, this.metricNameStrategy, name)).setConnectionManager((HttpClientConnectionManager)manager).setDefaultRequestConfig(requestConfig).setDefaultSocketConfig(socketConfig).setConnectionReuseStrategy((ConnectionReuseStrategy)reuseStrategy).setRetryHandler(retryHandler).setUserAgent(this.createUserAgent(name));
        if (keepAlive != 0L) {
            builder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = super.getKeepAliveDuration(response, context);
                    return duration == -1L ? keepAlive : duration;
                }
            });
        }
        if (this.credentialsProvider != null) {
            builder.setDefaultCredentialsProvider(this.credentialsProvider);
        }
        if (this.routePlanner != null) {
            builder.setRoutePlanner(this.routePlanner);
        }
        return builder.build();
    }

    protected String createUserAgent(String name) {
        String defaultUserAgent = this.environmentName == null ? name : String.format("%s (%s)", this.environmentName, name);
        return (String)this.configuration.getUserAgent().or((Object)defaultUserAgent);
    }

    protected InstrumentedHttpClientConnectionManager createConnectionManager(Registry<ConnectionSocketFactory> registry, String name) {
        Duration ttl = this.configuration.getTimeToLive();
        InstrumentedHttpClientConnectionManager manager = new InstrumentedHttpClientConnectionManager(this.metricRegistry, registry, null, null, this.resolver, ttl.getQuantity(), ttl.getUnit(), name);
        return this.configureConnectionManager(manager);
    }

    @VisibleForTesting
    protected InstrumentedHttpClientConnectionManager configureConnectionManager(InstrumentedHttpClientConnectionManager connectionManager) {
        connectionManager.setDefaultMaxPerRoute(this.configuration.getMaxConnectionsPerRoute());
        connectionManager.setMaxTotal(this.configuration.getMaxConnections());
        return connectionManager;
    }
}

