/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import io.dropwizard.util.Duration;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.ConcurrentArrayBlockingQueue;

public class AsyncAppender
extends AppenderBase<ILoggingEvent> {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private final BlockingQueue<ILoggingEvent> queue;
    private final Worker worker;
    private final Appender<ILoggingEvent> delegate;

    public AsyncAppender(Appender<ILoggingEvent> delegate, int batchSize, Duration batchDuration, boolean bounded) {
        this.queue = this.buildQueue(batchSize, bounded);
        this.worker = new Worker(batchSize, batchDuration);
        this.delegate = delegate;
        this.setName("async-" + delegate.getName());
    }

    private ConcurrentArrayBlockingQueue<ILoggingEvent> buildQueue(int batchSize, boolean bounded) {
        if (bounded) {
            return new ConcurrentArrayBlockingQueue.Bounded(batchSize * 2);
        }
        return new ConcurrentArrayBlockingQueue.Unbounded();
    }

    public void start() {
        super.start();
        this.worker.setName(this.getName() + "-" + THREAD_COUNTER.incrementAndGet());
        this.worker.start();
    }

    public void stop() {
        super.stop();
        this.worker.shutdown();
    }

    protected void append(ILoggingEvent event) {
        event.prepareForDeferredProcessing();
        try {
            this.queue.put(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class Worker
    extends Thread {
        private final int batchSize;
        private final Duration batchDuration;
        private volatile boolean running = true;
        private final List<ILoggingEvent> events;

        private Worker(int batchSize, Duration batchDuration) {
            this.batchSize = batchSize;
            this.batchDuration = batchDuration;
            this.events = Lists.newArrayListWithCapacity((int)batchSize);
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    Queues.drain((BlockingQueue)AsyncAppender.this.queue, this.events, (int)this.batchSize, (long)this.batchDuration.getQuantity(), (TimeUnit)this.batchDuration.getUnit());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                for (ILoggingEvent event : this.events) {
                    AsyncAppender.this.delegate.doAppend((Object)event);
                }
                this.events.clear();
            }
            for (ILoggingEvent event : AsyncAppender.this.queue) {
                AsyncAppender.this.delegate.doAppend((Object)event);
            }
            AsyncAppender.this.delegate.stop();
        }

        public void shutdown() {
            this.running = false;
            this.interrupt();
        }
    }
}

