/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.metrics.ReporterFactory;
import io.dropwizard.metrics.ScheduledReporterManager;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsFactory.class);
    @Valid
    @NotNull
    private Duration frequency = Duration.minutes((long)1L);
    @Valid
    @NotNull
    private ImmutableList<ReporterFactory> reporters = ImmutableList.of();

    @JsonProperty
    public ImmutableList<ReporterFactory> getReporters() {
        return this.reporters;
    }

    @JsonProperty
    public void setReporters(ImmutableList<ReporterFactory> reporters) {
        this.reporters = reporters;
    }

    @JsonProperty
    public Duration getFrequency() {
        return this.frequency;
    }

    @JsonProperty
    public void setFrequency(Duration frequency) {
        this.frequency = frequency;
    }

    public void configure(LifecycleEnvironment environment, MetricRegistry registry) {
        for (ReporterFactory reporter : this.reporters) {
            try {
                ScheduledReporterManager manager = new ScheduledReporterManager(reporter.build(registry), (Duration)reporter.getFrequency().or((Object)this.getFrequency()));
                environment.manage((Managed)manager);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create reporter, metrics may not be properly reported.", (Throwable)e);
            }
        }
    }
}

