/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.tasks;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import io.dropwizard.servlets.tasks.Task;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServlet
extends HttpServlet {
    private static final long serialVersionUID = 7404713218661358124L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServlet.class);
    private final ConcurrentMap<String, Task> tasks = Maps.newConcurrentMap();

    public void add(Task task) {
        this.tasks.put('/' + task.getName(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Task task = (Task)this.tasks.get(req.getPathInfo());
        if (task != null) {
            resp.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
            try (PrintWriter output = resp.getWriter();){
                task.execute(TaskServlet.getParams(req), output);
            }
        } else {
            resp.sendError(404);
        }
    }

    private static ImmutableMultimap<String, String> getParams(HttpServletRequest req) {
        ImmutableMultimap.Builder results = ImmutableMultimap.builder();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object[] values = req.getParameterValues(name);
            results.putAll((Object)name, values);
        }
        return results.build();
    }

    public Collection<Task> getTasks() {
        return this.tasks.values();
    }
}

