/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */


#ifndef SWIGJAVA
#define SWIGJAVA
#endif



#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


/* Includes the header in the wrapper code */
#include "../include/LightGBM/export.h"
#include "../include/LightGBM/utils/log.h"
#include "../include/LightGBM/utils/common.h"
#include "../include/LightGBM/c_api.h"


#include <stdint.h>		// Use the C99 official header


  char * LGBM_BoosterSaveModelToStringSWIG(BoosterHandle handle,
                                           int start_iteration,
                                           int num_iteration,
                                           int feature_importance_type,
                                           int64_t buffer_len,
                                           int64_t* out_len) {
    char* dst = new char[buffer_len];
    int result = LGBM_BoosterSaveModelToString(handle, start_iteration, num_iteration, feature_importance_type, buffer_len, out_len, dst);
    // Reallocate to use larger length
    if (*out_len > buffer_len) {
      delete [] dst;
      int64_t realloc_len = *out_len;
      dst = new char[realloc_len];
      result = LGBM_BoosterSaveModelToString(handle, start_iteration, num_iteration, feature_importance_type, realloc_len, out_len, dst);
    }
    if (result != 0) {
      return nullptr;
    }
    return dst;
  }

  char * LGBM_BoosterDumpModelSWIG(BoosterHandle handle,
                                   int start_iteration,
                                   int num_iteration,
                                   int feature_importance_type,
                                   int64_t buffer_len,
                                   int64_t* out_len) {
    char* dst = new char[buffer_len];
    int result = LGBM_BoosterDumpModel(handle, start_iteration, num_iteration, feature_importance_type, buffer_len, out_len, dst);
    // Reallocate to use larger length
    if (*out_len > buffer_len) {
      delete [] dst;
      int64_t realloc_len = *out_len;
      dst = new char[realloc_len];
      result = LGBM_BoosterDumpModel(handle, start_iteration, num_iteration, feature_importance_type, realloc_len, out_len, dst);
    }
    if (result != 0) {
      return nullptr;
    }
    return dst;
  }

  int LGBM_BoosterPredictForMatSingle(JNIEnv *jenv,
                                      jdoubleArray data,
                                      BoosterHandle handle,
                                      int data_type,
                                      int ncol,
                                      int is_row_major,
                                      int predict_type,
                                      int start_iteration,
                                      int num_iteration,
                                      const char* parameter,
                                      int64_t* out_len,
                                      double* out_result) {
    double* data0 = (double*)jenv->GetPrimitiveArrayCritical(data, 0);

    int ret = LGBM_BoosterPredictForMatSingleRow(handle, data0, data_type, ncol, is_row_major, predict_type, start_iteration,
                                                 num_iteration, parameter, out_len, out_result);

    jenv->ReleasePrimitiveArrayCritical(data, data0, JNI_ABORT);

    return ret;
  }

  /*! \brief Even faster variant of `LGBM_BoosterPredictForMatSingle`.
   *
   * Uses `LGBM_BoosterPredictForMatSingleRowFast` which is faster
   * than `LGBM_BoosterPredictForMatSingleRow` and the trick of
   * `LGBM_BoosterPredictForMatSingle` to capture the Java data array
   * using `GetPrimitiveArrayCritical`, which can yield faster access
   * to the array if the JVM passes the actual address to the C++ side
   * instead of performing a copy.
   */
  int LGBM_BoosterPredictForMatSingleRowFastCriticalSWIG(JNIEnv *jenv,
                                                         jdoubleArray data,
                                                         FastConfigHandle handle,
                                                         int64_t* out_len,
                                                         double* out_result) {
    double* data0 = (double*)jenv->GetPrimitiveArrayCritical(data, 0);

    int ret = LGBM_BoosterPredictForMatSingleRowFast(handle, data0, out_len, out_result);

    jenv->ReleasePrimitiveArrayCritical(data, data0, JNI_ABORT);

    return ret;
  }

  int LGBM_BoosterPredictForCSRSingle(JNIEnv *jenv,
                                      jintArray indices,
                                      jdoubleArray values,
                                      int numNonZeros,
                                      BoosterHandle handle,
                                      int indptr_type,
                                      int data_type,
                                      int64_t nelem,
                                      int64_t num_col,
                                      int predict_type,
                                      int start_iteration,
                                      int num_iteration,
                                      const char* parameter,
                                      int64_t* out_len,
                                      double* out_result) {
    // Alternatives
    // - GetIntArrayElements: performs copy
    // - GetDirectBufferAddress: fails on wrapped array
    // Some words of warning for GetPrimitiveArrayCritical
    // https://stackoverflow.com/questions/23258357/whats-the-trade-off-between-using-getprimitivearraycritical-and-getprimitivety

    jboolean isCopy;
    int* indices0 = (int*)jenv->GetPrimitiveArrayCritical(indices, &isCopy);
    double* values0 = (double*)jenv->GetPrimitiveArrayCritical(values, &isCopy);

    int32_t ind[2] = { 0, numNonZeros };

    int ret = LGBM_BoosterPredictForCSRSingleRow(handle, ind, indptr_type, indices0, values0, data_type, 2,
                                                 nelem, num_col, predict_type, start_iteration, num_iteration, parameter, out_len, out_result);

    jenv->ReleasePrimitiveArrayCritical(values, values0, JNI_ABORT);
    jenv->ReleasePrimitiveArrayCritical(indices, indices0, JNI_ABORT);

    return ret;
  }

  /*! \brief Even faster variant of `LGBM_BoosterPredictForCSRSingle`.
   *
   * Uses `LGBM_BoosterPredictForCSRSingleRowFast` which is faster
   * than `LGBM_BoosterPredictForMatSingleRow` and the trick of
   * `LGBM_BoosterPredictForCSRSingle` to capture the Java data array
   * using `GetPrimitiveArrayCritical`, which can yield faster access
   * to the array if the JVM passes the actual address to the C++ side
   * instead of performing a copy.
   */
  int LGBM_BoosterPredictForCSRSingleRowFastCriticalSWIG(JNIEnv *jenv,
                                                         jintArray indices,
                                                         jdoubleArray values,
                                                         int numNonZeros,
                                                         FastConfigHandle handle,
                                                         int indptr_type,
                                                         int64_t nelem,
                                                         int64_t* out_len,
                                                         double* out_result) {
    // Alternatives
    // - GetIntArrayElements: performs copy
    // - GetDirectBufferAddress: fails on wrapped array
    // Some words of warning for GetPrimitiveArrayCritical
    // https://stackoverflow.com/questions/23258357/whats-the-trade-off-between-using-getprimitivearraycritical-and-getprimitivety

    jboolean isCopy;
    int* indices0 = (int*)jenv->GetPrimitiveArrayCritical(indices, &isCopy);
    double* values0 = (double*)jenv->GetPrimitiveArrayCritical(values, &isCopy);

    int32_t ind[2] = { 0, numNonZeros };

    int ret = LGBM_BoosterPredictForCSRSingleRowFast(handle, ind, indptr_type, indices0, values0, 2,
                                                     nelem, out_len, out_result);

    jenv->ReleasePrimitiveArrayCritical(values, values0, JNI_ABORT);
    jenv->ReleasePrimitiveArrayCritical(indices, indices0, JNI_ABORT);

    return ret;
  }

  #include <functional>
  #include <vector>

  struct CSRDirect {
          jintArray indices;
          jdoubleArray values;
          int* indices0;
          double* values0;
          int size;
  };

  int LGBM_DatasetCreateFromCSRSpark(JNIEnv *jenv,
                                     jobjectArray arrayOfSparseVector,
                                     int num_rows,
                                     int64_t num_col,
                                     const char* parameters,
                                     const DatasetHandle reference,
                                     DatasetHandle* out) {
    jclass sparseVectorClass = jenv->FindClass("org/apache/spark/ml/linalg/SparseVector");
    jmethodID sparseVectorIndices = jenv->GetMethodID(sparseVectorClass, "indices", "()[I");
    jmethodID sparseVectorValues = jenv->GetMethodID(sparseVectorClass, "values", "()[D");

    std::vector<CSRDirect> jniCache;
    jniCache.reserve(num_rows);

    // this needs to be done ahead of time as row_func is invoked from multiple threads
    // these threads would have to be registered with the JVM and also unregistered.
    // It is not clear if that can be achieved with OpenMP
    for (int i = 0; i < num_rows; i++) {
      // get the row
      jobject objSparseVec = jenv->GetObjectArrayElement(arrayOfSparseVector, i);

      // get the size, indices and values
      auto indices = (jintArray)jenv->CallObjectMethod(objSparseVec, sparseVectorIndices);
      if (jenv->ExceptionCheck()) {
        return -1;
      }
      auto values = (jdoubleArray)jenv->CallObjectMethod(objSparseVec, sparseVectorValues);
      if (jenv->ExceptionCheck()) {
        return -1;
      }
      int size = jenv->GetArrayLength(indices);

      // Note: when testing on larger data (e.g. 288k rows per partition and 36mio rows total)
      // using GetPrimitiveArrayCritical resulted in a dead-lock
      // lock arrays
      // int* indices0 = (int*)jenv->GetPrimitiveArrayCritical(indices, 0);
      // double* values0 = (double*)jenv->GetPrimitiveArrayCritical(values, 0);
      // in test-usecase an alternative to GetPrimitiveArrayCritical as it performs copies
      int* indices0 = (int *)jenv->GetIntArrayElements(indices, 0);
      double* values0 = jenv->GetDoubleArrayElements(values, 0);

      jniCache.push_back({indices, values, indices0, values0, size});
    }

    // type is important here as we want a std::function, rather than a lambda
    std::function<void(int idx, std::vector<std::pair<int, double>>& ret)> row_func = [&](int row_num, std::vector<std::pair<int, double>>& ret) {
      auto& jc = jniCache[row_num];
      ret.clear();  // reset size, but not free()
      ret.reserve(jc.size);  // make sure we have enough allocated

      // copy data
      int* indices0p = jc.indices0;
      double* values0p = jc.values0;
      int* indices0e = indices0p + jc.size;

      for (; indices0p != indices0e; ++indices0p, ++values0p)
        ret.emplace_back(*indices0p, *values0p);
    };

    int ret = LGBM_DatasetCreateFromCSRFunc(&row_func, num_rows, num_col, parameters, reference, out);

    for (auto& jc : jniCache) {
      // jenv->ReleasePrimitiveArrayCritical(jc.values, jc.values0, JNI_ABORT);
      // jenv->ReleasePrimitiveArrayCritical(jc.indices, jc.indices0, JNI_ABORT);
      jenv->ReleaseDoubleArrayElements(jc.values, jc.values0, JNI_ABORT);
      jenv->ReleaseIntArrayElements(jc.indices, (jint *)jc.indices0, JNI_ABORT);
    }

    return ret;
  }


static int *new_intp() { 
  return new int(); 
}

static int *copy_intp(int value) { 
  return new int(value); 
}

static void delete_intp(int *obj) { 
  if (obj) delete obj; 
}

static void intp_assign(int *obj, int value) {
  *obj = value;
}

static int intp_value(int *obj) {
  return *obj;
}


static long *new_longp() { 
  return new long(); 
}

static long *copy_longp(long value) { 
  return new long(value); 
}

static void delete_longp(long *obj) { 
  if (obj) delete obj; 
}

static void longp_assign(long *obj, long value) {
  *obj = value;
}

static long longp_value(long *obj) {
  return *obj;
}


static double *new_doublep() { 
  return new double(); 
}

static double *copy_doublep(double value) { 
  return new double(value); 
}

static void delete_doublep(double *obj) { 
  if (obj) delete obj; 
}

static void doublep_assign(double *obj, double value) {
  *obj = value;
}

static double doublep_value(double *obj) {
  return *obj;
}


static float *new_floatp() { 
  return new float(); 
}

static float *copy_floatp(float value) { 
  return new float(value); 
}

static void delete_floatp(float *obj) { 
  if (obj) delete obj; 
}

static void floatp_assign(float *obj, float value) {
  *obj = value;
}

static float floatp_value(float *obj) {
  return *obj;
}


static int64_t *new_int64_tp() { 
  return new int64_t(); 
}

static int64_t *copy_int64_tp(int64_t value) { 
  return new int64_t(value); 
}

static void delete_int64_tp(int64_t *obj) { 
  if (obj) delete obj; 
}

static void int64_tp_assign(int64_t *obj, int64_t value) {
  *obj = value;
}

static int64_t int64_tp_value(int64_t *obj) {
  return *obj;
}


static int32_t *new_int32_tp() { 
  return new int32_t(); 
}

static int32_t *copy_int32_tp(int32_t value) { 
  return new int32_t(value); 
}

static void delete_int32_tp(int32_t *obj) { 
  if (obj) delete obj; 
}

static void int32_tp_assign(int32_t *obj, int32_t value) {
  *obj = value;
}

static int32_t int32_tp_value(int32_t *obj) {
  return *obj;
}


static size_t *new_size_tp() { 
  return new size_t(); 
}

static size_t *copy_size_tp(size_t value) { 
  return new size_t(value); 
}

static void delete_size_tp(size_t *obj) { 
  if (obj) delete obj; 
}

static void size_tp_assign(size_t *obj, size_t value) {
  *obj = value;
}

static size_t size_tp_value(size_t *obj) {
  return *obj;
}


long * int64_t_to_long_ptr(int64_t * x) {
   return (long *) x;
}


double * int64_t_to_double_ptr(int64_t * x) {
   return (double *) x;
}


int * int32_t_to_int_ptr(int32_t * x) {
   return (int *) x;
}


int64_t * long_to_int64_t_ptr(long * x) {
   return (int64_t *) x;
}


int64_t * double_to_int64_t_ptr(double * x) {
   return (int64_t *) x;
}


int32_t * int_to_int32_t_ptr(int * x) {
   return (int32_t *) x;
}


void * double_to_voidp_ptr(double * x) {
   return (void *) x;
}


void * float_to_voidp_ptr(float * x) {
   return (void *) x;
}


void * int_to_voidp_ptr(int * x) {
   return (void *) x;
}


void * int32_t_to_voidp_ptr(int32_t * x) {
   return (void *) x;
}


void * int64_t_to_voidp_ptr(int64_t * x) {
   return (void *) x;
}


  static double *new_doubleArray(int64_t nelements) { 
  return new double[nelements](); 
}

  static void delete_doubleArray(double *ary) { 
  delete [] ary; 
}

  static double doubleArray_getitem(double *ary, int64_t index) {
    return ary[index];
  }
  static void doubleArray_setitem(double *ary, int64_t index, double value) {
    ary[index] = value;
  }
  

  static float *new_floatArray(int64_t nelements) { 
  return new float[nelements](); 
}

  static void delete_floatArray(float *ary) { 
  delete [] ary; 
}

  static float floatArray_getitem(float *ary, int64_t index) {
    return ary[index];
  }
  static void floatArray_setitem(float *ary, int64_t index, float value) {
    ary[index] = value;
  }
  

  static int *new_intArray(int64_t nelements) { 
  return new int[nelements](); 
}

  static void delete_intArray(int *ary) { 
  delete [] ary; 
}

  static int intArray_getitem(int *ary, int64_t index) {
    return ary[index];
  }
  static void intArray_setitem(int *ary, int64_t index, int value) {
    ary[index] = value;
  }
  

  static long *new_longArray(int64_t nelements) { 
  return new long[nelements](); 
}

  static void delete_longArray(long *ary) { 
  delete [] ary; 
}

  static long longArray_getitem(long *ary, int64_t index) {
    return ary[index];
  }
  static void longArray_setitem(long *ary, int64_t index, long value) {
    ary[index] = value;
  }
  

  static void* *new_voidpp() { 
  void** voidpp = new void*; return voidpp; 
}

  static void delete_voidpp(void* *self) { 
  if (self) delete self; 
}
  

  static void* voidpp_value(void* *self) {
    void* voidpp = *self;
    return voidpp;
  }


  static void** voidpp_handle() { 
 void** voidpp = new void*; *voidpp = (void*)operator new(sizeof(int*)); return voidpp; 
}


#include "../swig/StringArray.hpp"



    typedef void* StringArrayHandle;

    /**
     * @brief Creates a new StringArray and returns its handle.
     * 
     * @param num_strings number of strings to store.
     * @param string_size the maximum number of characters that can be stored in each string.
     * @return StringArrayHandle or nullptr in case of allocation failure.
     */
    StringArrayHandle StringArrayHandle_create(size_t num_strings, size_t string_size) {
        try {
            return new StringArray(num_strings, string_size);
        } catch (std::bad_alloc &/*e*/) {
            return nullptr;
        }
    }

    /**
     * @brief Free the StringArray object.
     * 
     * @param handle StringArray handle.
     */
    void StringArrayHandle_free(StringArrayHandle handle)
    {
        delete reinterpret_cast<StringArray *>(handle);
    }

    /**
     * @brief Return the raw pointer to the array of strings.
     * Wrapped in Java into String[] automatically.
     * 
     * @param handle StringArray handle.
     * @return Raw pointer to the string array which `various.i` maps to String[].
     */
    char **StringArrayHandle_get_strings(StringArrayHandle handle)
    {
        return reinterpret_cast<StringArray *>(handle)->data();
    }

    /**
     * For the end user to extract a specific string from the StringArray object.
     * 
     * @param handle StringArray handle.
     * @param index index of the string to retrieve from the array.
     * @return raw pointer to string at index, or nullptr if out of bounds.
     */
    char *StringArrayHandle_get_string(StringArrayHandle handle, int index)
    {
        return reinterpret_cast<StringArray *>(handle)->getitem(index);
    }

    /**
     * @brief Replaces one string of the array at index with the new content.
     * 
     * @param handle StringArray handle.
     * @param index Index of the string to replace
     * @param new_content The content to replace
     * @return 0 (success) or -1 (error) in case of out of bounds index or too large content.
     */
    int StringArrayHandle_set_string(StringArrayHandle handle, size_t index, const char* new_content)
    {
        return reinterpret_cast<StringArray *>(handle)->setitem(index, std::string(new_content));
    }

    /**
     * @brief Retrieve the number of strings in the StringArray.
     * 
     * @param handle StringArray handle.
     * @return number of strings that the array stores.
     */
    size_t StringArrayHandle_get_num_elements(StringArrayHandle handle)
    {
        return reinterpret_cast<StringArray *>(handle)->get_num_elements();
    }




    #define API_OK_OR_VALUE(api_return, return_value) if (api_return == -1) return return_value
    #define API_OK_OR_NULL(api_return) API_OK_OR_VALUE(api_return, nullptr)

    /**
     * @brief Wraps LGBM_BoosterGetEvalNames.
     *
     * In case of success a new StringArray is created and returned,
     * which you're responsible for freeing,
     * @see StringArrayHandle_free().
     * In case of failure such resource is freed and nullptr is returned.
     * Check for that case with null (lightgbmlib) or 0 (lightgbmlibJNI).
     *
     * @param handle Booster handle
     * @return StringArrayHandle with the eval names (or nullptr in case of error)
     */
    StringArrayHandle LGBM_BoosterGetEvalNamesSWIG(BoosterHandle handle)
    {
        int eval_counts;
        size_t string_size;
        std::unique_ptr<StringArray> strings(nullptr);

        // Retrieve required allocation space:
        API_OK_OR_NULL(LGBM_BoosterGetEvalNames(handle,
                                                0, &eval_counts,
                                                0, &string_size,
                                                nullptr));

        try {
            strings.reset(new StringArray(eval_counts, string_size));
        } catch (std::bad_alloc &/*e*/) {
            LGBM_SetLastError("Failure to allocate memory.");
            return nullptr;
        }

        API_OK_OR_NULL(LGBM_BoosterGetEvalNames(handle,
                                                eval_counts, &eval_counts,
                                                string_size, &string_size,
                                                strings->data()));

        return strings.release();
    }

    /**
     * @brief Wraps LGBM_BoosterGetFeatureNames.
     *
     * Allocates a new StringArray. You must free it yourself if it succeeds.
     * @see StringArrayHandle_free().
     * In case of failure such resource is freed and nullptr is returned.
     * Check for that case with null (lightgbmlib) or 0 (lightgbmlibJNI).
     *
     * @param handle Booster handle
     * @return StringArrayHandle with the feature names (or nullptr in case of error)
     */
    StringArrayHandle LGBM_BoosterGetFeatureNamesSWIG(BoosterHandle handle)
    {
        int num_features;
        size_t max_feature_name_size;
        std::unique_ptr<StringArray> strings(nullptr);

        // Retrieve required allocation space:
        API_OK_OR_NULL(LGBM_BoosterGetFeatureNames(handle,
                                                   0, &num_features,
                                                   0, &max_feature_name_size,
                                                   nullptr));

        try {
            strings.reset(new StringArray(num_features, max_feature_name_size));
        } catch (std::bad_alloc &/*e*/) {
            LGBM_SetLastError("Failure to allocate memory.");
            return nullptr;
        }

        API_OK_OR_NULL(LGBM_BoosterGetFeatureNames(handle,
                                                   num_features, &num_features,
                                                   max_feature_name_size, &max_feature_name_size,
                                                   strings->data()));

        return strings.release();
    }


    /**
     * @brief Wraps LGBM_DatasetGetFeatureNames. Has the same limitations as a
     * LGBM_BoosterGetFeatureNames:
     *
     * Allocates a new StringArray. You must free it yourself if it succeeds.
     * @see StringArrayHandle_free().
     * In case of failure such resource is freed and nullptr is returned.
     * Check for that case with null (lightgbmlib) or 0 (lightgbmlibJNI).
     *
     * @param handle Booster handle
     * @return StringArrayHandle with the feature names (or nullptr in case of error)
     */
    StringArrayHandle LGBM_DatasetGetFeatureNamesSWIG(BoosterHandle handle)
    {
        int num_features;
        size_t max_feature_name_size;
        std::unique_ptr<StringArray> strings(nullptr);

        // Retrieve required allocation space:
        API_OK_OR_NULL(LGBM_DatasetGetFeatureNames(handle,
                                                   0, &num_features,
                                                   0, &max_feature_name_size,
                                                   nullptr));
        try {
            strings.reset(new StringArray(num_features, max_feature_name_size));
        } catch (std::bad_alloc &/*e*/) {
            LGBM_SetLastError("Failure to allocate memory.");
            return nullptr;
        }

        API_OK_OR_NULL(LGBM_DatasetGetFeatureNames(handle,
                                                   num_features, &num_features,
                                                   max_feature_name_size, &max_feature_name_size,
                                                   strings->data()));

        return strings.release();
    }



#include "../include/LightGBM/utils/chunked_array.hpp"


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1DTYPE_1FLOAT32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1DTYPE_1FLOAT64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((1));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1DTYPE_1INT32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1DTYPE_1INT64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((3));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1PREDICT_1NORMAL_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1PREDICT_1RAW_1SCORE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((1));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1PREDICT_1LEAF_1INDEX_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((2));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1PREDICT_1CONTRIB_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((3));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1MATRIX_1TYPE_1CSR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1MATRIX_1TYPE_1CSC_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((1));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1FEATURE_1IMPORTANCE_1SPLIT_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((0));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_C_1API_1FEATURE_1IMPORTANCE_1GAIN_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)((1));
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1GetLastError(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)LGBM_GetLastError();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1RegisterLogCallback(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  void (*arg1)(char const *) = (void (*)(char const *)) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void (**)(char const *))&jarg1; 
  result = (int)LGBM_RegisterLogCallback(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1GetSampleCount(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  int32_t arg1 ;
  char *arg2 = (char *) 0 ;
  int *arg3 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(int **)&jarg3; 
  result = (int)LGBM_GetSampleCount(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1SampleIndices(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  int32_t arg1 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = (void *) 0 ;
  int32_t *arg4 = (int32_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(void **)&jarg3; 
  arg4 = *(int32_t **)&jarg4; 
  result = (int)LGBM_SampleIndices(arg1,(char const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateFromFile(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  DatasetHandle arg3 = (DatasetHandle) (DatasetHandle)0 ;
  DatasetHandle *arg4 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(DatasetHandle *)&jarg3; 
  arg4 = *(DatasetHandle **)&jarg4; 
  result = (int)LGBM_DatasetCreateFromFile((char const *)arg1,(char const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateFromSampledColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4, jint jarg5, jint jarg6, jstring jarg7, jlong jarg8) {
  jint jresult = 0 ;
  double **arg1 = (double **) 0 ;
  int **arg2 = (int **) 0 ;
  int32_t arg3 ;
  int *arg4 = (int *) 0 ;
  int32_t arg5 ;
  int32_t arg6 ;
  char *arg7 = (char *) 0 ;
  DatasetHandle *arg8 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double ***)&jarg1; 
  arg2 = *(int ***)&jarg2; 
  arg3 = (int32_t)jarg3; 
  arg4 = *(int **)&jarg4; 
  arg5 = (int32_t)jarg5; 
  arg6 = (int32_t)jarg6; 
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = *(DatasetHandle **)&jarg8; 
  result = (int)LGBM_DatasetCreateFromSampledColumn(arg1,arg2,arg3,(int const *)arg4,arg5,arg6,(char const *)arg7,arg8);
  jresult = (jint)result; 
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateByReference(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) (DatasetHandle)0 ;
  int64_t arg2 ;
  DatasetHandle *arg3 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = *(DatasetHandle **)&jarg3; 
  result = (int)LGBM_DatasetCreateByReference(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetPushRows(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int32_t arg4 ;
  int32_t arg5 ;
  int32_t arg6 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int32_t)jarg4; 
  arg5 = (int32_t)jarg5; 
  arg6 = (int32_t)jarg6; 
  result = (int)LGBM_DatasetPushRows(arg1,(void const *)arg2,arg3,arg4,arg5,arg6);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetPushRowsByCSR(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4, jlong jarg5, jint jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jlong jarg10) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int32_t *arg4 = (int32_t *) 0 ;
  void *arg5 = (void *) 0 ;
  int arg6 ;
  int64_t arg7 ;
  int64_t arg8 ;
  int64_t arg9 ;
  int64_t arg10 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(int32_t **)&jarg4; 
  arg5 = *(void **)&jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (int64_t)jarg8; 
  arg9 = (int64_t)jarg9; 
  arg10 = (int64_t)jarg10; 
  result = (int)LGBM_DatasetPushRowsByCSR(arg1,(void const *)arg2,arg3,(int const *)arg4,(void const *)arg5,arg6,arg7,arg8,arg9,arg10);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateFromCSR(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jint jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jstring jarg9, jlong jarg10, jlong jarg11) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int arg2 ;
  int32_t *arg3 = (int32_t *) 0 ;
  void *arg4 = (void *) 0 ;
  int arg5 ;
  int64_t arg6 ;
  int64_t arg7 ;
  int64_t arg8 ;
  char *arg9 = (char *) 0 ;
  DatasetHandle arg10 = (DatasetHandle) (DatasetHandle)0 ;
  DatasetHandle *arg11 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(int32_t **)&jarg3; 
  arg4 = *(void **)&jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int64_t)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (int64_t)jarg8; 
  arg9 = 0;
  if (jarg9) {
    arg9 = (char *)jenv->GetStringUTFChars(jarg9, 0);
    if (!arg9) return 0;
  }
  arg10 = *(DatasetHandle *)&jarg10; 
  arg11 = *(DatasetHandle **)&jarg11; 
  result = (int)LGBM_DatasetCreateFromCSR((void const *)arg1,arg2,(int const *)arg3,(void const *)arg4,arg5,arg6,arg7,arg8,(char const *)arg9,arg10,arg11);
  jresult = (jint)result; 
  if (arg9) jenv->ReleaseStringUTFChars(jarg9, (const char *)arg9);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateFromCSRFunc(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jstring jarg4, jlong jarg5, jlong jarg6) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int arg2 ;
  int64_t arg3 ;
  char *arg4 = (char *) 0 ;
  DatasetHandle arg5 = (DatasetHandle) (DatasetHandle)0 ;
  DatasetHandle *arg6 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int64_t)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(DatasetHandle *)&jarg5; 
  arg6 = *(DatasetHandle **)&jarg6; 
  result = (int)LGBM_DatasetCreateFromCSRFunc(arg1,arg2,arg3,(char const *)arg4,arg5,arg6);
  jresult = (jint)result; 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateFromCSC(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jint jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jstring jarg9, jlong jarg10, jlong jarg11) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int arg2 ;
  int32_t *arg3 = (int32_t *) 0 ;
  void *arg4 = (void *) 0 ;
  int arg5 ;
  int64_t arg6 ;
  int64_t arg7 ;
  int64_t arg8 ;
  char *arg9 = (char *) 0 ;
  DatasetHandle arg10 = (DatasetHandle) (DatasetHandle)0 ;
  DatasetHandle *arg11 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(int32_t **)&jarg3; 
  arg4 = *(void **)&jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int64_t)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (int64_t)jarg8; 
  arg9 = 0;
  if (jarg9) {
    arg9 = (char *)jenv->GetStringUTFChars(jarg9, 0);
    if (!arg9) return 0;
  }
  arg10 = *(DatasetHandle *)&jarg10; 
  arg11 = *(DatasetHandle **)&jarg11; 
  result = (int)LGBM_DatasetCreateFromCSC((void const *)arg1,arg2,(int const *)arg3,(void const *)arg4,arg5,arg6,arg7,arg8,(char const *)arg9,arg10,arg11);
  jresult = (jint)result; 
  if (arg9) jenv->ReleaseStringUTFChars(jarg9, (const char *)arg9);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateFromMat(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jstring jarg6, jlong jarg7, jlong jarg8) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int arg2 ;
  int32_t arg3 ;
  int32_t arg4 ;
  int arg5 ;
  char *arg6 = (char *) 0 ;
  DatasetHandle arg7 = (DatasetHandle) (DatasetHandle)0 ;
  DatasetHandle *arg8 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int32_t)jarg3; 
  arg4 = (int32_t)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)jenv->GetStringUTFChars(jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = *(DatasetHandle *)&jarg7; 
  arg8 = *(DatasetHandle **)&jarg8; 
  result = (int)LGBM_DatasetCreateFromMat((void const *)arg1,arg2,arg3,arg4,arg5,(char const *)arg6,arg7,arg8);
  jresult = (jint)result; 
  if (arg6) jenv->ReleaseStringUTFChars(jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateFromMats(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jint jarg3, jlong jarg4, jint jarg5, jint jarg6, jstring jarg7, jlong jarg8, jlong jarg9) {
  jint jresult = 0 ;
  int32_t arg1 ;
  void **arg2 = (void **) 0 ;
  int arg3 ;
  int32_t *arg4 = (int32_t *) 0 ;
  int32_t arg5 ;
  int arg6 ;
  char *arg7 = (char *) 0 ;
  DatasetHandle arg8 = (DatasetHandle) (DatasetHandle)0 ;
  DatasetHandle *arg9 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  arg2 = *(void ***)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(int32_t **)&jarg4; 
  arg5 = (int32_t)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = *(DatasetHandle *)&jarg8; 
  arg9 = *(DatasetHandle **)&jarg9; 
  result = (int)LGBM_DatasetCreateFromMats(arg1,(void const **)arg2,arg3,arg4,arg5,arg6,(char const *)arg7,arg8,arg9);
  jresult = (jint)result; 
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetGetSubset(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jstring jarg4, jlong jarg5) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) (DatasetHandle)0 ;
  int32_t *arg2 = (int32_t *) 0 ;
  int32_t arg3 ;
  char *arg4 = (char *) 0 ;
  DatasetHandle *arg5 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = *(int32_t **)&jarg2; 
  arg3 = (int32_t)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = *(DatasetHandle **)&jarg5; 
  result = (int)LGBM_DatasetGetSubset(arg1,(int const *)arg2,arg3,(char const *)arg4,arg5);
  jresult = (jint)result; 
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetSetFeatureNames(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2, jint jarg3) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  char **arg2 = (char **) 0 ;
  int arg3 ;
  jint size2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  {
    int i = 0;
    if (jarg2) {
      size2 = jenv->GetArrayLength(jarg2);
      
      arg2 = new char*[size2+1];
      
      
      
      for (i = 0; i<size2; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg2, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg2[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg2[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg2[i] = 0;
    } else {
      arg2 = 0;
      size2 = 0;
    }
  }
  arg3 = (int)jarg3; 
  result = (int)LGBM_DatasetSetFeatureNames(arg1,(char const **)arg2,arg3);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size2; i++)
    
    delete[] arg2[i];
    delete[] arg2;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetGetFeatureNames(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4, jlong jarg5, jobjectArray jarg6) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  size_t arg4 ;
  size_t *arg5 = (size_t *) 0 ;
  char **arg6 = (char **) 0 ;
  jint size6 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(int **)&jarg3; 
  arg4 = (size_t)jarg4; 
  arg5 = *(size_t **)&jarg5; 
  {
    int i = 0;
    if (jarg6) {
      size6 = jenv->GetArrayLength(jarg6);
      
      arg6 = new char*[size6+1];
      
      
      
      for (i = 0; i<size6; i++) {
        jstring j_string = (jstring)jenv->GetObjectArrayElement(jarg6, i);
        const char *c_string = jenv->GetStringUTFChars(j_string, 0);
        
        arg6[i] = new char [strlen(c_string)+1];
        
        
        
        strcpy(arg6[i], c_string);
        jenv->ReleaseStringUTFChars(j_string, c_string);
        jenv->DeleteLocalRef(j_string);
      }
      arg6[i] = 0;
    } else {
      arg6 = 0;
      size6 = 0;
    }
  }
  result = (int)LGBM_DatasetGetFeatureNames(arg1,arg2,arg3,arg4,arg5,arg6);
  jresult = (jint)result; 
  {
    int i;
    for (i=0; i<size6; i++)
    
    delete[] arg6[i];
    delete[] arg6;
    
    
    
    
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetFree(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  result = (int)LGBM_DatasetFree(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetSaveBinary(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)LGBM_DatasetSaveBinary(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetDumpText(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)LGBM_DatasetDumpText(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetSetField(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  char *arg2 = (char *) 0 ;
  void *arg3 = (void *) 0 ;
  int arg4 ;
  int arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(void **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (int)LGBM_DatasetSetField(arg1,(char const *)arg2,(void const *)arg3,arg4,arg5);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetGetField(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  char *arg2 = (char *) 0 ;
  int *arg3 = (int *) 0 ;
  void **arg4 = (void **) 0 ;
  int *arg5 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(int **)&jarg3; 
  arg4 = *(void ***)&jarg4; 
  arg5 = *(int **)&jarg5; 
  result = (int)LGBM_DatasetGetField(arg1,(char const *)arg2,arg3,(void const **)arg4,arg5);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetUpdateParamChecking(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)LGBM_DatasetUpdateParamChecking((char const *)arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetGetNumData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_DatasetGetNumData(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetGetNumFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_DatasetGetNumFeature(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetAddFeaturesFrom(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) 0 ;
  DatasetHandle arg2 = (DatasetHandle) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = *(DatasetHandle *)&jarg2; 
  result = (int)LGBM_DatasetAddFeaturesFrom(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetLinear(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  bool *arg2 = (bool *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(bool **)&jarg2; 
  result = (int)LGBM_BoosterGetLinear(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterCreate(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3) {
  jint jresult = 0 ;
  DatasetHandle arg1 = (DatasetHandle) (DatasetHandle)0 ;
  char *arg2 = (char *) 0 ;
  BoosterHandle *arg3 = (BoosterHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(DatasetHandle *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(BoosterHandle **)&jarg3; 
  result = (int)LGBM_BoosterCreate(arg1,(char const *)arg2,arg3);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterCreateFromModelfile(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int *arg2 = (int *) 0 ;
  BoosterHandle *arg3 = (BoosterHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(int **)&jarg2; 
  arg3 = *(BoosterHandle **)&jarg3; 
  result = (int)LGBM_BoosterCreateFromModelfile((char const *)arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterLoadModelFromString(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jlong jarg3) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int *arg2 = (int *) 0 ;
  BoosterHandle *arg3 = (BoosterHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = *(int **)&jarg2; 
  arg3 = *(BoosterHandle **)&jarg3; 
  result = (int)LGBM_BoosterLoadModelFromString((char const *)arg1,arg2,arg3);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterFree(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  result = (int)LGBM_BoosterFree(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterShuffleModels(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  result = (int)LGBM_BoosterShuffleModels(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterMerge(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  BoosterHandle arg2 = (BoosterHandle) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(BoosterHandle *)&jarg2; 
  result = (int)LGBM_BoosterMerge(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterAddValidData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  DatasetHandle arg2 = (DatasetHandle) (DatasetHandle)0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(DatasetHandle *)&jarg2; 
  result = (int)LGBM_BoosterAddValidData(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterResetTrainingData(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  DatasetHandle arg2 = (DatasetHandle) (DatasetHandle)0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(DatasetHandle *)&jarg2; 
  result = (int)LGBM_BoosterResetTrainingData(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterResetParameter(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (int)LGBM_BoosterResetParameter(arg1,(char const *)arg2);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetNumClasses(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_BoosterGetNumClasses(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterUpdateOneIter(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_BoosterUpdateOneIter(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterRefit(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int32_t *arg2 = (int32_t *) 0 ;
  int32_t arg3 ;
  int32_t arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(int32_t **)&jarg2; 
  arg3 = (int32_t)jarg3; 
  arg4 = (int32_t)jarg4; 
  result = (int)LGBM_BoosterRefit(arg1,(int const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterUpdateOneIterCustom(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  float *arg2 = (float *) 0 ;
  float *arg3 = (float *) 0 ;
  int *arg4 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(float **)&jarg2; 
  arg3 = *(float **)&jarg3; 
  arg4 = *(int **)&jarg4; 
  result = (int)LGBM_BoosterUpdateOneIterCustom(arg1,(float const *)arg2,(float const *)arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterRollbackOneIter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  result = (int)LGBM_BoosterRollbackOneIter(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetCurrentIteration(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_BoosterGetCurrentIteration(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterNumModelPerIteration(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_BoosterNumModelPerIteration(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterNumberOfTotalModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_BoosterNumberOfTotalModel(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetEvalCounts(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_BoosterGetEvalCounts(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetNumFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int *arg2 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(int **)&jarg2; 
  result = (int)LGBM_BoosterGetNumFeature(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetEval(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  double *arg4 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(int **)&jarg3; 
  arg4 = *(double **)&jarg4; 
  result = (int)LGBM_BoosterGetEval(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetNumPredict(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int64_t *arg3 = (int64_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(int64_t **)&jarg3; 
  result = (int)LGBM_BoosterGetNumPredict(arg1,arg2,arg3);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetPredict(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int64_t *arg3 = (int64_t *) 0 ;
  double *arg4 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(int64_t **)&jarg3; 
  arg4 = *(double **)&jarg4; 
  result = (int)LGBM_BoosterGetPredict(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jstring jarg7, jstring jarg8) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  char *arg7 = (char *) 0 ;
  char *arg8 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = 0;
  if (jarg8) {
    arg8 = (char *)jenv->GetStringUTFChars(jarg8, 0);
    if (!arg8) return 0;
  }
  result = (int)LGBM_BoosterPredictForFile(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,(char const *)arg7,(char const *)arg8);
  jresult = (jint)result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  if (arg8) jenv->ReleaseStringUTFChars(jarg8, (const char *)arg8);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterCalcNumPredict(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jlong jarg6) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int64_t *arg6 = (int64_t *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = *(int64_t **)&jarg6; 
  result = (int)LGBM_BoosterCalcNumPredict(arg1,arg2,arg3,arg4,arg5,arg6);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1FastConfigFree(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  FastConfigHandle arg1 = (FastConfigHandle) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FastConfigHandle *)&jarg1; 
  result = (int)LGBM_FastConfigFree(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForCSR(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4, jlong jarg5, jint jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10, jint jarg11, jint jarg12, jstring jarg13, jlong jarg14, jlong jarg15) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int32_t *arg4 = (int32_t *) 0 ;
  void *arg5 = (void *) 0 ;
  int arg6 ;
  int64_t arg7 ;
  int64_t arg8 ;
  int64_t arg9 ;
  int arg10 ;
  int arg11 ;
  int arg12 ;
  char *arg13 = (char *) 0 ;
  int64_t *arg14 = (int64_t *) 0 ;
  double *arg15 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(int32_t **)&jarg4; 
  arg5 = *(void **)&jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (int64_t)jarg8; 
  arg9 = (int64_t)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  arg12 = (int)jarg12; 
  arg13 = 0;
  if (jarg13) {
    arg13 = (char *)jenv->GetStringUTFChars(jarg13, 0);
    if (!arg13) return 0;
  }
  arg14 = *(int64_t **)&jarg14; 
  arg15 = *(double **)&jarg15; 
  result = (int)LGBM_BoosterPredictForCSR(arg1,(void const *)arg2,arg3,(int const *)arg4,(void const *)arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,(char const *)arg13,arg14,arg15);
  jresult = (jint)result; 
  if (arg13) jenv->ReleaseStringUTFChars(jarg13, (const char *)arg13);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictSparseOutput(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4, jlong jarg5, jint jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10, jint jarg11, jint jarg12, jstring jarg13, jint jarg14, jlong jarg15, jlong jarg16, jlong jarg17, jlong jarg18) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int32_t *arg4 = (int32_t *) 0 ;
  void *arg5 = (void *) 0 ;
  int arg6 ;
  int64_t arg7 ;
  int64_t arg8 ;
  int64_t arg9 ;
  int arg10 ;
  int arg11 ;
  int arg12 ;
  char *arg13 = (char *) 0 ;
  int arg14 ;
  int64_t *arg15 = (int64_t *) 0 ;
  void **arg16 = (void **) 0 ;
  int32_t **arg17 = (int32_t **) 0 ;
  void **arg18 = (void **) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(int32_t **)&jarg4; 
  arg5 = *(void **)&jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (int64_t)jarg8; 
  arg9 = (int64_t)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  arg12 = (int)jarg12; 
  arg13 = 0;
  if (jarg13) {
    arg13 = (char *)jenv->GetStringUTFChars(jarg13, 0);
    if (!arg13) return 0;
  }
  arg14 = (int)jarg14; 
  arg15 = *(int64_t **)&jarg15; 
  arg16 = *(void ***)&jarg16; 
  arg17 = *(int32_t ***)&jarg17; 
  arg18 = *(void ***)&jarg18; 
  result = (int)LGBM_BoosterPredictSparseOutput(arg1,(void const *)arg2,arg3,(int const *)arg4,(void const *)arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,(char const *)arg13,arg14,arg15,arg16,arg17,arg18);
  jresult = (jint)result; 
  if (arg13) jenv->ReleaseStringUTFChars(jarg13, (const char *)arg13);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterFreePredictSparse(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  jint jresult = 0 ;
  void *arg1 = (void *) 0 ;
  int32_t *arg2 = (int32_t *) 0 ;
  void *arg3 = (void *) 0 ;
  int arg4 ;
  int arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void **)&jarg1; 
  arg2 = *(int32_t **)&jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  result = (int)LGBM_BoosterFreePredictSparse(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForCSRSingleRow(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4, jlong jarg5, jint jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10, jint jarg11, jint jarg12, jstring jarg13, jlong jarg14, jlong jarg15) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int32_t *arg4 = (int32_t *) 0 ;
  void *arg5 = (void *) 0 ;
  int arg6 ;
  int64_t arg7 ;
  int64_t arg8 ;
  int64_t arg9 ;
  int arg10 ;
  int arg11 ;
  int arg12 ;
  char *arg13 = (char *) 0 ;
  int64_t *arg14 = (int64_t *) 0 ;
  double *arg15 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(int32_t **)&jarg4; 
  arg5 = *(void **)&jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (int64_t)jarg8; 
  arg9 = (int64_t)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  arg12 = (int)jarg12; 
  arg13 = 0;
  if (jarg13) {
    arg13 = (char *)jenv->GetStringUTFChars(jarg13, 0);
    if (!arg13) return 0;
  }
  arg14 = *(int64_t **)&jarg14; 
  arg15 = *(double **)&jarg15; 
  result = (int)LGBM_BoosterPredictForCSRSingleRow(arg1,(void const *)arg2,arg3,(int const *)arg4,(void const *)arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,(char const *)arg13,arg14,arg15);
  jresult = (jint)result; 
  if (arg13) jenv->ReleaseStringUTFChars(jarg13, (const char *)arg13);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForCSRSingleRowFastInit(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jlong jarg6, jstring jarg7, jlong jarg8) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int64_t arg6 ;
  char *arg7 = (char *) 0 ;
  FastConfigHandle *arg8 = (FastConfigHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int64_t)jarg6; 
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = *(FastConfigHandle **)&jarg8; 
  result = (int)LGBM_BoosterPredictForCSRSingleRowFastInit(arg1,arg2,arg3,arg4,arg5,arg6,(char const *)arg7,arg8);
  jresult = (jint)result; 
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForCSRSingleRowFast(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4, jlong jarg5, jlong jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  jint jresult = 0 ;
  FastConfigHandle arg1 = (FastConfigHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int32_t *arg4 = (int32_t *) 0 ;
  void *arg5 = (void *) 0 ;
  int64_t arg6 ;
  int64_t arg7 ;
  int64_t *arg8 = (int64_t *) 0 ;
  double *arg9 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FastConfigHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(int32_t **)&jarg4; 
  arg5 = *(void **)&jarg5; 
  arg6 = (int64_t)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = *(int64_t **)&jarg8; 
  arg9 = *(double **)&jarg9; 
  result = (int)LGBM_BoosterPredictForCSRSingleRowFast(arg1,(void const *)arg2,arg3,(int const *)arg4,(void const *)arg5,arg6,arg7,arg8,arg9);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForCSC(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jlong jarg4, jlong jarg5, jint jarg6, jlong jarg7, jlong jarg8, jlong jarg9, jint jarg10, jint jarg11, jint jarg12, jstring jarg13, jlong jarg14, jlong jarg15) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int32_t *arg4 = (int32_t *) 0 ;
  void *arg5 = (void *) 0 ;
  int arg6 ;
  int64_t arg7 ;
  int64_t arg8 ;
  int64_t arg9 ;
  int arg10 ;
  int arg11 ;
  int arg12 ;
  char *arg13 = (char *) 0 ;
  int64_t *arg14 = (int64_t *) 0 ;
  double *arg15 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(int32_t **)&jarg4; 
  arg5 = *(void **)&jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = (int64_t)jarg8; 
  arg9 = (int64_t)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  arg12 = (int)jarg12; 
  arg13 = 0;
  if (jarg13) {
    arg13 = (char *)jenv->GetStringUTFChars(jarg13, 0);
    if (!arg13) return 0;
  }
  arg14 = *(int64_t **)&jarg14; 
  arg15 = *(double **)&jarg15; 
  result = (int)LGBM_BoosterPredictForCSC(arg1,(void const *)arg2,arg3,(int const *)arg4,(void const *)arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,(char const *)arg13,arg14,arg15);
  jresult = (jint)result; 
  if (arg13) jenv->ReleaseStringUTFChars(jarg13, (const char *)arg13);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForMat(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8, jint jarg9, jstring jarg10, jlong jarg11, jlong jarg12) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int32_t arg4 ;
  int32_t arg5 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  int arg9 ;
  char *arg10 = (char *) 0 ;
  int64_t *arg11 = (int64_t *) 0 ;
  double *arg12 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int32_t)jarg4; 
  arg5 = (int32_t)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (int)jarg9; 
  arg10 = 0;
  if (jarg10) {
    arg10 = (char *)jenv->GetStringUTFChars(jarg10, 0);
    if (!arg10) return 0;
  }
  arg11 = *(int64_t **)&jarg11; 
  arg12 = *(double **)&jarg12; 
  result = (int)LGBM_BoosterPredictForMat(arg1,(void const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,(char const *)arg10,arg11,arg12);
  jresult = (jint)result; 
  if (arg10) jenv->ReleaseStringUTFChars(jarg10, (const char *)arg10);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForMatSingleRow(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8, jstring jarg9, jlong jarg10, jlong jarg11) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  char *arg9 = (char *) 0 ;
  int64_t *arg10 = (int64_t *) 0 ;
  double *arg11 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = 0;
  if (jarg9) {
    arg9 = (char *)jenv->GetStringUTFChars(jarg9, 0);
    if (!arg9) return 0;
  }
  arg10 = *(int64_t **)&jarg10; 
  arg11 = *(double **)&jarg11; 
  result = (int)LGBM_BoosterPredictForMatSingleRow(arg1,(void const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8,(char const *)arg9,arg10,arg11);
  jresult = (jint)result; 
  if (arg9) jenv->ReleaseStringUTFChars(jarg9, (const char *)arg9);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForMatSingleRowFastInit(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jstring jarg7, jlong jarg8) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int32_t arg6 ;
  char *arg7 = (char *) 0 ;
  FastConfigHandle *arg8 = (FastConfigHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int32_t)jarg6; 
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  arg8 = *(FastConfigHandle **)&jarg8; 
  result = (int)LGBM_BoosterPredictForMatSingleRowFastInit(arg1,arg2,arg3,arg4,arg5,arg6,(char const *)arg7,arg8);
  jresult = (jint)result; 
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForMatSingleRowFast(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  FastConfigHandle arg1 = (FastConfigHandle) 0 ;
  void *arg2 = (void *) 0 ;
  int64_t *arg3 = (int64_t *) 0 ;
  double *arg4 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(FastConfigHandle *)&jarg1; 
  arg2 = *(void **)&jarg2; 
  arg3 = *(int64_t **)&jarg3; 
  arg4 = *(double **)&jarg4; 
  result = (int)LGBM_BoosterPredictForMatSingleRowFast(arg1,(void const *)arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForMats(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8, jstring jarg9, jlong jarg10, jlong jarg11) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  void **arg2 = (void **) 0 ;
  int arg3 ;
  int32_t arg4 ;
  int32_t arg5 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  char *arg9 = (char *) 0 ;
  int64_t *arg10 = (int64_t *) 0 ;
  double *arg11 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(void ***)&jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int32_t)jarg4; 
  arg5 = (int32_t)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = 0;
  if (jarg9) {
    arg9 = (char *)jenv->GetStringUTFChars(jarg9, 0);
    if (!arg9) return 0;
  }
  arg10 = *(int64_t **)&jarg10; 
  arg11 = *(double **)&jarg11; 
  result = (int)LGBM_BoosterPredictForMats(arg1,(void const **)arg2,arg3,arg4,arg5,arg6,arg7,arg8,(char const *)arg9,arg10,arg11);
  jresult = (jint)result; 
  if (arg9) jenv->ReleaseStringUTFChars(jarg9, (const char *)arg9);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterSaveModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jstring jarg5) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  char *arg5 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  result = (int)LGBM_BoosterSaveModel(arg1,arg2,arg3,arg4,(char const *)arg5);
  jresult = (jint)result; 
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterDumpModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jlong jarg5, jlong jarg6, jstring jarg7) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int64_t arg5 ;
  int64_t *arg6 = (int64_t *) 0 ;
  char *arg7 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = *(int64_t **)&jarg6; 
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)jenv->GetStringUTFChars(jarg7, 0);
    if (!arg7) return 0;
  }
  result = (int)LGBM_BoosterDumpModel(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
  jresult = (jint)result; 
  if (arg7) jenv->ReleaseStringUTFChars(jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetLeafValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jlong jarg4) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  double *arg4 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(double **)&jarg4; 
  result = (int)LGBM_BoosterGetLeafValue(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterSetLeafValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jdouble jarg4) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  result = (int)LGBM_BoosterSetLeafValue(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterFeatureImportance(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jlong jarg4) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  double *arg4 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = *(double **)&jarg4; 
  result = (int)LGBM_BoosterFeatureImportance(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetUpperBoundValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  double *arg2 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(double **)&jarg2; 
  result = (int)LGBM_BoosterGetUpperBoundValue(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetLowerBoundValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  double *arg2 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = *(double **)&jarg2; 
  result = (int)LGBM_BoosterGetLowerBoundValue(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1NetworkInit(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)LGBM_NetworkInit((char const *)arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1NetworkFree(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)LGBM_NetworkFree();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1NetworkInitWithFunctions(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jlong jarg3, jlong jarg4) {
  jint jresult = 0 ;
  int arg1 ;
  int arg2 ;
  void *arg3 = (void *) 0 ;
  void *arg4 = (void *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(void **)&jarg3; 
  arg4 = *(void **)&jarg4; 
  result = (int)LGBM_NetworkInitWithFunctions(arg1,arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LastErrorMsg(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)LastErrorMsg();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1SetLastError(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  LGBM_SetLastError((char const *)arg1);
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
}


SWIGEXPORT jstring JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterSaveModelToStringSWIG(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jlong jarg5, jlong jarg6) {
  jstring jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int64_t arg5 ;
  int64_t *arg6 = (int64_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = *(int64_t **)&jarg6; 
  result = (char *)LGBM_BoosterSaveModelToStringSWIG(arg1,arg2,arg3,arg4,arg5,arg6);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterDumpModelSWIG(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jint jarg3, jint jarg4, jlong jarg5, jlong jarg6) {
  jstring jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int64_t arg5 ;
  int64_t *arg6 = (int64_t *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int64_t)jarg5; 
  arg6 = *(int64_t **)&jarg6; 
  result = (char *)LGBM_BoosterDumpModelSWIG(arg1,arg2,arg3,arg4,arg5,arg6);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForMatSingle(JNIEnv *jenv, jclass jcls, jdoubleArray jarg2, jlong jarg3, jint jarg4, jint jarg5, jint jarg6, jint jarg7, jint jarg8, jint jarg9, jstring jarg10, jlong jarg11, jlong jarg12) {
  jint jresult = 0 ;
  JNIEnv *arg1 = (JNIEnv *) 0 ;
  jdoubleArray arg2 ;
  BoosterHandle arg3 = (BoosterHandle) 0 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  int arg9 ;
  char *arg10 = (char *) 0 ;
  int64_t *arg11 = (int64_t *) 0 ;
  double *arg12 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = jenv;
  
  arg2 = jarg2; 
  arg3 = *(BoosterHandle *)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (int)jarg9; 
  arg10 = 0;
  if (jarg10) {
    arg10 = (char *)jenv->GetStringUTFChars(jarg10, 0);
    if (!arg10) return 0;
  }
  arg11 = *(int64_t **)&jarg11; 
  arg12 = *(double **)&jarg12; 
  result = (int)LGBM_BoosterPredictForMatSingle(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,(char const *)arg10,arg11,arg12);
  jresult = (jint)result; 
  if (arg10) jenv->ReleaseStringUTFChars(jarg10, (const char *)arg10);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForMatSingleRowFastCriticalSWIG(JNIEnv *jenv, jclass jcls, jdoubleArray jarg2, jlong jarg3, jlong jarg4, jlong jarg5) {
  jint jresult = 0 ;
  JNIEnv *arg1 = (JNIEnv *) 0 ;
  jdoubleArray arg2 ;
  FastConfigHandle arg3 = (FastConfigHandle) 0 ;
  int64_t *arg4 = (int64_t *) 0 ;
  double *arg5 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = jenv;
  
  arg2 = jarg2; 
  arg3 = *(FastConfigHandle *)&jarg3; 
  arg4 = *(int64_t **)&jarg4; 
  arg5 = *(double **)&jarg5; 
  result = (int)LGBM_BoosterPredictForMatSingleRowFastCriticalSWIG(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForCSRSingle(JNIEnv *jenv, jclass jcls, jintArray jarg2, jdoubleArray jarg3, jint jarg4, jlong jarg5, jint jarg6, jint jarg7, jlong jarg8, jlong jarg9, jint jarg10, jint jarg11, jint jarg12, jstring jarg13, jlong jarg14, jlong jarg15) {
  jint jresult = 0 ;
  JNIEnv *arg1 = (JNIEnv *) 0 ;
  jintArray arg2 ;
  jdoubleArray arg3 ;
  int arg4 ;
  BoosterHandle arg5 = (BoosterHandle) 0 ;
  int arg6 ;
  int arg7 ;
  int64_t arg8 ;
  int64_t arg9 ;
  int arg10 ;
  int arg11 ;
  int arg12 ;
  char *arg13 = (char *) 0 ;
  int64_t *arg14 = (int64_t *) 0 ;
  double *arg15 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = jenv;
  
  arg2 = jarg2; 
  arg3 = jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(BoosterHandle *)&jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int64_t)jarg8; 
  arg9 = (int64_t)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  arg12 = (int)jarg12; 
  arg13 = 0;
  if (jarg13) {
    arg13 = (char *)jenv->GetStringUTFChars(jarg13, 0);
    if (!arg13) return 0;
  }
  arg14 = *(int64_t **)&jarg14; 
  arg15 = *(double **)&jarg15; 
  result = (int)LGBM_BoosterPredictForCSRSingle(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,(char const *)arg13,arg14,arg15);
  jresult = (jint)result; 
  if (arg13) jenv->ReleaseStringUTFChars(jarg13, (const char *)arg13);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterPredictForCSRSingleRowFastCriticalSWIG(JNIEnv *jenv, jclass jcls, jintArray jarg2, jdoubleArray jarg3, jint jarg4, jlong jarg5, jint jarg6, jlong jarg7, jlong jarg8, jlong jarg9) {
  jint jresult = 0 ;
  JNIEnv *arg1 = (JNIEnv *) 0 ;
  jintArray arg2 ;
  jdoubleArray arg3 ;
  int arg4 ;
  FastConfigHandle arg5 = (FastConfigHandle) 0 ;
  int arg6 ;
  int64_t arg7 ;
  int64_t *arg8 = (int64_t *) 0 ;
  double *arg9 = (double *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = jenv;
  
  arg2 = jarg2; 
  arg3 = jarg3; 
  arg4 = (int)jarg4; 
  arg5 = *(FastConfigHandle *)&jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int64_t)jarg7; 
  arg8 = *(int64_t **)&jarg8; 
  arg9 = *(double **)&jarg9; 
  result = (int)LGBM_BoosterPredictForCSRSingleRowFastCriticalSWIG(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1indices_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  jintArray arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  arg2 = jarg2; 
  if (arg1) (arg1)->indices = arg2;
}


SWIGEXPORT jintArray JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1indices_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jintArray jresult = 0 ;
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  jintArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  result =  ((arg1)->indices);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1values_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdoubleArray jarg2) {
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  jdoubleArray arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  arg2 = jarg2; 
  if (arg1) (arg1)->values = arg2;
}


SWIGEXPORT jdoubleArray JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1values_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdoubleArray jresult = 0 ;
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  jdoubleArray result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  result =  ((arg1)->values);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1indices0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  arg2 = *(int **)&jarg2; 
  if (arg1) (arg1)->indices0 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1indices0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  result = (int *) ((arg1)->indices0);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1values0_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  double *arg2 = (double *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  if (arg1) (arg1)->values0 = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1values0_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  result = (double *) ((arg1)->values0);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1size_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  arg2 = (int)jarg2; 
  if (arg1) (arg1)->size = arg2;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_CSRDirect_1size_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CSRDirect **)&jarg1; 
  result = (int) ((arg1)->size);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1CSRDirect(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CSRDirect *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CSRDirect *)new CSRDirect();
  *(CSRDirect **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1CSRDirect(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CSRDirect *arg1 = (CSRDirect *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CSRDirect **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetCreateFromCSRSpark(JNIEnv *jenv, jclass jcls, jobjectArray jarg2, jint jarg3, jlong jarg4, jstring jarg5, jlong jarg6, jlong jarg7) {
  jint jresult = 0 ;
  JNIEnv *arg1 = (JNIEnv *) 0 ;
  jobjectArray arg2 ;
  int arg3 ;
  int64_t arg4 ;
  char *arg5 = (char *) 0 ;
  DatasetHandle arg6 = (DatasetHandle) (DatasetHandle)0 ;
  DatasetHandle *arg7 = (DatasetHandle *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = jenv;
  
  arg2 = jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int64_t)jarg4; 
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = *(DatasetHandle *)&jarg6; 
  arg7 = *(DatasetHandle **)&jarg7; 
  result = (int)LGBM_DatasetCreateFromCSRSpark(arg1,arg2,arg3,arg4,(char const *)arg5,arg6,arg7);
  jresult = (jint)result; 
  if (arg5) jenv->ReleaseStringUTFChars(jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1intp(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (int *)new_intp();
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_copy_1intp(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int *)copy_intp(arg1);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1intp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int *arg1 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  delete_intp(arg1);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_intp_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  int *arg1 = (int *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  arg2 = (int)jarg2; 
  intp_assign(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_intp_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  int *arg1 = (int *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  result = (int)intp_value(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1longp(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  long *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (long *)new_longp();
  *(long **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_copy_1longp(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  long arg1 ;
  long *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (long)jarg1; 
  result = (long *)copy_longp(arg1);
  *(long **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1longp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  long *arg1 = (long *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(long **)&jarg1; 
  delete_longp(arg1);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_longp_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  long *arg1 = (long *) 0 ;
  long arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(long **)&jarg1; 
  arg2 = (long)jarg2; 
  longp_assign(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_longp_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  long *arg1 = (long *) 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(long **)&jarg1; 
  result = (long)longp_value(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1doublep(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (double *)new_doublep();
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_copy_1doublep(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  result = (double *)copy_doublep(arg1);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1doublep(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  double *arg1 = (double *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double **)&jarg1; 
  delete_doublep(arg1);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doublep_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2) {
  double *arg1 = (double *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double **)&jarg1; 
  arg2 = (double)jarg2; 
  doublep_assign(arg1,arg2);
}


SWIGEXPORT jdouble JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doublep_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jdouble jresult = 0 ;
  double *arg1 = (double *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double **)&jarg1; 
  result = (double)doublep_value(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1floatp(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (float *)new_floatp();
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_copy_1floatp(JNIEnv *jenv, jclass jcls, jfloat jarg1) {
  jlong jresult = 0 ;
  float arg1 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (float)jarg1; 
  result = (float *)copy_floatp(arg1);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1floatp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  float *arg1 = (float *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(float **)&jarg1; 
  delete_floatp(arg1);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatp_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jfloat jarg2) {
  float *arg1 = (float *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(float **)&jarg1; 
  arg2 = (float)jarg2; 
  floatp_assign(arg1,arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatp_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jfloat jresult = 0 ;
  float *arg1 = (float *) 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(float **)&jarg1; 
  result = (float)floatp_value(arg1);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1int64_1tp(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int64_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (int64_t *)new_int64_tp();
  *(int64_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_copy_1int64_1tp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t arg1 ;
  int64_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int64_t)jarg1; 
  result = (int64_t *)copy_int64_tp(arg1);
  *(int64_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1int64_1tp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int64_t *arg1 = (int64_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int64_t **)&jarg1; 
  delete_int64_tp(arg1);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int64_1tp_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  int64_t *arg1 = (int64_t *) 0 ;
  int64_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int64_t **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  int64_tp_assign(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int64_1tp_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t *arg1 = (int64_t *) 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int64_t **)&jarg1; 
  result = (int64_t)int64_tp_value(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1int32_1tp(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  int32_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (int32_t *)new_int32_tp();
  *(int32_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_copy_1int32_1tp(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int32_t arg1 ;
  int32_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int32_t)jarg1; 
  result = (int32_t *)copy_int32_tp(arg1);
  *(int32_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1int32_1tp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int32_t *arg1 = (int32_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int32_t **)&jarg1; 
  delete_int32_tp(arg1);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32_1tp_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  int32_t *arg1 = (int32_t *) 0 ;
  int32_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int32_t **)&jarg1; 
  arg2 = (int32_t)jarg2; 
  int32_tp_assign(arg1,arg2);
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32_1tp_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jint jresult = 0 ;
  int32_t *arg1 = (int32_t *) 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int32_t **)&jarg1; 
  result = (int32_t)int32_tp_value(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1size_1tp(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  size_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (size_t *)new_size_tp();
  *(size_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_copy_1size_1tp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  size_t arg1 ;
  size_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  result = (size_t *)copy_size_tp(arg1);
  *(size_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1size_1tp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  size_t *arg1 = (size_t *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(size_t **)&jarg1; 
  delete_size_tp(arg1);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_size_1tp_1assign(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  size_t *arg1 = (size_t *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(size_t **)&jarg1; 
  arg2 = (size_t)jarg2; 
  size_tp_assign(arg1,arg2);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_size_1tp_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  size_t *arg1 = (size_t *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(size_t **)&jarg1; 
  result = size_tp_value(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int64_1t_1to_1long_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t *arg1 = (int64_t *) 0 ;
  long *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int64_t **)&jarg1; 
  result = (long *)int64_t_to_long_ptr(arg1);
  *(long **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int64_1t_1to_1double_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t *arg1 = (int64_t *) 0 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int64_t **)&jarg1; 
  result = (double *)int64_t_to_double_ptr(arg1);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32_1t_1to_1int_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int32_t *arg1 = (int32_t *) 0 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int32_t **)&jarg1; 
  result = (int *)int32_t_to_int_ptr(arg1);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_long_1to_1int64_1t_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  long *arg1 = (long *) 0 ;
  int64_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(long **)&jarg1; 
  result = (int64_t *)long_to_int64_t_ptr(arg1);
  *(int64_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_double_1to_1int64_1t_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  double *arg1 = (double *) 0 ;
  int64_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double **)&jarg1; 
  result = (int64_t *)double_to_int64_t_ptr(arg1);
  *(int64_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int_1to_1int32_1t_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int *arg1 = (int *) 0 ;
  int32_t *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  result = (int32_t *)int_to_int32_t_ptr(arg1);
  *(int32_t **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_double_1to_1voidp_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  double *arg1 = (double *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double **)&jarg1; 
  result = (void *)double_to_voidp_ptr(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_float_1to_1voidp_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  float *arg1 = (float *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(float **)&jarg1; 
  result = (void *)float_to_voidp_ptr(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int_1to_1voidp_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int *arg1 = (int *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  result = (void *)int_to_voidp_ptr(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32_1t_1to_1voidp_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int32_t *arg1 = (int32_t *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int32_t **)&jarg1; 
  result = (void *)int32_t_to_voidp_ptr(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int64_1t_1to_1voidp_1ptr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t *arg1 = (int64_t *) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int64_t **)&jarg1; 
  result = (void *)int64_t_to_voidp_ptr(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1doubleArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t arg1 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int64_t)jarg1; 
  result = (double *)new_doubleArray(arg1);
  *(double **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1doubleArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  double *arg1 = (double *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double **)&jarg1; 
  delete_doubleArray(arg1);
}


SWIGEXPORT jdouble JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jdouble jresult = 0 ;
  double *arg1 = (double *) 0 ;
  int64_t arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (double)doubleArray_getitem(arg1,arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jdouble jarg3) {
  double *arg1 = (double *) 0 ;
  int64_t arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(double **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (double)jarg3; 
  doubleArray_setitem(arg1,arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1floatArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t arg1 ;
  float *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int64_t)jarg1; 
  result = (float *)new_floatArray(arg1);
  *(float **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1floatArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  float *arg1 = (float *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(float **)&jarg1; 
  delete_floatArray(arg1);
}


SWIGEXPORT jfloat JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jfloat jresult = 0 ;
  float *arg1 = (float *) 0 ;
  int64_t arg2 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(float **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (float)floatArray_getitem(arg1,arg2);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jfloat jarg3) {
  float *arg1 = (float *) 0 ;
  int64_t arg2 ;
  float arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(float **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (float)jarg3; 
  floatArray_setitem(arg1,arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1intArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t arg1 ;
  int *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int64_t)jarg1; 
  result = (int *)new_intArray(arg1);
  *(int **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1intArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  int *arg1 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  delete_intArray(arg1);
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_intArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  int *arg1 = (int *) 0 ;
  int64_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (int)intArray_getitem(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_intArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  int *arg1 = (int *) 0 ;
  int64_t arg2 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(int **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (int)jarg3; 
  intArray_setitem(arg1,arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1longArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  int64_t arg1 ;
  long *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int64_t)jarg1; 
  result = (long *)new_longArray(arg1);
  *(long **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1longArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  long *arg1 = (long *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(long **)&jarg1; 
  delete_longArray(arg1);
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_longArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jint jresult = 0 ;
  long *arg1 = (long *) 0 ;
  int64_t arg2 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(long **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  result = (long)longArray_getitem(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_longArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  long *arg1 = (long *) 0 ;
  int64_t arg2 ;
  long arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(long **)&jarg1; 
  arg2 = (int64_t)jarg2; 
  arg3 = (long)jarg3; 
  longArray_setitem(arg1,arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1voidpp(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (void **)new_voidpp();
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1voidpp(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  void **arg1 = (void **) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void ***)&jarg1; 
  delete_voidpp(arg1);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_voidpp_1value(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  void **arg1 = (void **) 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(void ***)&jarg1; 
  result = (void *)voidpp_value(arg1);
  *(void **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_voidpp_1handle(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (void **)voidpp_handle();
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_StringArrayHandle_1create(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  size_t arg1 ;
  size_t arg2 ;
  StringArrayHandle result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  arg2 = (size_t)jarg2; 
  result = (StringArrayHandle)StringArrayHandle_create(arg1,arg2);
  *(StringArrayHandle *)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_StringArrayHandle_1free(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  StringArrayHandle arg1 = (StringArrayHandle) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(StringArrayHandle *)&jarg1; 
  StringArrayHandle_free(arg1);
}


SWIGEXPORT jobjectArray JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_StringArrayHandle_1get_1strings(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jobjectArray jresult = 0 ;
  StringArrayHandle arg1 = (StringArrayHandle) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(StringArrayHandle *)&jarg1; 
  result = (char **)StringArrayHandle_get_strings(arg1);
  {
    if (result) {
      int i;
      jsize len=0;
      jstring temp_string;
      const jclass clazz = jenv->FindClass("java/lang/String");
      
      while (result[len]) len++;
      jresult = jenv->NewObjectArray(len, clazz, NULL);
      /* exception checking omitted */
      
      for (i=0; i<len; i++) {
        temp_string = jenv->NewStringUTF(*result++);
        jenv->SetObjectArrayElement(jresult, i, temp_string);
        jenv->DeleteLocalRef(temp_string);
      }
    }
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_StringArrayHandle_1get_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jstring jresult = 0 ;
  StringArrayHandle arg1 = (StringArrayHandle) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(StringArrayHandle *)&jarg1; 
  arg2 = (int)jarg2; 
  result = (char *)StringArrayHandle_get_string(arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_StringArrayHandle_1set_1string(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3) {
  jint jresult = 0 ;
  StringArrayHandle arg1 = (StringArrayHandle) 0 ;
  size_t arg2 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(StringArrayHandle *)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return 0;
  }
  result = (int)StringArrayHandle_set_string(arg1,arg2,(char const *)arg3);
  jresult = (jint)result; 
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_StringArrayHandle_1get_1num_1elements(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  StringArrayHandle arg1 = (StringArrayHandle) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(StringArrayHandle *)&jarg1; 
  result = StringArrayHandle_get_num_elements(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetEvalNamesSWIG(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  StringArrayHandle result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  result = (StringArrayHandle)LGBM_BoosterGetEvalNamesSWIG(arg1);
  *(StringArrayHandle *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1BoosterGetFeatureNamesSWIG(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  StringArrayHandle result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  result = (StringArrayHandle)LGBM_BoosterGetFeatureNamesSWIG(arg1);
  *(StringArrayHandle *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_LGBM_1DatasetGetFeatureNamesSWIG(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  BoosterHandle arg1 = (BoosterHandle) 0 ;
  StringArrayHandle result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(BoosterHandle *)&jarg1; 
  result = (StringArrayHandle)LGBM_DatasetGetFeatureNamesSWIG(arg1);
  *(StringArrayHandle *)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1int32ChunkedArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  size_t arg1 ;
  LightGBM::ChunkedArray< int32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  result = (LightGBM::ChunkedArray< int32_t > *)new LightGBM::ChunkedArray< int32_t >(arg1);
  *(LightGBM::ChunkedArray< int32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1int32ChunkedArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->add(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1get_1add_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< int32_t > const *)arg1)->get_add_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1get_1chunks_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< int32_t > const *)arg1)->get_chunks_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1get_1last_1chunk_1add_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< int32_t > const *)arg1)->get_last_chunk_add_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1get_1chunk_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< int32_t > const *)arg1)->get_chunk_size();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1data(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  int **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  result = (int **)(arg1)->data();
  *(int ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1data_1as_1void(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  result = (void **)(arg1)->data_as_void();
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1coalesce_1to_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  int *arg2 = (int *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  arg2 = *(int **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  ((LightGBM::ChunkedArray< int32_t > const *)arg1)->coalesce_to(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1coalesce_1to_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  int *arg2 = (int *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  arg2 = *(int **)&jarg2; 
  ((LightGBM::ChunkedArray< int32_t > const *)arg1)->coalesce_to(arg2);
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)((LightGBM::ChunkedArray< int32_t > const *)arg1)->getitem(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  int arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = (int)jarg4; 
  result = (int)(arg1)->setitem(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  (arg1)->release();
}


SWIGEXPORT jboolean JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1within_1bounds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)((LightGBM::ChunkedArray< int32_t > const *)arg1)->within_bounds(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_int32ChunkedArray_1new_1chunk(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< int32_t > *arg1 = (LightGBM::ChunkedArray< int32_t > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< int32_t > **)&jarg1; 
  (arg1)->new_chunk();
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1floatChunkedArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  size_t arg1 ;
  LightGBM::ChunkedArray< float > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  result = (LightGBM::ChunkedArray< float > *)new LightGBM::ChunkedArray< float >(arg1);
  *(LightGBM::ChunkedArray< float > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1floatChunkedArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  float arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  arg2 = (float)jarg2; 
  (arg1)->add(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1get_1add_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< float > const *)arg1)->get_add_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1get_1chunks_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< float > const *)arg1)->get_chunks_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1get_1last_1chunk_1add_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< float > const *)arg1)->get_last_chunk_add_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1get_1chunk_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< float > const *)arg1)->get_chunk_size();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1data(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  float **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  result = (float **)(arg1)->data();
  *(float ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1data_1as_1void(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  result = (void **)(arg1)->data_as_void();
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1coalesce_1to_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  float *arg2 = (float *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  arg2 = *(float **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  ((LightGBM::ChunkedArray< float > const *)arg1)->coalesce_to(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1coalesce_1to_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  float *arg2 = (float *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  arg2 = *(float **)&jarg2; 
  ((LightGBM::ChunkedArray< float > const *)arg1)->coalesce_to(arg2);
}


SWIGEXPORT jfloat JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jfloat jarg4) {
  jfloat jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  float arg4 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = (float)jarg4; 
  result = (float)((LightGBM::ChunkedArray< float > const *)arg1)->getitem(arg2,arg3,arg4);
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jfloat jarg4) {
  jint jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  float arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = (float)jarg4; 
  result = (int)(arg1)->setitem(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  (arg1)->release();
}


SWIGEXPORT jboolean JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1within_1bounds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)((LightGBM::ChunkedArray< float > const *)arg1)->within_bounds(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_floatChunkedArray_1new_1chunk(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< float > *arg1 = (LightGBM::ChunkedArray< float > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< float > **)&jarg1; 
  (arg1)->new_chunk();
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_new_1doubleChunkedArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  size_t arg1 ;
  LightGBM::ChunkedArray< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (size_t)jarg1; 
  result = (LightGBM::ChunkedArray< double > *)new LightGBM::ChunkedArray< double >(arg1);
  *(LightGBM::ChunkedArray< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_delete_1doubleChunkedArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1add(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->add(arg2);
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1get_1add_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< double > const *)arg1)->get_add_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1get_1chunks_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< double > const *)arg1)->get_chunks_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1get_1last_1chunk_1add_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< double > const *)arg1)->get_last_chunk_add_count();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1get_1chunk_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  result = ((LightGBM::ChunkedArray< double > const *)arg1)->get_chunk_size();
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1data(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  double **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  result = (double **)(arg1)->data();
  *(double ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1data_1as_1void(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  void **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  result = (void **)(arg1)->data_as_void();
  *(void ***)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1coalesce_1to_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jboolean jarg3) {
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  double *arg2 = (double *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  arg3 = jarg3 ? true : false; 
  ((LightGBM::ChunkedArray< double > const *)arg1)->coalesce_to(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1coalesce_1to_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  double *arg2 = (double *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  arg2 = *(double **)&jarg2; 
  ((LightGBM::ChunkedArray< double > const *)arg1)->coalesce_to(arg2);
}


SWIGEXPORT jdouble JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jdouble jarg4) {
  jdouble jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  double arg4 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = (double)jarg4; 
  result = (double)((LightGBM::ChunkedArray< double > const *)arg1)->getitem(arg2,arg3,arg4);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3, jdouble jarg4) {
  jint jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  double arg4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  arg4 = (double)jarg4; 
  result = (int)(arg1)->setitem(arg2,arg3,arg4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  (arg1)->clear();
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1release(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  (arg1)->release();
}


SWIGEXPORT jboolean JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1within_1bounds(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jboolean jresult = 0 ;
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  result = (bool)((LightGBM::ChunkedArray< double > const *)arg1)->within_bounds(arg2,arg3);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_microsoft_ml_lightgbm_lightgbmlibJNI_doubleChunkedArray_1new_1chunk(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  LightGBM::ChunkedArray< double > *arg1 = (LightGBM::ChunkedArray< double > *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(LightGBM::ChunkedArray< double > **)&jarg1; 
  (arg1)->new_chunk();
}


#ifdef __cplusplus
}
#endif

