/*
 * Decompiled with CFR 0.152.
 */
package io.github.metarank.lightgbm4j;

import com.microsoft.ml.lightgbm.PredictionType;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_double;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_float;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_int;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_long_long;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_p_void;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_void;
import com.microsoft.ml.lightgbm.lightgbmlib;
import io.github.metarank.lightgbm4j.LGBMDataset;
import io.github.metarank.lightgbm4j.LGBMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public class LGBMBooster
implements AutoCloseable {
    private int iterations;
    private SWIGTYPE_p_p_void handle;
    private static final long MODEL_SAVE_BUFFER_SIZE = 0xA00000L;
    private static final long EVAL_RESULTS_BUFFER_SIZE = 1024L;
    private static volatile boolean nativeLoaded = false;
    private volatile boolean isClosed = false;

    public static boolean isNativeLoaded() {
        return nativeLoaded;
    }

    public static synchronized void loadNative() throws IOException {
        block17: {
            if (!nativeLoaded) {
                String os = System.getProperty("os.name");
                String arch = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
                if (os.startsWith("Linux") || os.startsWith("LINUX")) {
                    try {
                        if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
                            LGBMBooster.loadNative("linux/x86_64/lib_lightgbm.so", "lib_lightgbm.so");
                            LGBMBooster.loadNative("linux/x86_64/lib_lightgbm_swig.so", "lib_lightgbm_swig.so");
                            nativeLoaded = true;
                        } else if (arch.startsWith("aarch64") || arch.startsWith("arm64")) {
                            LGBMBooster.loadNative("linux/aarch64/lib_lightgbm.so", "lib_lightgbm.so");
                            LGBMBooster.loadNative("linux/aarch64/lib_lightgbm_swig.so", "lib_lightgbm_swig.so");
                            nativeLoaded = true;
                        }
                        break block17;
                    }
                    catch (UnsatisfiedLinkError err) {
                        String message = err.getMessage();
                        if (message.contains("libgomp")) {
                            System.out.println("\n\n\n");
                            System.out.println("****************************************************");
                            System.out.println("Your Linux system probably has no 'libgomp' library installed!");
                            System.out.println("Please double-check the lightgbm4j install instructions:");
                            System.out.println("- https://github.com/metarank/lightgbm4j/");
                            System.out.println("- or just install the libgomp with your package manager");
                            System.out.println("****************************************************");
                            System.out.println("\n\n\n");
                        }
                        break block17;
                    }
                }
                if (os.startsWith("Mac")) {
                    try {
                        if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
                            LGBMBooster.loadNative("osx/x86_64/lib_lightgbm.dylib", "lib_lightgbm.dylib");
                            LGBMBooster.loadNative("osx/x86_64/lib_lightgbm_swig.dylib", "lib_lightgbm_swig.dylib");
                            nativeLoaded = true;
                        }
                        if (arch.startsWith("aarch64") || arch.startsWith("arm64")) {
                            LGBMBooster.loadNative("osx/aarch64/lib_lightgbm.dylib", "lib_lightgbm.dylib");
                            LGBMBooster.loadNative("osx/aarch64/lib_lightgbm_swig.dylib", "lib_lightgbm_swig.dylib");
                            nativeLoaded = true;
                        }
                        System.out.println("arch " + arch + " is not supported");
                        throw new UnsatisfiedLinkError("no native lightgbm library found for your OS " + os);
                    }
                    catch (UnsatisfiedLinkError err) {
                        String message = err.getMessage();
                        if (message.contains("libomp.dylib")) {
                            System.out.println("\n\n\n");
                            System.out.println("****************************************************");
                            System.out.println("Your MacOS system probably has no 'libomp' library installed!");
                            System.out.println("Please double-check the lightgbm4j install instructions:");
                            System.out.println("- https://github.com/metarank/lightgbm4j/");
                            System.out.println("- or just do 'brew install libomp'");
                            System.out.println("****************************************************");
                            System.out.println("\n\n\n");
                        }
                        throw err;
                    }
                } else if (os.startsWith("Windows")) {
                    LGBMBooster.loadNative("windows/x86_64/lib_lightgbm.dll", "lib_lightgbm.dll");
                    LGBMBooster.loadNative("windows/x86_64/lib_lightgbm_swig.dll", "lib_lightgbm_swig.dll");
                    nativeLoaded = true;
                } else {
                    System.out.println("Only Linux@x86_64, Windows@x86_64, Mac@x86_64 and Mac@aarch are supported");
                }
            }
        }
    }

    private static void loadNative(String path, String name) throws IOException, UnsatisfiedLinkError {
        System.out.println("Loading native lib " + path);
        String tmp = System.getProperty("java.io.tmpdir");
        File libFile = new File(tmp + File.separator + name);
        if (libFile.exists()) {
            System.out.println(libFile + " already exists");
        } else {
            LGBMBooster.extractResource(path, name, libFile);
        }
        System.out.println("Extracted file: exists=" + libFile.exists() + " path=" + libFile);
        try {
            System.load(libFile.toString());
        }
        catch (UnsatisfiedLinkError err) {
            System.out.println("Cannot load library:" + err.getMessage());
            throw err;
        }
    }

    private static void extractResource(String path, String name, File dest) throws IOException {
        System.out.println("Extracting native lib " + dest);
        InputStream libStream = LGBMBooster.class.getClassLoader().getResourceAsStream(path);
        FileOutputStream fileStream = new FileOutputStream(dest);
        LGBMBooster.copyStream(libStream, fileStream);
        libStream.close();
        ((OutputStream)fileStream).close();
    }

    private static void copyStream(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        int bytesCopied = 0;
        while ((length = source.read(buf)) > 0) {
            target.write(buf, 0, length);
            bytesCopied += length;
        }
        System.out.println("Copied " + bytesCopied + " bytes");
    }

    LGBMBooster(int iterations, SWIGTYPE_p_p_void handle) {
        this.iterations = iterations;
        this.handle = handle;
    }

    public static LGBMBooster createFromModelfile(String file) throws LGBMException {
        SWIGTYPE_p_p_void handle = lightgbmlib.new_voidpp();
        SWIGTYPE_p_int outIterations = lightgbmlib.new_intp();
        int result = lightgbmlib.LGBM_BoosterCreateFromModelfile(file, outIterations, handle);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        int iterations = lightgbmlib.intp_value(outIterations);
        lightgbmlib.delete_intp(outIterations);
        return new LGBMBooster(iterations, handle);
    }

    public static LGBMBooster loadModelFromString(String model) throws LGBMException {
        SWIGTYPE_p_p_void handle = lightgbmlib.new_voidpp();
        SWIGTYPE_p_int outIterations = lightgbmlib.new_intp();
        int result = lightgbmlib.LGBM_BoosterLoadModelFromString(model, outIterations, handle);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        int iterations = lightgbmlib.intp_value(outIterations);
        lightgbmlib.delete_intp(outIterations);
        return new LGBMBooster(iterations, handle);
    }

    @Override
    public void close() throws LGBMException {
        if (!this.isClosed) {
            this.isClosed = true;
            int result = lightgbmlib.LGBM_BoosterFree(lightgbmlib.voidpp_value(this.handle));
            if (result < 0) {
                throw new LGBMException(lightgbmlib.LGBM_GetLastError());
            }
        }
    }

    public double[] predictForMat(float[] input, int rows, int cols, boolean isRowMajor, PredictionType predictionType) throws LGBMException {
        SWIGTYPE_p_float dataBuffer = lightgbmlib.new_floatArray(input.length);
        for (int i = 0; i < input.length; ++i) {
            lightgbmlib.floatArray_setitem(dataBuffer, i, input[i]);
        }
        SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
        long outSize = this.outBufferSize(rows, cols, predictionType);
        SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outSize);
        int result = lightgbmlib.LGBM_BoosterPredictForMat(lightgbmlib.voidpp_value(this.handle), lightgbmlib.float_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT32, rows, cols, isRowMajor ? 1 : 0, predictionType.getType(), 0, this.iterations, "", outLength, outBuffer);
        if (result < 0) {
            lightgbmlib.delete_floatArray(dataBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        long length = lightgbmlib.int64_tp_value(outLength);
        double[] values = new double[(int)length];
        int i = 0;
        while ((long)i < length) {
            values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
            ++i;
        }
        lightgbmlib.delete_floatArray(dataBuffer);
        lightgbmlib.delete_int64_tp(outLength);
        lightgbmlib.delete_doubleArray(outBuffer);
        return values;
    }

    public double[] predictForMat(double[] input, int rows, int cols, boolean isRowMajor, PredictionType predictionType) throws LGBMException {
        SWIGTYPE_p_double dataBuffer = lightgbmlib.new_doubleArray(input.length);
        for (int i = 0; i < input.length; ++i) {
            lightgbmlib.doubleArray_setitem(dataBuffer, i, input[i]);
        }
        SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
        long outSize = this.outBufferSize(rows, cols, predictionType);
        SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outSize);
        int result = lightgbmlib.LGBM_BoosterPredictForMat(lightgbmlib.voidpp_value(this.handle), lightgbmlib.double_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT64, rows, cols, isRowMajor ? 1 : 0, predictionType.getType(), 0, this.iterations, "", outLength, outBuffer);
        if (result < 0) {
            lightgbmlib.delete_doubleArray(dataBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        long length = lightgbmlib.int64_tp_value(outLength);
        double[] values = new double[(int)length];
        int i = 0;
        while ((long)i < length) {
            values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
            ++i;
        }
        lightgbmlib.delete_doubleArray(dataBuffer);
        lightgbmlib.delete_int64_tp(outLength);
        lightgbmlib.delete_doubleArray(outBuffer);
        return values;
    }

    public static LGBMBooster create(LGBMDataset dataset, String parameters) throws LGBMException {
        SWIGTYPE_p_p_void handle = lightgbmlib.new_voidpp();
        int result = lightgbmlib.LGBM_BoosterCreate(dataset.handle, parameters, handle);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        return new LGBMBooster(0, handle);
    }

    public boolean updateOneIter() throws LGBMException {
        SWIGTYPE_p_int isFinishedP = lightgbmlib.new_intp();
        int result = lightgbmlib.LGBM_BoosterUpdateOneIter(lightgbmlib.voidpp_value(this.handle), isFinishedP);
        ++this.iterations;
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        int isFinished = lightgbmlib.intp_value(isFinishedP);
        lightgbmlib.delete_intp(isFinishedP);
        return isFinished == 1;
    }

    public String saveModelToString(int startIteration, int numIteration, FeatureImportanceType featureImportance) {
        SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
        String result = lightgbmlib.LGBM_BoosterSaveModelToStringSWIG(lightgbmlib.voidpp_value(this.handle), startIteration, numIteration, this.importanceType(featureImportance), 0xA00000L, outLength);
        lightgbmlib.delete_int64_tp(outLength);
        return result;
    }

    public String[] getFeatureNames() {
        SWIGTYPE_p_void buffer = lightgbmlib.LGBM_BoosterGetFeatureNamesSWIG(lightgbmlib.voidpp_value(this.handle));
        String[] result = lightgbmlib.StringArrayHandle_get_strings(buffer);
        lightgbmlib.StringArrayHandle_free(buffer);
        return result;
    }

    public void addValidData(LGBMDataset dataset) throws LGBMException {
        int result = lightgbmlib.LGBM_BoosterAddValidData(lightgbmlib.voidpp_value(this.handle), dataset.handle);
        if (result < 0) {
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
    }

    public double[] getEval(int dataIndex) throws LGBMException {
        SWIGTYPE_p_int outLength = lightgbmlib.new_int32_tp();
        SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(1024L);
        int result = lightgbmlib.LGBM_BoosterGetEval(lightgbmlib.voidpp_value(this.handle), dataIndex, outLength, outBuffer);
        if (result < 0) {
            lightgbmlib.delete_intp(outLength);
            lightgbmlib.delete_doubleArray(outBuffer);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        double[] evals = new double[lightgbmlib.intp_value(outLength)];
        for (int i = 0; i < evals.length; ++i) {
            evals[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
        }
        lightgbmlib.delete_intp(outLength);
        lightgbmlib.delete_doubleArray(outBuffer);
        return evals;
    }

    public String[] getEvalNames() throws LGBMException {
        SWIGTYPE_p_void namesP = lightgbmlib.LGBM_BoosterGetEvalNamesSWIG(lightgbmlib.voidpp_value(this.handle));
        String[] names = lightgbmlib.StringArrayHandle_get_strings(namesP);
        lightgbmlib.StringArrayHandle_free(namesP);
        return names;
    }

    public double[] featureImportance(int numIteration, FeatureImportanceType importanceType) throws LGBMException {
        int numFeatures = this.getNumFeature();
        SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(numFeatures);
        int result = lightgbmlib.LGBM_BoosterFeatureImportance(lightgbmlib.voidpp_value(this.handle), numIteration, this.importanceType(importanceType), outBuffer);
        if (result < 0) {
            lightgbmlib.delete_doubleArray(outBuffer);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        double[] importance = new double[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            importance[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
        }
        lightgbmlib.delete_doubleArray(outBuffer);
        return importance;
    }

    public int getNumFeature() throws LGBMException {
        SWIGTYPE_p_int outNum = lightgbmlib.new_int32_tp();
        int result = lightgbmlib.LGBM_BoosterGetNumFeature(lightgbmlib.voidpp_value(this.handle), outNum);
        if (result < 0) {
            lightgbmlib.delete_intp(outNum);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        int num = lightgbmlib.intp_value(outNum);
        lightgbmlib.delete_intp(outNum);
        return num;
    }

    public double predictForMatSingleRow(double[] data, PredictionType predictionType) throws LGBMException {
        SWIGTYPE_p_double dataBuffer = lightgbmlib.new_doubleArray(data.length);
        for (int i = 0; i < data.length; ++i) {
            lightgbmlib.doubleArray_setitem(dataBuffer, i, data[i]);
        }
        SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
        long outBufferSize = this.outBufferSize(1, data.length, predictionType);
        SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outBufferSize);
        int result = lightgbmlib.LGBM_BoosterPredictForMatSingleRow(lightgbmlib.voidpp_value(this.handle), lightgbmlib.double_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT64, data.length, 1, predictionType.getType(), 0, this.iterations, "", outLength, outBuffer);
        if (result < 0) {
            lightgbmlib.delete_doubleArray(dataBuffer);
            lightgbmlib.delete_doubleArray(outBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        long length = lightgbmlib.int64_tp_value(outLength);
        double[] values = new double[(int)length];
        int i = 0;
        while ((long)i < length) {
            values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
            ++i;
        }
        lightgbmlib.delete_doubleArray(dataBuffer);
        lightgbmlib.delete_int64_tp(outLength);
        lightgbmlib.delete_doubleArray(outBuffer);
        return values[0];
    }

    public double predictForMatSingleRow(float[] data, PredictionType predictionType) throws LGBMException {
        SWIGTYPE_p_float dataBuffer = lightgbmlib.new_floatArray(data.length);
        for (int i = 0; i < data.length; ++i) {
            lightgbmlib.floatArray_setitem(dataBuffer, i, data[i]);
        }
        SWIGTYPE_p_long_long outLength = lightgbmlib.new_int64_tp();
        long outBufferSize = this.outBufferSize(1, data.length, predictionType);
        SWIGTYPE_p_double outBuffer = lightgbmlib.new_doubleArray(outBufferSize);
        int result = lightgbmlib.LGBM_BoosterPredictForMatSingleRow(lightgbmlib.voidpp_value(this.handle), lightgbmlib.float_to_voidp_ptr(dataBuffer), lightgbmlib.C_API_DTYPE_FLOAT32, data.length, 1, predictionType.getType(), 0, this.iterations, "", outLength, outBuffer);
        if (result < 0) {
            lightgbmlib.delete_floatArray(dataBuffer);
            lightgbmlib.delete_doubleArray(outBuffer);
            lightgbmlib.delete_int64_tp(outLength);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        long length = lightgbmlib.int64_tp_value(outLength);
        double[] values = new double[(int)length];
        int i = 0;
        while ((long)i < length) {
            values[i] = lightgbmlib.doubleArray_getitem(outBuffer, i);
            ++i;
        }
        lightgbmlib.delete_floatArray(dataBuffer);
        lightgbmlib.delete_int64_tp(outLength);
        lightgbmlib.delete_doubleArray(outBuffer);
        return values[0];
    }

    private int importanceType(FeatureImportanceType tpe) {
        int importanceType = lightgbmlib.C_API_FEATURE_IMPORTANCE_GAIN;
        switch (tpe) {
            case GAIN: {
                importanceType = lightgbmlib.C_API_FEATURE_IMPORTANCE_GAIN;
                break;
            }
            case SPLIT: {
                importanceType = lightgbmlib.C_API_FEATURE_IMPORTANCE_SPLIT;
            }
        }
        return importanceType;
    }

    public int getNumClasses() throws LGBMException {
        SWIGTYPE_p_int numHandle = lightgbmlib.new_int32_tp();
        int result = lightgbmlib.LGBM_BoosterGetNumClasses(lightgbmlib.voidpp_value(this.handle), numHandle);
        if (result < 0) {
            lightgbmlib.delete_intp(numHandle);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        int numClasses = lightgbmlib.intp_value(numHandle);
        lightgbmlib.delete_intp(numHandle);
        return numClasses;
    }

    public long getNumPredict(int dataIdx) throws LGBMException {
        SWIGTYPE_p_long_long numHandle = lightgbmlib.new_int64_tp();
        int result = lightgbmlib.LGBM_BoosterGetNumPredict(lightgbmlib.voidpp_value(this.handle), dataIdx, numHandle);
        if (result < 0) {
            lightgbmlib.delete_int64_tp(numHandle);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        long numClasses = lightgbmlib.int64_tp_value(numHandle);
        lightgbmlib.delete_int64_tp(numHandle);
        return numClasses;
    }

    public double[] getPredict(int dataIdx) throws LGBMException {
        int allocatedSize = this.getNumClasses() * (int)this.getNumPredict(dataIdx);
        SWIGTYPE_p_double buffer = lightgbmlib.new_doubleArray(allocatedSize);
        SWIGTYPE_p_long_long size = lightgbmlib.new_int64_tp();
        int result = lightgbmlib.LGBM_BoosterGetPredict(lightgbmlib.voidpp_value(this.handle), dataIdx, size, buffer);
        if (result < 0) {
            lightgbmlib.delete_doubleArray(buffer);
            lightgbmlib.delete_int64_tp(size);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        double[] out = new double[(int)lightgbmlib.int64_tp_value(size)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = lightgbmlib.doubleArray_getitem(buffer, i);
        }
        lightgbmlib.delete_doubleArray(buffer);
        lightgbmlib.delete_int64_tp(size);
        return out;
    }

    public boolean updateOneIterCustom(float[] grad, float[] hess) throws LGBMException {
        SWIGTYPE_p_float gradHandle = lightgbmlib.new_floatArray(grad.length);
        for (int i = 0; i < grad.length; ++i) {
            lightgbmlib.floatArray_setitem(gradHandle, i, grad[i]);
        }
        SWIGTYPE_p_float hessHandle = lightgbmlib.new_floatArray(hess.length);
        for (int i = 0; i < hess.length; ++i) {
            lightgbmlib.floatArray_setitem(hessHandle, i, hess[i]);
        }
        SWIGTYPE_p_int isFinishedHandle = lightgbmlib.new_intp();
        int result = lightgbmlib.LGBM_BoosterUpdateOneIterCustom(lightgbmlib.voidpp_value(this.handle), gradHandle, hessHandle, isFinishedHandle);
        if (result < 0) {
            lightgbmlib.delete_floatArray(gradHandle);
            lightgbmlib.delete_floatArray(hessHandle);
            lightgbmlib.delete_intp(isFinishedHandle);
            throw new LGBMException(lightgbmlib.LGBM_GetLastError());
        }
        int isFinished = lightgbmlib.intp_value(isFinishedHandle);
        lightgbmlib.delete_floatArray(gradHandle);
        lightgbmlib.delete_floatArray(hessHandle);
        lightgbmlib.delete_intp(isFinishedHandle);
        return isFinished == 1;
    }

    private long outBufferSize(int rows, int cols, PredictionType predictionType) {
        long defaultSize = 2L * (long)rows;
        if (PredictionType.C_API_PREDICT_CONTRIB.equals(predictionType)) {
            return defaultSize * (long)(cols + 1);
        }
        if (PredictionType.C_API_PREDICT_LEAF_INDEX.equals(predictionType)) {
            return defaultSize * (long)this.iterations;
        }
        return defaultSize;
    }

    static {
        try {
            LGBMBooster.loadNative();
        }
        catch (IOException e) {
            System.out.println("Cannot load native library for your platform");
        }
    }

    public static enum FeatureImportanceType {
        SPLIT,
        GAIN;

    }
}

