/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.titlepane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import mdlaf.components.button.MaterialButtonUI;
import mdlaf.utils.MaterialManagerListener;
import sun.awt.SunToolkit;
import sun.swing.SwingUtilities2;

public class MaterialTitlePaneUI
extends JComponent {
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener myPropertyChangeListener;
    private Action myCloseAction;
    private Action myIconifyAction;
    private Action myRestoreAction;
    private Action myMaximizeAction;
    private JButton myToggleButton;
    private JButton myIconifyButton;
    private JButton myCloseButton;
    private Icon myMaximizeIcon;
    private Icon myMinimizeIcon;
    private Image mySystemIcon;
    private WindowListener myWindowListener;
    private Window myWindow;
    private JRootPane myRootPane;
    private int myState;
    private Color myInactiveBackground = UIManager.getColor("Material.inactiveCaption");
    private Color myInactiveForeground = UIManager.getColor("Material.inactiveCaptionText");
    private Color myInactiveShadow = UIManager.getColor("Material.inactiveCaptionBorder");
    private Color myActiveBackground = null;
    private Color myActiveForeground = null;
    private Color myActiveShadow = null;

    public MaterialTitlePaneUI(JRootPane root) {
        this.myRootPane = root;
        this.myState = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    protected void uninstall() {
        this.uninstallListeners();
        this.myWindow = null;
        this.removeAll();
    }

    protected void installListeners() {
        if (this.myWindow != null) {
            this.myWindowListener = this.createWindowListener();
            this.myWindow.addWindowListener(this.myWindowListener);
            this.myPropertyChangeListener = this.createWindowPropertyChangeListener();
            this.myWindow.addPropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.myWindow != null) {
            this.myWindow.removeWindowListener(this.myWindowListener);
            this.myWindow.removePropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    protected WindowListener createWindowListener() {
        return new WindowHandler();
    }

    protected PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.myRootPane;
    }

    protected int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.myWindow = SwingUtilities.getWindowAncestor(this);
        if (this.myWindow != null) {
            if (this.myWindow instanceof Frame) {
                this.setState(((Frame)this.myWindow).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.myWindow.isActive());
            this.installListeners();
            this.updateSystemIcon();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.myWindow = null;
    }

    protected void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.createButtons();
            this.add(this.myIconifyButton);
            this.add(this.myToggleButton);
            this.add(this.myCloseButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.initMaterialButtonClose();
            this.myCloseButton.setFocusable(false);
            this.myCloseButton.setVisible(true);
            this.add(this.myCloseButton);
        }
    }

    protected void initMaterialButtonClose() {
        MaterialManagerListener.removeAllMaterialMouseListener(this.myCloseButton);
        this.myCloseButton.setBackground(UIManager.getColor("OptionPane.errorDialog.titlePane.background"));
        this.myCloseButton.setAction(this.myCloseAction);
    }

    protected void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.myActiveBackground = UIManager.getColor("Material.activeCaption");
                this.myActiveForeground = UIManager.getColor("Material.activeCaptionText");
                this.myActiveShadow = UIManager.getColor("Material.activeCaptionBorder");
                break;
            }
            case 4: {
                this.myActiveBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.myActiveForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 7: {
                this.myActiveBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.myActiveForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 5: {
                this.myActiveBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.myActiveForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 6: {
                this.myActiveBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.myActiveForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.myActiveShadow = this.myActiveBackground;
                break;
            }
            case 8: {
                this.myActiveBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.myActiveForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            case 2: {
                this.myActiveBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.myActiveForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 3: {
                this.myActiveBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.myActiveForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            default: {
                this.myActiveBackground = UIManager.getColor("Material.activeCaption");
                this.myActiveForeground = UIManager.getColor("Material.activeCaptionText");
                this.myActiveShadow = UIManager.getColor("Material.activeCaptionBorder");
            }
        }
    }

    protected void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    protected void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myState | 1);
        }
    }

    protected void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myState | 6);
        }
    }

    protected void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.myState & 1) != 0) {
            frame.setExtendedState(this.myState & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.myState & 0xFFFFFFF9);
        }
    }

    protected void createActions() {
        this.myCloseAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.myIconifyAction = new IconifyAction();
            this.myRestoreAction = new RestoreAction();
            this.myMaximizeAction = new MaximizeAction();
        }
    }

    protected JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    protected void addMenuItems(JMenu menu) {
        menu.add(this.myRestoreAction);
        menu.add(this.myIconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.myMaximizeAction);
        }
        menu.add(new JSeparator());
        menu.add(this.myCloseAction);
    }

    protected static JButton createButton(String accessibleName, Icon icon, Action action) {
        JButtonNoMouseHoverNative button = new JButtonNoMouseHoverNative();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        button.putClientProperty("paintActive", Boolean.TRUE);
        button.putClientProperty("AccessibleName", accessibleName);
        button.setBorder(new EmptyBorder(0, 0, 0, 0));
        button.setText(null);
        button.setAction(action);
        button.setIcon(icon);
        return button;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getWindowDecorationStyle() == 1) {
            this.myMaximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.myMinimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
            Icon iconClose = UIManager.getIcon("InternalFrame.closeIcon");
            this.myCloseButton.setIcon(iconClose);
            this.myIconifyButton.setIcon(this.myMinimizeIcon);
            this.myToggleButton.setIcon(this.myMaximizeIcon);
        }
    }

    protected void createButtons() {
        this.myCloseButton = MaterialTitlePaneUI.createButton("Close", UIManager.getIcon("InternalFrame.closeIcon"), this.myCloseAction);
        if (this.getWindowDecorationStyle() == 1) {
            this.myMaximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.myMinimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
            this.myIconifyButton = MaterialTitlePaneUI.createButton("Iconify", UIManager.getIcon("InternalFrame.iconifyIcon"), this.myIconifyAction);
            this.myToggleButton = MaterialTitlePaneUI.createButton("Maximize", this.myMaximizeIcon, this.myRestoreAction);
            this.myCloseButton.setBackground(this.myActiveBackground);
            this.myIconifyButton.setBackground(this.myActiveBackground);
            this.myToggleButton.setBackground(this.myActiveBackground);
        }
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected void setActive(boolean active) {
        this.myCloseButton.putClientProperty("paintActive", active);
        if (this.getWindowDecorationStyle() == 1) {
            this.myIconifyButton.putClientProperty("paintActive", active);
            this.myToggleButton.putClientProperty("paintActive", active);
        }
        this.getRootPane().repaint();
    }

    protected void setState(int state) {
        this.setState(state, false);
    }

    protected void setState(int state, boolean updateRegardless) {
        Window wnd = this.getWindow();
        if (wnd != null && this.getWindowDecorationStyle() == 1) {
            if (this.myState == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    // empty if block
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.myRestoreAction, this.myMinimizeIcon);
                        this.myMaximizeAction.setEnabled(false);
                        this.myRestoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.myMaximizeAction, this.myMaximizeIcon);
                        this.myMaximizeAction.setEnabled(true);
                        this.myRestoreAction.setEnabled(false);
                    }
                    if (this.myToggleButton.getParent() == null || this.myIconifyButton.getParent() == null) {
                        this.add(this.myToggleButton);
                        this.add(this.myIconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.myToggleButton.setText(null);
                } else {
                    this.myMaximizeAction.setEnabled(false);
                    this.myRestoreAction.setEnabled(false);
                    if (this.myToggleButton.getParent() != null) {
                        this.remove(this.myToggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.myMaximizeAction.setEnabled(false);
                this.myRestoreAction.setEnabled(false);
                this.myIconifyAction.setEnabled(false);
                this.remove(this.myToggleButton);
                this.remove(this.myIconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.myCloseAction.setEnabled(true);
            this.myState = state;
        }
    }

    protected void updateToggleButton(Action action, Icon icon) {
        this.myToggleButton.setAction(action);
        this.myToggleButton.setIcon(icon);
        this.myToggleButton.setText(null);
    }

    protected Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    protected Window getWindow() {
        return this.myWindow;
    }

    protected String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        String theTitle;
        int xOffset;
        Color darkShadow;
        Color foreground;
        Color background;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean isSelected = window == null ? true : window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        if (isSelected) {
            background = this.myActiveBackground;
            foreground = this.myActiveForeground;
            darkShadow = this.myActiveShadow;
        } else {
            background = this.myInactiveBackground;
            foreground = this.myInactiveForeground;
            darkShadow = this.myInactiveShadow;
        }
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        g.setColor(darkShadow);
        g.drawLine(0, height - 1, width, height - 1);
        g.drawLine(0, 0, 0, 0);
        g.drawLine(width - 1, 0, width - 1, 0);
        int n = xOffset = leftToRight ? 5 : width - 5;
        if (this.getWindowDecorationStyle() == 1) {
            xOffset += leftToRight ? 21 : -21;
        }
        if ((theTitle = this.getTitle()) != null) {
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)rootPane, g);
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.myIconifyButton != null && this.myIconifyButton.getParent() != null) {
                rect = this.myIconifyButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = window.getWidth() - window.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                theTitle = SwingUtilities2.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                theTitle = SwingUtilities2.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
                xOffset -= SwingUtilities2.stringWidth(rootPane, fm, theTitle);
            }
            int titleLength = SwingUtilities2.stringWidth(rootPane, fm, theTitle);
            SwingUtilities2.drawString((JComponent)rootPane, g, theTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
    }

    protected void updateSystemIcon() {
        Window window = this.getWindow();
        if (window == null) {
            this.mySystemIcon = null;
            return;
        }
        List<Image> icons = window.getIconImages();
        assert (icons != null);
        this.mySystemIcon = icons.size() == 0 ? null : (icons.size() == 1 ? icons.get(0) : SunToolkit.getScaledIconImage(icons, 16, 16));
    }

    protected static class JButtonNoMouseHoverNative
    extends JButton {
        public JButtonNoMouseHoverNative() {
        }

        public JButtonNoMouseHoverNative(Icon icon) {
            super(icon);
        }

        public JButtonNoMouseHoverNative(String text) {
            super(text);
        }

        public JButtonNoMouseHoverNative(Action a) {
            super(a);
        }

        public JButtonNoMouseHoverNative(String text, Icon icon) {
            super(text, icon);
        }

        @Override
        protected void init(String text, Icon icon) {
            super.init(text, icon);
            this.setUI(new JButtonNoMouseHoverUI());
        }

        private static class JButtonNoMouseHoverUI
        extends MaterialButtonUI {
            private JButtonNoMouseHoverUI() {
            }

            @Override
            public void installUI(JComponent c) {
                this.mouseHoverEnabled = false;
                super.installUI(c);
                c.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            protected void paintButtonPressed(Graphics g, AbstractButton b) {
            }

            @Override
            protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            MaterialTitlePaneUI.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            MaterialTitlePaneUI.this.setActive(false);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = MaterialTitlePaneUI.this.getFrame();
                if (frame != null) {
                    MaterialTitlePaneUI.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    MaterialTitlePaneUI.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                MaterialTitlePaneUI.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                MaterialTitlePaneUI.this.revalidate();
                MaterialTitlePaneUI.this.repaint();
            } else if ("iconImage".equals(name)) {
                MaterialTitlePaneUI.this.updateSystemIcon();
                MaterialTitlePaneUI.this.revalidate();
                MaterialTitlePaneUI.this.repaint();
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            FontMetrics fm = MaterialTitlePaneUI.this.myRootPane.getFontMetrics(MaterialTitlePaneUI.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (MaterialTitlePaneUI.this.getWindowDecorationStyle() == 1) {
                iconHeight = 16;
            }
            return Math.max(fontHeight, iconHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = MaterialTitlePaneUI.this.myWindow == null ? MaterialTitlePaneUI.this.getRootPane().getComponentOrientation().isLeftToRight() : MaterialTitlePaneUI.this.myWindow.getComponentOrientation().isLeftToRight();
            int w = MaterialTitlePaneUI.this.getWidth();
            int y = 3;
            if (MaterialTitlePaneUI.this.myCloseButton != null && MaterialTitlePaneUI.this.myCloseButton.getIcon() != null) {
                buttonHeight = MaterialTitlePaneUI.this.myCloseButton.getIcon().getIconHeight();
                buttonWidth = MaterialTitlePaneUI.this.myCloseButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int x = leftToRight ? w : 0;
            int spacing = 5;
            x = leftToRight ? spacing : w - buttonWidth - spacing;
            x = leftToRight ? w : 0;
            spacing = 4;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (MaterialTitlePaneUI.this.myCloseButton != null) {
                MaterialTitlePaneUI.this.myCloseButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (MaterialTitlePaneUI.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && MaterialTitlePaneUI.this.myToggleButton.getParent() != null) {
                    spacing = 10;
                    MaterialTitlePaneUI.this.myToggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (MaterialTitlePaneUI.this.myIconifyButton != null && MaterialTitlePaneUI.this.myIconifyButton.getParent() != null) {
                    spacing = 2;
                    MaterialTitlePaneUI.this.myIconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MaterialTitlePane.maximizeTitle", MaterialTitlePaneUI.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MaterialTitlePaneUI.this.maximize();
        }
    }

    protected class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MaterialTitlePane.restoreTitle", MaterialTitlePaneUI.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MaterialTitlePaneUI.this.restore();
        }
    }

    protected class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MaterialTitlePane.iconifyTitle", MaterialTitlePaneUI.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MaterialTitlePaneUI.this.iconify();
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MaterialTitlePane.closeTitle", MaterialTitlePaneUI.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MaterialTitlePaneUI.this.close();
        }
    }
}

