/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.togglebutton;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import mdlaf.utils.MaterialDrawingUtils;
import sun.swing.SwingUtilities2;

public class MaterialToggleButtonUI
extends BasicToggleButtonUI {
    protected Boolean withoutIcon;
    protected Integer widthWithoutIcon;
    protected Integer heightWithoutIcon;
    protected Integer originalWidth;
    protected Integer originalHeight;
    protected JToggleButton toggleButton;
    protected Color withoutIconSelectedBackground;
    protected Color withoutIconSelectedForeground;
    protected Color withoutIconBackground;
    protected Color withoutIconForeground;
    protected Border withoutIconSelectedBorder;
    protected Border withoutIconBorder;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialToggleButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.toggleButton = (JToggleButton)c;
        this.toggleButton.setFont(UIManager.getFont("ToggleButton.font"));
        this.toggleButton.setBackground(UIManager.getColor("ToggleButton.background"));
        this.toggleButton.setForeground(UIManager.getColor("ToggleButton.foreground"));
        c.setCursor(Cursor.getPredefinedCursor(12));
        if (this.toggleButton.getIcon() == null && this.toggleButton.getSelectedIcon() == null) {
            this.toggleButton.setIcon(UIManager.getIcon("ToggleButton.icon"));
            this.toggleButton.setSelectedIcon(UIManager.getIcon("ToggleButton.selectedIcon"));
            this.withoutIcon = UIManager.getBoolean("ToggleButton.withoutIcon");
            if (this.withoutIcon.booleanValue()) {
                this.withoutIconSelectedBorder = UIManager.getBorder("ToggleButton[withoutIcon].selectedBorder");
                this.withoutIconBorder = UIManager.getBorder("ToggleButton[withoutIcon].border");
                this.withoutIconSelectedBackground = UIManager.getColor("ToggleButton[withoutIcon].selectedBackground");
                this.withoutIconSelectedForeground = UIManager.getColor("ToggleButton[withoutIcon].selectedForeground");
                this.withoutIconBackground = UIManager.getColor("ToggleButton[withoutIcon].background");
                this.withoutIconForeground = UIManager.getColor("ToggleButton[withoutIcon].foreground");
                if (this.toggleButton.isSelected()) {
                    this.toggleButton.setBorder(this.withoutIconSelectedBorder);
                } else {
                    this.toggleButton.setBorder(this.withoutIconBorder);
                }
            } else {
                this.toggleButton.setBorder(UIManager.getBorder("ToggleButton.border"));
            }
        } else {
            this.toggleButton.setBorder(UIManager.getBorder("ToggleButton.border"));
            this.withoutIcon = Boolean.FALSE;
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        JToggleButton toggleButton = (JToggleButton)c;
        toggleButton.setIcon(null);
        toggleButton.setSelectedIcon(null);
        toggleButton.setBorder(null);
        toggleButton.setBackground(null);
        toggleButton.setForeground(null);
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g), c);
        if (this.withoutIcon != null && this.withoutIcon.booleanValue() && this.isNotNullColor(this.withoutIcon)) {
            AbstractButton button = (AbstractButton)c;
            if (button.isSelected()) {
                button.setBackground(this.withoutIconSelectedBackground);
                button.setForeground(this.withoutIconSelectedForeground);
                button.setBorder(this.withoutIconSelectedBorder);
            } else {
                button.setBackground(this.withoutIconBackground);
                button.setForeground(this.withoutIconForeground);
                button.setBorder(this.withoutIconBorder);
            }
        }
    }

    private boolean isNotNullColor(boolean withoutIcon) {
        if (withoutIcon) {
            boolean selectedColorNotNull = this.withoutIconSelectedBackground != null && this.withoutIconSelectedForeground != null;
            boolean unselectColorNotNull = this.withoutIconBackground != null && this.withoutIconForeground != null;
            boolean borderNotNull = this.withoutIconBorder != null && this.withoutIconSelectedBorder != null;
            return selectedColorNotNull && unselectColorNotNull && borderNotNull;
        }
        return true;
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(UIManager.getColor("ToggleButton.disabledText").brighter());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(UIManager.getColor("ToggleButton.disabledText").darker());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }
}

