/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.themes;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import jiconfont.IconCode;
import jiconfont.icons.google_material_design_icons.GoogleMaterialDesignIcons;
import mdlaf.themes.AbstractMaterialTheme;
import mdlaf.utils.MaterialBorders;
import mdlaf.utils.MaterialColors;
import mdlaf.utils.MaterialFontFactory;
import mdlaf.utils.MaterialImageFactory;

public class JMarsDarkTheme
extends AbstractMaterialTheme {
    @Override
    public void installTheme() {
        this.installColor();
        this.installFonts();
        this.installBorders();
        this.installIcons();
    }

    @Override
    protected void installFonts() {
        this.fontBold = MaterialFontFactory.getInstance().getFont("BOLD");
        this.fontItalic = MaterialFontFactory.getInstance().getFont("ITALIC");
        this.fontMedium = MaterialFontFactory.getInstance().getFont("MEDIUM");
        this.fontRegular = MaterialFontFactory.getInstance().getFont("REGULAR");
    }

    @Override
    protected void installIcons() {
        this.selectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.CHECK_BOX, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.CHECK_BOX_OUTLINE_BLANK, MaterialColors.WHITE);
        this.selectedRadioButtonIcon = MaterialImageFactory.getInstance().getImage("white/radio-checked-white");
        this.unselectedRadioButtonIcon = MaterialImageFactory.getInstance().getImage("white/radio_unchecked-white");
        this.selectedCheckBoxIconTable = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.CHECK_BOX, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIconTable = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.CHECK_BOX_OUTLINE_BLANK, this.highlightBackgroundPrimary);
        this.selectedCheckBoxIconSelectionRowTable = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.CHECK_BOX, MaterialColors.BLACK);
        this.unselectedCheckBoxIconSelectionRowTable = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.CHECK_BOX_OUTLINE_BLANK, MaterialColors.BLACK);
        this.closedIconTree = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.KEYBOARD_ARROW_RIGHT, MaterialColors.WHITE);
        this.openIconTree = MaterialImageFactory.getInstance().getImage((IconCode)GoogleMaterialDesignIcons.KEYBOARD_ARROW_DOWN, this.highlightBackgroundPrimary);
        this.noCollapsedTaskPane = MaterialImageFactory.getInstance().getImage(GoogleMaterialDesignIcons.KEYBOARD_ARROW_RIGHT);
        this.yesCollapsedTaskPane = MaterialImageFactory.getInstance().getImage(GoogleMaterialDesignIcons.KEYBOARD_ARROW_DOWN);
        this.warningIconOptionPane = MaterialImageFactory.getInstance().getImage("warning");
        this.errorIconIconOptionPane = MaterialImageFactory.getInstance().getImage("error");
        this.questionIconOptionPane = MaterialImageFactory.getInstance().getImage("question");
        this.informationIconOptionPane = MaterialImageFactory.getInstance().getImage("information");
        this.iconComputerFileChooser = MaterialImageFactory.getInstance().getImage("white/computer");
        this.iconDirectoryFileChooser = MaterialImageFactory.getInstance().getImage("white/folder");
        this.iconFileFileChooser = MaterialImageFactory.getInstance().getImage("white/file");
        this.iconFloppyDriveFileChooser = MaterialImageFactory.getInstance().getImage("white/floppy_drive");
        this.iconHardDriveFileChooser = MaterialImageFactory.getInstance().getImage("white/hard_drive");
        this.iconHomeFileChooser = MaterialImageFactory.getInstance().getImage("white/home");
        this.iconListFileChooser = MaterialImageFactory.getInstance().getImage("white/list");
        this.iconDetailsFileChooser = MaterialImageFactory.getInstance().getImage("white/details");
        this.iconNewFolderFileChooser = MaterialImageFactory.getInstance().getImage("white/new_folder");
        this.iconUpFolderFileChooser = MaterialImageFactory.getInstance().getImage("white/back_arrow");
        this.unselectedIconToggleButton = MaterialImageFactory.getInstance().getImage("white/toggle_off");
        this.selectedIconToggleButton = MaterialImageFactory.getInstance().getImage("white/toggle_on");
        this.iconCloseTitlePane = MaterialImageFactory.getInstance().getImage("white/close-button");
    }

    @Override
    protected void installBorders() {
        super.installBorders();
        this.borderMenuBar = new BorderUIResource(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(225, 156, 43)));
        this.borderPopupMenu = new BorderUIResource(BorderFactory.createLineBorder(this.backgroundPrimary));
        this.borderSpinner = new BorderUIResource(BorderFactory.createLineBorder(this.backgroundTextField));
        this.borderSlider = new BorderUIResource(BorderFactory.createCompoundBorder(this.borderSpinner, BorderFactory.createEmptyBorder(15, 15, 15, 15)));
        this.cellBorderTableHeader = new BorderUIResource(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.backgroundTableHeader), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.borderToolBar = this.borderSpinner;
        this.borderDialogRootPane = this.borderSpinner;
        this.borderProgressBar = this.borderSpinner;
        this.borderComboBox = MaterialBorders.roundedLineColorBorder(MaterialColors.WHITE, 12);
        this.borderTable = this.borderSpinner;
        this.borderTableHeader = this.borderSpinner;
        this.borderTitledBorder = new BorderUIResource(BorderFactory.createLineBorder(MaterialColors.WHITE));
    }

    @Override
    protected void installColor() {
        this.backgroundPrimary = new ColorUIResource(45, 48, 56);
        this.highlightBackgroundPrimary = new ColorUIResource(66, 179, 176);
        this.textColor = new ColorUIResource(255, 255, 255);
        this.disableTextColor = new ColorUIResource(170, 170, 170);
        this.buttonBackgroundColor = new ColorUIResource(45, 48, 56);
        this.buttonBackgroundColorMouseHover = new ColorUIResource(81, 86, 101);
        this.buttonTextColor = MaterialColors.WHITE;
        this.buttonDefaultBackgroundColorMouseHover = new ColorUIResource(23, 137, 134);
        this.buttonDefaultBackgroundColor = new ColorUIResource(66, 179, 176);
        this.buttonDefaultTextColor = MaterialColors.WHITE;
        this.buttonDisabledBackground = new ColorUIResource(66, 69, 76);
        this.buttonDisabledForeground = MaterialColors.GRAY_500;
        this.buttonFocusColor = MaterialColors.WHITE;
        this.buttonDefaultFocusColor = MaterialColors.BLACK;
        this.buttonBorderColor = MaterialColors.WHITE;
        this.buttonColorHighlight = this.buttonBackgroundColorMouseHover;
        this.selectedInDropDownBackgroundComboBox = new ColorUIResource(249, 192, 98);
        this.selectedForegroundComboBox = MaterialColors.BLACK;
        this.menuBackground = this.backgroundPrimary;
        this.menuBackgroundMouseHover = this.buttonBackgroundColorMouseHover;
        this.menuTextColor = MaterialColors.WHITE;
        this.menuDisableBackground = MaterialColors.TRANSPANENT;
        this.arrowButtonColorScrollBar = this.buttonBackgroundColor;
        this.trackColorScrollBar = new ColorUIResource(81, 86, 101);
        this.thumbDarkShadowColorScrollBar = this.thumbColorScrollBar = new ColorUIResource(155, 155, 155);
        this.thumbHighlightColorScrollBar = this.thumbColorScrollBar;
        this.thumbShadowColorScrollBar = this.thumbColorScrollBar;
        this.arrowButtonOnClickColorScrollBar = this.buttonBackgroundColorMouseHover;
        this.mouseHoverColorScrollBar = this.thumbColorScrollBar;
        this.trackColorSlider = new ColorUIResource(119, 119, 119);
        this.haloColorSlider = MaterialColors.bleach(new Color(249, 192, 98), 0.2f);
        this.highlightColorTabbedPane = new ColorUIResource(45, 48, 56);
        this.borderHighlightColorTabbedPane = new ColorUIResource(45, 48, 56);
        this.focusColorLineTabbedPane = new ColorUIResource(249, 192, 98);
        this.disableColorTabTabbedPane = new ColorUIResource(170, 170, 170);
        this.backgroundTable = new ColorUIResource(45, 48, 56);
        this.backgroundTableHeader = new ColorUIResource(66, 179, 176);
        this.foregroundTable = this.textColor;
        this.foregroundTableHeader = this.textColor;
        this.selectionBackgroundTable = new ColorUIResource(126, 132, 153);
        this.selectionForegroundTable = this.textColor;
        this.gridColorTable = new ColorUIResource(151, 151, 151);
        this.alternateRowBackgroundTable = new ColorUIResource(59, 62, 69);
        this.dockingBackgroundToolBar = MaterialColors.LIGHT_GREEN_A100;
        this.floatingBackgroundToolBar = MaterialColors.GRAY_200;
        this.selectionBackgroundTree = this.backgroundPrimary;
        this.selectionBorderColorTree = this.backgroundPrimary;
        this.backgroundTextField = new ColorUIResource(81, 86, 101);
        this.inactiveForegroundTextField = MaterialColors.WHITE;
        this.inactiveBackgroundTextField = new ColorUIResource(81, 86, 101);
        this.selectionBackgroundTextField = new ColorUIResource(249, 192, 98);
        this.disabledBackgroudnTextField = new ColorUIResource(81, 86, 101);
        this.disabledForegroundTextField = new ColorUIResource(170, 170, 170);
        this.selectionForegroundTextField = MaterialColors.BLACK;
        this.inactiveColorLineTextField = MaterialColors.WHITE;
        this.activeColorLineTextField = new ColorUIResource(249, 192, 98);
        this.arrowButtonBackgroundSpinner = this.backgroundTextField;
        this.mouseHoverButtonColorSpinner = this.backgroundPrimary;
        this.titleBackgroundGradientStartTaskPane = MaterialColors.GRAY_300;
        this.titleBackgroundGradientEndTaskPane = MaterialColors.GRAY_500;
        this.titleOverTaskPane = MaterialColors.WHITE;
        this.specialTitleOverTaskPane = MaterialColors.WHITE;
        this.borderColorTaskPane = this.backgroundTaskPane = this.backgroundPrimary;
        this.contentBackgroundTaskPane = this.backgroundPrimary;
        this.selectionBackgroundList = new ColorUIResource(249, 192, 98);
        this.selectionForegroundList = MaterialColors.BLACK;
        this.backgroundProgressBar = new ColorUIResource(81, 86, 101);
        this.foregroundProgressBar = MaterialColors.WHITE;
        this.withoutIconSelectedBackgroundToggleButton = this.highlightBackgroundPrimary;
        this.withoutIconSelectedForegoundToggleButton = MaterialColors.BLACK;
        this.withoutIconBackgroundToggleButton = this.backgroundPrimary;
        this.withoutIconForegroundToggleButton = MaterialColors.WHITE;
        this.colorDividierSplitPane = MaterialColors.COSMO_DARK_GRAY;
        this.colorDividierFocusSplitPane = new ColorUIResource(249, 192, 98);
        this.colorTextTitledBorder = this.textColor;
        this.backgroundSeparator = MaterialColors.GRAY_300;
        this.foregroundSeparator = MaterialColors.GRAY_300;
    }

    @Override
    public void installUIDefault(UIDefaults table) {
        super.installUIDefault(table);
    }

    @Override
    public String getName() {
        return "JMars Dark";
    }
}

