/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.utils;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.plaf.FontUIResource;

public class MaterialFontFactory {
    private static final String[] SISTEM_SUPPORTED = new String[]{"linux", "windows", "mac"};
    private static final Map<TextAttribute, Object> fontSettings = new HashMap<TextAttribute, Object>();
    public static final String REGULAR = "REGULAR";
    public static final String BOLD = "BOLD";
    public static final String ITALIC = "ITALIC";
    public static final String MEDIUM = "MEDIUM";
    public static final String EMOJI = "EMOJI";
    private static MaterialFontFactory SINGLETON;
    private Properties properties = new Properties();
    private Map<String, Font> cacheFont = new HashMap<String, Font>();

    public static MaterialFontFactory getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new MaterialFontFactory();
        }
        return SINGLETON;
    }

    public static Font fontUtilsDisplayable(String textDisplayable, Font withFont) {
        if (textDisplayable == null || withFont == null) {
            throw new IllegalArgumentException("Argument at the fontUtilsDisplayable function are/is null");
        }
        if (withFont.canDisplayUpTo(textDisplayable) < 0) {
            return withFont;
        }
        return new FontUIResource("SansSerif", withFont.getStyle(), withFont.getSize());
    }

    private MaterialFontFactory() {
        try {
            this.loadOsPropries();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadOsPropries() throws IOException {
        this.properties.load(this.getClass().getResourceAsStream("/config/font-all-language.properties"));
    }

    public FontUIResource getFont(String typeFont) {
        if (typeFont == null) {
            throw new IllegalArgumentException("Argument null");
        }
        if (this.cacheFont.containsKey(typeFont)) {
            return new FontUIResource(this.cacheFont.get(typeFont));
        }
        String propieties = this.properties.getProperty(typeFont);
        Font font = this.loadFont(propieties);
        this.cacheFont.put(typeFont, font);
        return new FontUIResource(this.cacheFont.get(typeFont));
    }

    private Font loadFont(String fontPath) {
        if (fontSettings.isEmpty()) {
            fontSettings.put(TextAttribute.SIZE, new Float((double)(11 * Toolkit.getDefaultToolkit().getScreenResolution()) / 72.0));
            fontSettings.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        }
        try {
            Font font = Font.createFont(0, this.getClass().getResourceAsStream(fontPath)).deriveFont(fontSettings);
            return font;
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Font " + fontPath + " wasn't loaded");
        }
    }
}

