/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.distribution;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.NoopHistogram;
import io.micrometer.core.instrument.distribution.TimeWindowHistogramBase;
import io.micrometer.core.instrument.distribution.pause.ClockDriftPauseDetector;
import io.micrometer.core.instrument.distribution.pause.NoPauseDetector;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;
import org.LatencyUtils.SimplePauseDetector;

public class TimeWindowLatencyHistogram
extends TimeWindowHistogramBase<LatencyStats, Histogram>
implements AutoCloseable {
    private static Map<PauseDetector, org.LatencyUtils.PauseDetector> pauseDetectorCache = new ConcurrentHashMap<PauseDetector, org.LatencyUtils.PauseDetector>();
    private final org.LatencyUtils.PauseDetector pauseDetector;

    public TimeWindowLatencyHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig) {
        this(clock, distributionStatisticConfig, new ClockDriftPauseDetector(Duration.ofMillis(100L), Duration.ofMillis(100L)));
    }

    public TimeWindowLatencyHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        super(clock, distributionStatisticConfig, LatencyStats.class);
        this.pauseDetector = Objects.requireNonNull(pauseDetectorCache.computeIfAbsent(pauseDetector, detector -> {
            if (detector instanceof ClockDriftPauseDetector) {
                ClockDriftPauseDetector clockDriftPauseDetector = (ClockDriftPauseDetector)detector;
                return new SimplePauseDetector(clockDriftPauseDetector.getSleepInterval().toNanos(), clockDriftPauseDetector.getPauseThreshold().toNanos(), 1, false);
            }
            if (detector instanceof NoPauseDetector) {
                return new NoopPauseDetector();
            }
            return new NoopPauseDetector();
        }));
        this.initRingBuffer();
    }

    @Override
    LatencyStats newBucket(DistributionStatisticConfig distributionStatisticConfig) {
        return new LatencyStats.Builder().pauseDetector(this.pauseDetector).lowestTrackableLatency(distributionStatisticConfig.getMinimumExpectedValue().longValue()).highestTrackableLatency(distributionStatisticConfig.getMaximumExpectedValue().longValue()).numberOfSignificantValueDigits(2).build();
    }

    @Override
    void recordLong(LatencyStats bucket, long value) {
        bucket.recordLatency(value);
    }

    @Override
    void recordDouble(LatencyStats bucket, double value) {
        bucket.recordLatency((long)value);
    }

    @Override
    void resetBucket(LatencyStats bucket) {
        bucket.getIntervalHistogramInto((Histogram)NoopHistogram.INSTANCE);
    }

    Histogram newAccumulatedHistogram(LatencyStats[] ringBuffer) {
        return ringBuffer[0].getIntervalHistogram();
    }

    @Override
    void accumulate(LatencyStats sourceBucket, Histogram accumulatedHistogram) {
        sourceBucket.addIntervalHistogramTo(accumulatedHistogram);
    }

    @Override
    void resetAccumulatedHistogram(Histogram accumulatedHistogram) {
        accumulatedHistogram.reset();
    }

    @Override
    double valueAtPercentile(Histogram accumulatedHistogram, double percentile) {
        return accumulatedHistogram.getValueAtPercentile(percentile);
    }

    @Override
    double countAtValue(Histogram accumulatedHistogram, long value) {
        return accumulatedHistogram.getCountBetweenValues(0L, value);
    }

    @Override
    public void close() {
        this.pauseDetector.shutdown();
    }

    org.LatencyUtils.PauseDetector getPauseDetector() {
        return this.pauseDetector;
    }

    private static class NoopPauseDetector
    extends org.LatencyUtils.PauseDetector {
        NoopPauseDetector() {
            this.shutdown();
        }
    }
}

