/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.IoEventLoop;
import io.netty.channel.IoExecutionContext;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.local.LocalIoHandle;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.StringUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;

public final class LocalIoHandler
implements IoHandler {
    private final Set<LocalIoHandle> registeredChannels = new HashSet<LocalIoHandle>(64);
    private volatile Thread executionThread;

    private LocalIoHandler() {
    }

    public static IoHandlerFactory newFactory() {
        return new IoHandlerFactory(){

            @Override
            public IoHandler newHandler() {
                return new LocalIoHandler();
            }
        };
    }

    private static LocalIoHandle cast(IoHandle handle) {
        if (handle instanceof LocalIoHandle) {
            return (LocalIoHandle)handle;
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName((Object)handle) + " not supported");
    }

    @Override
    public int run(IoExecutionContext runner) {
        if (this.executionThread == null) {
            this.executionThread = Thread.currentThread();
        }
        if (runner.canBlock()) {
            LockSupport.parkNanos(this, runner.delayNanos(System.nanoTime()));
        }
        return 0;
    }

    @Override
    public void wakeup(IoEventLoop eventLoop) {
        Thread thread;
        if (!eventLoop.inEventLoop() && (thread = this.executionThread) != null) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public void prepareToDestroy() {
        for (LocalIoHandle handle : this.registeredChannels) {
            handle.closeNow();
        }
        this.registeredChannels.clear();
    }

    @Override
    public void destroy() {
    }

    @Override
    public IoRegistration register(IoEventLoop eventLoop, IoHandle handle) {
        LocalIoHandle localHandle = LocalIoHandler.cast(handle);
        if (this.registeredChannels.add(localHandle)) {
            LocalIoRegistration registration = new LocalIoRegistration(eventLoop, localHandle);
            localHandle.registerNow();
            return registration;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return LocalIoHandle.class.isAssignableFrom(handleType);
    }

    private final class LocalIoRegistration
    implements IoRegistration {
        private final Promise<?> cancellationPromise;
        private final IoEventLoop eventLoop;
        private final LocalIoHandle handle;

        LocalIoRegistration(IoEventLoop eventLoop, LocalIoHandle handle) {
            this.eventLoop = eventLoop;
            this.handle = handle;
            this.cancellationPromise = eventLoop.newPromise();
        }

        @Override
        public long submit(IoOps ops) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void cancel() {
            if (!this.cancellationPromise.trySuccess(null)) {
                return;
            }
            if (this.eventLoop.inEventLoop()) {
                this.cancel0();
            } else {
                this.eventLoop.execute(this::cancel0);
            }
        }

        @Override
        public Future<?> cancelFuture() {
            return this.cancellationPromise;
        }

        private void cancel0() {
            if (LocalIoHandler.this.registeredChannels.remove(this.handle)) {
                this.handle.deregisterNow();
            }
        }

        @Override
        public IoHandler ioHandler() {
            return LocalIoHandler.this;
        }
    }
}

