/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.testtools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;
import org.vertx.testtools.TestVerticle;
import org.vertx.testtools.TestVerticleInfo;

public class JavaClassRunner
extends BlockJUnit4ClassRunner {
    public static final String TESTRUNNER_HANDLER_ADDRESS = "vertx.testframework.handler";
    private static final Logger log = LoggerFactory.getLogger(JavaClassRunner.class);
    protected static final long TIMEOUT;
    private static final long DEFAULT_TIMEOUT = 300L;
    private final PlatformManager mgr;
    protected String main;
    private TestVerticleInfo annotation;

    public JavaClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.setTestProperties();
        this.mgr = PlatformLocator.factory.createPlatformManager();
    }

    private void setTestProperties() {
        String modsDir = null;
        File propsFile = new File("vertx.properties");
        if (propsFile.exists()) {
            this.loadProps(propsFile);
        } else {
            propsFile = new File("gradle.properties");
            if (propsFile.exists()) {
                this.loadProps(propsFile);
                modsDir = "build/mods";
            } else {
                File pom = new File("pom.xml");
                if (pom.exists()) {
                    try (Scanner scanner = new Scanner(pom).useDelimiter("\\A");){
                        String data = scanner.next();
                        String modOwner = this.extractTag(data, "groupId");
                        String modName = this.extractTag(data, "artifactId");
                        String version = this.extractTag(data, "version");
                        this.setModuleNameProp(modOwner, modName, version);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                    modsDir = "target/mods";
                }
            }
        }
        if (System.getProperty("vertx.mods") == null && modsDir != null) {
            System.setProperty("vertx.mods", modsDir);
        }
    }

    private void setModuleNameProp(String modOwner, String modName, String version) {
        String moduleName = modOwner + "~" + modName + "~" + version;
        System.setProperty("vertx.modulename", moduleName);
    }

    private String extractTag(String data, String tag) {
        int pos = data.indexOf("<" + tag + ">");
        int endPos = data.indexOf("</" + tag + ">");
        String value = data.substring(pos + tag.length() + 2, endPos);
        return value;
    }

    private void loadProps(File propsFile) {
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(propsFile.getName());){
            props.load(is);
            for (String propName : props.stringPropertyNames()) {
                String propVal = props.getProperty(propName);
                System.setProperty("vertx." + propName, propVal);
            }
            String modOwner = props.getProperty("modowner");
            if (modOwner != null) {
                this.setModuleNameProp(modOwner, props.getProperty("modname"), props.getProperty("version"));
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to load props file", (Throwable)e);
        }
    }

    protected TestVerticleInfo getAnnotation() {
        if (this.annotation == null) {
            Annotation[] anns;
            Class testClass = this.getTestClass().getJavaClass();
            for (Annotation aann : anns = testClass.getAnnotations()) {
                TestVerticleInfo tann;
                if (!(aann instanceof TestVerticleInfo)) continue;
                this.annotation = tann = (TestVerticleInfo)aann;
            }
        }
        return this.annotation;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        Class testClass = this.getTestClass().getJavaClass();
        if (!TestVerticle.class.isAssignableFrom(testClass)) {
            throw new IllegalArgumentException("Test classes must extend TestVerticle");
        }
        this.main = testClass.getName();
        List<FrameworkMethod> testMethods = this.getTestMethods();
        return testMethods;
    }

    protected List<FrameworkMethod> getTestMethods() {
        return super.computeTestMethods();
    }

    protected URL getClassPath(String methodName) {
        return null;
    }

    protected String getMain(String methodName) {
        return this.main;
    }

    public String getActualMethodName(String methodName) {
        return methodName;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Class testClass = this.getTestClass().getJavaClass();
        String methodName = method.getName();
        String testDesc = method.getName();
        Description desc = Description.createTestDescription((Class)testClass, (String)testDesc);
        notifier.fireTestStarted(desc);
        final AtomicReference failure = new AtomicReference();
        try {
            URL[] uRLArray;
            String includes;
            JsonObject conf = new JsonObject().putString("methodName", this.getActualMethodName(methodName));
            final CountDownLatch testLatch = new CountDownLatch(1);
            Handler<Message<JsonObject>> handler = new Handler<Message<JsonObject>>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void handle(Message<JsonObject> msg) {
                    JsonObject jmsg = (JsonObject)msg.body();
                    String type = jmsg.getString("type");
                    try {
                        switch (type) {
                            case "done": {
                                return;
                            }
                            case "failure": {
                                byte[] bytes = jmsg.getBinary("failure");
                                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
                                Throwable t = (Throwable)ois.readObject();
                                t.printStackTrace();
                                failure.set(t);
                                return;
                            }
                        }
                        return;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new IllegalArgumentException("Failed to deserialise error: " + e.getMessage(), e);
                    }
                    finally {
                        testLatch.countDown();
                    }
                }
            };
            EventBus eb = this.mgr.vertx().eventBus();
            eb.registerHandler(TESTRUNNER_HANDLER_ADDRESS, (Handler)handler);
            final CountDownLatch deployLatch = new CountDownLatch(1);
            final AtomicReference deploymentIDRef = new AtomicReference();
            TestVerticleInfo annotation = this.getAnnotation();
            if (annotation != null) {
                includes = this.getAnnotation().includes().trim();
                if (includes.isEmpty()) {
                    includes = null;
                }
            } else {
                includes = null;
            }
            System.out.println("Starting test: " + testDesc);
            String main = this.getMain(methodName);
            URL cp = this.getClassPath(methodName);
            final AtomicReference deployThrowable = new AtomicReference();
            if (cp == null) {
                uRLArray = new URL[]{};
            } else {
                URL[] uRLArray2 = new URL[1];
                uRLArray = uRLArray2;
                uRLArray2[0] = cp;
            }
            this.mgr.deployVerticle(main, conf, uRLArray, 1, includes, (Handler)new AsyncResultHandler<String>(){

                public void handle(AsyncResult<String> ar) {
                    if (ar.succeeded()) {
                        deploymentIDRef.set(ar.result());
                    } else {
                        deployThrowable.set(ar.cause());
                    }
                    deployLatch.countDown();
                }
            });
            this.waitForLatch(deployLatch);
            if (deployThrowable.get() != null) {
                throw new IllegalStateException("Failed to deploy", (Throwable)deployThrowable.get());
            }
            this.waitForLatch(testLatch);
            eb.unregisterHandler(TESTRUNNER_HANDLER_ADDRESS, (Handler)handler);
            final CountDownLatch undeployLatch = new CountDownLatch(1);
            final AtomicReference undeployThrowable = new AtomicReference();
            this.mgr.undeploy((String)deploymentIDRef.get(), (Handler)new AsyncResultHandler<Void>(){

                public void handle(AsyncResult<Void> ar) {
                    if (ar.failed()) {
                        undeployThrowable.set(ar.cause());
                    }
                    undeployLatch.countDown();
                }
            });
            this.waitForLatch(undeployLatch);
            if (undeployThrowable.get() != null) {
                throw new IllegalStateException("Failed to undeploy", (Throwable)undeployThrowable.get());
            }
            if (failure.get() != null) {
                notifier.fireTestFailure(new Failure(desc, (Throwable)failure.get()));
                if (failure.get() instanceof Error) {
                    throw (Error)failure.get();
                }
            } else {
                notifier.fireTestFinished(desc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void waitForLatch(CountDownLatch latch) {
        while (true) {
            try {
                if (!latch.await(TIMEOUT, TimeUnit.SECONDS)) {
                    throw new AssertionError((Object)"Timed out waiting for test to complete");
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static {
        String timeout = System.getProperty("vertx.test.timeout");
        TIMEOUT = timeout == null ? 300L : Long.valueOf(timeout);
    }
}

