/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.testtools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.vertx.testtools.JavaClassRunner;
import org.vertx.testtools.TestVerticleInfo;

public class ScriptClassRunner
extends JavaClassRunner {
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String TEST_SCRIPTS_DIR = "src/test/resources".replace("/", FILE_SEP);

    public ScriptClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    @Override
    protected List<FrameworkMethod> getTestMethods() {
        ArrayList<FrameworkMethod> meths = new ArrayList<FrameworkMethod>();
        TestVerticleInfo ann = this.getAnnotation();
        if (ann == null) {
            throw new IllegalArgumentException("Please annotate your test classes with TestVerticleInfo");
        }
        String funcRegex = ann.funcRegex();
        File scriptsDir = new File(TEST_SCRIPTS_DIR);
        if (!scriptsDir.exists()) {
            throw new IllegalArgumentException("Scripts directory does not exist: " + scriptsDir);
        }
        RegExFileNameFilter filter = new RegExFileNameFilter(ann.filenameFilter());
        List<File> testScripts = this.findTestFiles(scriptsDir, filter);
        if (testScripts.isEmpty()) {
            throw new IllegalStateException("There are no scripts in directory " + scriptsDir + " or child directories, matching filter " + filter);
        }
        Pattern funcPattern = Pattern.compile(funcRegex);
        for (File scriptFile : testScripts) {
            Path scriptFilePath = scriptFile.toPath();
            Path parent = scriptFilePath.getParent();
            Path filename = scriptFilePath.getFileName();
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(scriptFile));
                Throwable throwable = null;
                try {
                    StringBuilder sb = new StringBuilder();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line).append("\n");
                        line = br.readLine();
                    }
                    br.close();
                    Matcher m = funcPattern.matcher(sb.toString());
                    while (m.find()) {
                        String methodName = m.group(1);
                        DummyFrameWorkMethod meth = new DummyFrameWorkMethod(parent + "|" + filename + "|" + methodName);
                        meths.add(meth);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read script " + scriptFile);
            }
        }
        if (meths.isEmpty()) {
            throw new IllegalStateException("There are no test methods in the tests sctripts");
        }
        return meths;
    }

    private List<File> findTestFiles(File dir, FilenameFilter filter) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles(filter)) {
            if (file.isDirectory()) {
                list.addAll(this.findTestFiles(file, filter));
                continue;
            }
            list.add(file);
        }
        return list;
    }

    @Override
    protected URL getClassPath(String methodName) {
        try {
            return new File(methodName.split("\\|")[0]).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected String getMain(String methodName) {
        return methodName.split("\\|")[1];
    }

    @Override
    public String getActualMethodName(String methodName) {
        return methodName.split("\\|")[2];
    }

    @Override
    protected List<FrameworkMethod> computeTestMethods() {
        return this.getTestMethods();
    }

    private class RegExFileNameFilter
    implements FilenameFilter {
        final Pattern pattern;

        RegExFileNameFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean accept(File dir, String name) {
            File f = new File(dir, name);
            return f.isDirectory() || this.pattern.matcher(name).matches();
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    private class DummyFrameWorkMethod
    extends FrameworkMethod {
        String methodName;

        DummyFrameWorkMethod(String methodName) {
            super(null);
            this.methodName = methodName;
        }

        public Object invokeExplosively(Object target, Object ... params) throws Throwable {
            return null;
        }

        public String getName() {
            return this.methodName;
        }

        public void validatePublicVoidNoArg(boolean isStatic, List<Throwable> errors) {
        }

        public void validatePublicVoid(boolean isStatic, List<Throwable> errors) {
        }

        public void validateNoTypeParametersOnArgs(List<Throwable> errors) {
        }

        public boolean isShadowedBy(FrameworkMethod other) {
            return false;
        }

        public Annotation[] getAnnotations() {
            return null;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return null;
        }
    }
}

