/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.properties.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import io.vertx.ext.auth.properties.PropertyFileAuthentication;
import io.vertx.ext.auth.properties.PropertyFileAuthorization;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PropertyFileAuthenticationImpl
implements PropertyFileAuthentication,
PropertyFileAuthorization {
    private static final Logger logger = LoggerFactory.getLogger((String)PropertyFileAuthentication.class.getName());
    private final String path;
    private final Map<String, User> users = new HashMap<String, User>();

    public PropertyFileAuthenticationImpl(Vertx vertx, String path) {
        String[] lines;
        Objects.requireNonNull(vertx);
        this.path = Objects.requireNonNull(path);
        HashMap<String, Role> roles = new HashMap<String, Role>();
        String fileContent = vertx.fileSystem().readFileBlocking(path).toString(StandardCharsets.UTF_8);
        for (String line : lines = fileContent.split("\n")) {
            String tmpName;
            int index;
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("user.")) {
                String tmpRoles;
                logger.debug((Object)("read user line: " + line));
                String usernameAndRoles = line.substring(5);
                index = usernameAndRoles.indexOf(61);
                tmpName = index > 0 ? usernameAndRoles.substring(0, index).trim() : "";
                String string = tmpRoles = index > 0 ? usernameAndRoles.substring(index + 1).trim() : "";
                if (tmpName.length() > 0) {
                    User user = new User(tmpName);
                    this.users.put(tmpName, user);
                    int roleIndex = 0;
                    String[] stringArray = tmpRoles.split(",");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String tmpRole = stringArray[i];
                        tmpRole = tmpRole.trim();
                        if (roleIndex == 0) {
                            user.password = tmpRole;
                        } else if (tmpRole.length() > 0) {
                            Role role = (Role)roles.get(tmpRole);
                            if (role == null) {
                                role = new Role(tmpRole);
                                roles.put(tmpRole, role);
                            }
                            user.addRole(role);
                        }
                        ++roleIndex;
                    }
                    continue;
                }
                logger.warn((Object)("read blank username - " + line));
                continue;
            }
            if (line.startsWith("role.")) {
                String tmpProperties;
                logger.debug((Object)("read role line - " + line));
                String roleAndProperties = line.substring(5);
                index = roleAndProperties.indexOf(61);
                tmpName = index > 0 ? roleAndProperties.substring(0, index).trim() : "";
                String string = tmpProperties = index > 0 ? roleAndProperties.substring(index + 1).trim() : "";
                if (tmpName.length() > 0) {
                    Role role = (Role)roles.get(tmpName);
                    if (role == null) {
                        role = new Role(tmpName);
                        roles.put(tmpName, role);
                    }
                    for (String tmpProperty : tmpProperties.split(",")) {
                        if ((tmpProperty = tmpProperty.trim()).length() <= 0) continue;
                        role.addPermission(tmpProperty);
                    }
                    continue;
                }
                logger.warn((Object)("read blank role - " + line));
                continue;
            }
            logger.warn((Object)("read unknown line - " + line));
        }
    }

    private Future<User> getUser(String username) {
        if (!this.users.containsKey(username)) {
            return Future.failedFuture((String)"unknown user");
        }
        return Future.succeededFuture((Object)this.users.get(username));
    }

    public Future<io.vertx.ext.auth.User> authenticate(Credentials credentials) {
        UsernamePasswordCredentials authInfo;
        try {
            try {
                authInfo = (UsernamePasswordCredentials)credentials;
            }
            catch (ClassCastException e) {
                throw new CredentialValidationException("Invalid credentials type", (Throwable)e);
            }
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        return this.getUser(authInfo.getUsername()).compose(propertyUser -> {
            if (Objects.equals(propertyUser.password, authInfo.getPassword())) {
                io.vertx.ext.auth.User user = io.vertx.ext.auth.User.fromName((String)propertyUser.name);
                user.principal().put("amr", Collections.singletonList("pwd"));
                return Future.succeededFuture((Object)user);
            }
            return Future.failedFuture((String)"invalid username/password");
        });
    }

    public String getId() {
        return this.path;
    }

    public Future<Void> getAuthorizations(io.vertx.ext.auth.User user) {
        String username = user.principal().getString("username");
        return this.getUser(username).onSuccess(record -> {
            HashSet<Object> result = new HashSet<Object>();
            for (Role role : record.roles.values()) {
                result.add(RoleBasedAuthorization.create((String)role.name));
                for (String permission : role.permissions) {
                    result.add(WildcardPermissionBasedAuthorization.create((String)permission));
                }
            }
            user.authorizations().put(this.getId(), result);
        }).mapEmpty();
    }

    private static class Role {
        final String name;
        final Set<String> permissions;

        private Role(String name) {
            this.name = Objects.requireNonNull(name);
            this.permissions = new HashSet<String>();
        }

        private void addPermission(String permission) {
            Objects.requireNonNull(permission);
            this.permissions.add(permission);
        }
    }

    private static class User {
        final String name;
        String password;
        final Map<String, Role> roles;

        private User(String name) {
            this.name = Objects.requireNonNull(name);
            this.roles = new HashMap<String, Role>();
        }

        private void addRole(Role role) {
            Objects.requireNonNull(role);
            this.roles.put(role.name, role);
        }
    }
}

