/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.camel.impl;

import io.vertx.camel.InboundMapping;
import io.vertx.camel.impl.CamelHelper;
import io.vertx.camel.impl.MultiMapHelper;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.AsyncProcessorHelper;
import org.apache.camel.support.ExchangeHelper;

public class CamelToVertxProcessor
implements AsyncProcessor {
    private final Vertx vertx;
    private final InboundMapping inbound;

    public CamelToVertxProcessor(Vertx vertx, InboundMapping inbound) {
        this.vertx = vertx;
        this.inbound = inbound;
    }

    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process((AsyncProcessor)this, (Exchange)exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getIn();
        Object body = CamelHelper.convert(this.inbound, in);
        DeliveryOptions delivery = CamelHelper.getDeliveryOptions(in, this.inbound.isHeadersCopy());
        if (this.inbound.getTimeout() > 0) {
            delivery.setSendTimeout((long)this.inbound.getTimeout());
        }
        try {
            if (this.inbound.isPublish()) {
                this.vertx.eventBus().publish(this.inbound.getAddress(), body, delivery);
            } else {
                if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                    this.vertx.eventBus().request(this.inbound.getAddress(), body, delivery).onComplete(reply -> {
                        Message out = exchange.getOut();
                        if (reply.succeeded()) {
                            out.setBody(((io.vertx.core.eventbus.Message)reply.result()).body());
                            MultiMapHelper.toMap(((io.vertx.core.eventbus.Message)reply.result()).headers(), out.getHeaders());
                        } else {
                            exchange.setException(reply.cause());
                        }
                        callback.done(false);
                    });
                    return false;
                }
                this.vertx.eventBus().send(this.inbound.getAddress(), body, delivery);
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter callback = new AsyncCallbackToCompletableFutureAdapter((Object)exchange);
        this.process(exchange, (AsyncCallback)callback);
        return callback.getFuture();
    }
}

