/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;

public class FileConfigStore
implements ConfigStore {
    private final VertxInternal vertx;
    private final String path;

    public FileConfigStore(Vertx vertx, JsonObject configuration) {
        this.vertx = (VertxInternal)vertx;
        this.path = configuration.getString("path");
        if (this.path == null) {
            throw new IllegalArgumentException("The `path` configuration is required.");
        }
    }

    @Override
    public Future<Buffer> get() {
        return this.vertx.fileSystem().readFile(this.path);
    }

    @Override
    public Future<Void> close() {
        return this.vertx.getOrCreateContext().succeededFuture();
    }
}

