/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventListConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class EventList {
    private long index;
    private List<Event> list;

    public EventList() {
    }

    public EventList(EventList other) {
        this.index = other.index;
        this.list = other.list;
    }

    public EventList(JsonObject json) {
        EventListConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        EventListConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public long getIndex() {
        return this.index;
    }

    public EventList setIndex(long index) {
        this.index = index;
        return this;
    }

    public List<Event> getList() {
        return this.list;
    }

    public EventList setList(List<Event> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventList eventList = (EventList)o;
        if (this.index != eventList.index) {
            return false;
        }
        return this.list != null ? this.sorted().equals(eventList.sorted()) : eventList.list == null;
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.list != null ? this.sorted().hashCode() : 0);
        return result;
    }

    private List<Event> sorted() {
        ArrayList<Event> sorted = null;
        if (this.list != null) {
            sorted = new ArrayList<Event>(this.list);
            sorted.sort(Comparator.comparing(Event::getId));
        }
        return sorted;
    }
}

